/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.IDockingPort;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

class DockingSplitPane
extends JSplitPane {
    private static final long serialVersionUID = -1165035020321526941L;
    protected IDockingPort dockingPort;
    protected String region;
    protected boolean dividerLocDetermined;
    protected boolean controllerInTopLeft;
    protected double initialDividerRatio = 0.5;

    public DockingSplitPane(IDockingPort port, String region) {
        if (port == null) {
            throw new IllegalArgumentException("'port' cannot be null.");
        }
        if (!DockingManager.isValidDockingRegion(region)) {
            throw new IllegalArgumentException("'" + region + "' is not a valid region.");
        }
        this.region = region;
        this.dockingPort = port;
        this.controllerInTopLeft = !DockingUtility.isRegionTopLeft(region);
        boolean weight = this.controllerInTopLeft;
        this.setResizeWeight((double)weight);
        final BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        if (divider != null) {
            divider.setBorder(null);
            divider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
                        ((JSplitPane)divider.getParent()).resetToPreferredSizes();
                    }
                }
            });
        }
    }

    @Override
    public void resetToPreferredSizes() {
        Insets i = this.getInsets();
        if (this.getOrientation() == 0) {
            int bottomH;
            int topH;
            int h = this.getHeight() - i.top - i.bottom - this.getDividerSize();
            int extraSpace = h - (topH = this.getTopComponent().getPreferredSize().height) - (bottomH = this.getBottomComponent().getPreferredSize().height);
            if (extraSpace >= 0) {
                this.setDividerLocation(i.top + topH + (int)((double)extraSpace * this.getResizeWeight() + 0.5));
            }
        } else {
            int rightH;
            int leftH;
            int w = this.getWidth() - i.left - i.right - this.getDividerSize();
            int extraSpace = w - (leftH = this.getLeftComponent().getPreferredSize().width) - (rightH = this.getRightComponent().getPreferredSize().width);
            if (extraSpace >= 0) {
                this.setDividerLocation(i.left + leftH + (int)((double)extraSpace * this.getResizeWeight() + 0.5));
            }
        }
    }

    protected boolean isDividerSizeProperlyDetermined() {
        if (this.getDividerLocation() != 0) {
            return true;
        }
        return this.dividerLocDetermined;
    }

    public Component getElderComponent() {
        Component c;
        Component component = c = this.controllerInTopLeft ? this.getLeftComponent() : this.getRightComponent();
        if (c instanceof IDockingPort) {
            c = ((IDockingPort)((Object)c)).getDockedComponent();
        }
        return c;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean isElderTopLeft() {
        return this.controllerInTopLeft;
    }

    void cleanup() {
        this.dockingPort = null;
    }

    public void setInitialDividerRatio(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException("ratio (" + ratio + ") must be between [0.0, 1.0] inclusive");
        }
        this.initialDividerRatio = ratio;
    }

    @Override
    public void doLayout() {
        if (!this.isDividerSizeProperlyDetermined()) {
            this.dividerLocDetermined = true;
            this.setDividerLocation(this.initialDividerRatio);
        }
        super.doLayout();
    }

    protected void finalize() throws Throwable {
        this.cleanup();
    }
}

