/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Filter;
import net.sf.mpxj.FilterContainer;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.mpp.BackgroundPattern;
import net.sf.mpxj.mpp.ChartPattern;
import net.sf.mpxj.mpp.ColorType;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.FontStyle;
import net.sf.mpxj.mpp.GanttBarDateFormat;
import net.sf.mpxj.mpp.GanttBarStyle;
import net.sf.mpxj.mpp.GanttBarStyleException;
import net.sf.mpxj.mpp.GenericView;
import net.sf.mpxj.mpp.GridLines;
import net.sf.mpxj.mpp.Interval;
import net.sf.mpxj.mpp.LineStyle;
import net.sf.mpxj.mpp.LinkStyle;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.NonWorkingTimeStyle;
import net.sf.mpxj.mpp.ProgressLineDay;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props9;
import net.sf.mpxj.mpp.TableFontStyle;
import net.sf.mpxj.mpp.TimescaleTier;
import net.sf.mpxj.mpp.Var2Data;

public abstract class GanttChartView
extends GenericView {
    protected GridLines m_sheetRowsGridLines;
    protected GridLines m_sheetColumnsGridLines;
    protected GridLines m_titleVerticalGridLines;
    protected GridLines m_titleHorizontalGridLines;
    protected GridLines m_middleTierColumnGridLines;
    protected GridLines m_bottomTierColumnGridLines;
    protected GridLines m_ganttRowsGridLines;
    protected GridLines m_barRowsGridLines;
    protected GridLines m_currentDateGridLines;
    protected GridLines m_pageBreakGridLines;
    protected GridLines m_projectStartGridLines;
    protected GridLines m_projectFinishGridLines;
    protected GridLines m_statusDateGridLines;
    protected GridLines m_topTierColumnGridLines;
    protected int m_ganttBarHeight;
    protected TimescaleTier m_timescaleTopTier;
    protected TimescaleTier m_timescaleMiddleTier;
    protected TimescaleTier m_timescaleBottomTier;
    protected boolean m_timescaleScaleSeparator;
    protected int m_timescaleSize;
    protected int m_timescaleShowTiers;
    protected String m_nonWorkingDaysCalendarName;
    protected Color m_nonWorkingColor;
    protected ChartPattern m_nonWorkingPattern;
    protected NonWorkingTimeStyle m_nonWorkingStyle;
    protected boolean m_showDrawings;
    protected boolean m_roundBarsToWholeDays;
    protected boolean m_showBarSplits;
    protected boolean m_alwaysRollupGanttBars;
    protected boolean m_hideRollupBarsWhenSummaryExpanded;
    protected GanttBarDateFormat m_barDateFormat;
    protected LinkStyle m_linkStyle;
    protected GanttBarStyle[] m_barStyles;
    protected GanttBarStyleException[] m_barStyleExceptions;
    private int m_tableWidth;
    private String m_defaultFilterName;
    private String m_groupName;
    private boolean m_highlightFilter;
    private boolean m_showInMenu;
    protected FontStyle m_highlightedTasksFontStyle;
    protected FontStyle m_rowAndColumnFontStyle;
    protected FontStyle m_nonCriticalTasksFontStyle;
    protected FontStyle m_criticalTasksFontStyle;
    protected FontStyle m_summaryTasksFontStyle;
    protected FontStyle m_milestoneTasksFontStyle;
    protected FontStyle m_topTimescaleFontStyle;
    protected FontStyle m_middleTimescaleFontStyle;
    protected FontStyle m_bottomTimescaleFontStyle;
    protected FontStyle m_barTextLeftFontStyle;
    protected FontStyle m_barTextRightFontStyle;
    protected FontStyle m_barTextTopFontStyle;
    protected FontStyle m_barTextBottomFontStyle;
    protected FontStyle m_barTextInsideFontStyle;
    protected FontStyle m_markedTasksFontStyle;
    protected FontStyle m_projectSummaryTasksFontStyle;
    protected FontStyle m_externalTasksFontStyle;
    protected TableFontStyle[] m_tableFontStyles;
    protected boolean m_progressLinesEnabled;
    protected boolean m_progressLinesAtCurrentDate;
    protected boolean m_progressLinesAtRecurringIntervals;
    protected Interval m_progressLinesInterval;
    protected int m_progressLinesIntervalDailyDayNumber;
    protected boolean m_progressLinesIntervalDailyWorkday;
    protected boolean[] m_progressLinesIntervalWeeklyDay = new boolean[8];
    protected int m_progressLinesIntervalWeekleyWeekNumber;
    protected boolean m_progressLinesIntervalMonthlyDay;
    protected int m_progressLinesIntervalMonthlyDayDayNumber;
    protected int m_progressLinesIntervalMonthlyDayMonthNumber;
    protected ProgressLineDay m_progressLinesIntervalMonthlyFirstLastDay;
    protected boolean m_progressLinesIntervalMonthlyFirstLast;
    protected int m_progressLinesIntervalMonthlyFirstLastMonthNumber;
    protected boolean m_progressLinesBeginAtProjectStart;
    protected Date m_progressLinesBeginAtDate;
    protected boolean m_progressLinesDisplaySelected;
    protected Date[] m_progressLinesDisplaySelectedDates;
    protected boolean m_progressLinesActualPlan;
    protected int m_progressLinesDisplayType;
    protected boolean m_progressLinesShowDate;
    protected int m_progressLinesDateFormat;
    protected FontStyle m_progressLinesFontStyle;
    protected Color m_progressLinesCurrentLineColor;
    protected LineStyle m_progressLinesCurrentLineStyle;
    protected Color m_progressLinesCurrentProgressPointColor;
    protected int m_progressLinesCurrentProgressPointShape;
    protected Color m_progressLinesOtherLineColor;
    protected LineStyle m_progressLinesOtherLineStyle;
    protected Color m_progressLinesOtherProgressPointColor;
    protected int m_progressLinesOtherProgressPointShape;
    protected List<Filter> m_autoFilters = new ArrayList<Filter>();
    protected Map<FieldType, Filter> m_autoFiltersByType = new HashMap<FieldType, Filter>();
    private FilterContainer m_filters;
    protected static final Integer VIEW_PROPERTIES = 574619656;
    protected static final Integer TIMESCALE_PROPERTIES = 574619678;
    private static final Integer TABLE_PROPERTIES = 574619655;
    private static final Integer FILTER_NAME = 574619659;
    private static final Integer GROUP_NAME = 574619672;
    private static final Integer COLUMN_PROPERTIES = 574619660;
    private static final Integer PROGRESS_LINE_PROPERTIES = 574619671;
    private static final Integer AUTO_FILTER_PROPERTIES = 574619669;

    protected abstract void processDefaultBarStyles(Props var1);

    protected abstract void processExceptionBarStyles(Props var1);

    protected abstract void processAutoFilters(byte[] var1);

    protected abstract void processViewProperties(Map<Integer, FontBase> var1, Props var2);

    protected abstract void processTableFontStyles(Map<Integer, FontBase> var1, byte[] var2);

    protected abstract void processProgressLines(Map<Integer, FontBase> var1, byte[] var2);

    GanttChartView(ProjectFile parent, byte[] fixedMeta, byte[] fixedData, Var2Data varData, Map<Integer, FontBase> fontBases) throws IOException {
        super(parent, fixedData, varData);
        this.m_filters = parent.getFilters();
        this.m_showInMenu = (fixedMeta[8] & 8) != 0;
        byte[] propsData = varData.getByteArray(this.m_id, this.getPropertiesID());
        if (propsData != null) {
            byte[] autoFilterData;
            byte[] progressLineData;
            byte[] groupName;
            byte[] filterName;
            Props9 props = new Props9(new ByteArrayInputStream(propsData));
            byte[] tableData = props.getByteArray(TABLE_PROPERTIES);
            if (tableData != null) {
                this.m_tableWidth = MPPUtility.getShort(tableData, 35);
                boolean bl = this.m_highlightFilter = tableData[7] != 0;
            }
            if ((filterName = props.getByteArray(FILTER_NAME)) != null) {
                this.m_defaultFilterName = MPPUtility.getUnicodeString(filterName, 0);
            }
            if ((groupName = props.getByteArray(GROUP_NAME)) != null) {
                this.m_groupName = MPPUtility.getUnicodeString(groupName, 0);
            }
            this.processViewProperties(fontBases, props);
            this.processDefaultBarStyles(props);
            this.processExceptionBarStyles(props);
            byte[] columnData = props.getByteArray(COLUMN_PROPERTIES);
            if (columnData != null) {
                this.processTableFontStyles(fontBases, columnData);
            }
            if ((progressLineData = props.getByteArray(PROGRESS_LINE_PROPERTIES)) != null) {
                this.processProgressLines(fontBases, progressLineData);
            }
            if ((autoFilterData = props.getByteArray(AUTO_FILTER_PROPERTIES)) != null) {
                this.processAutoFilters(autoFilterData);
            }
        }
    }

    public GridLines getSheetColumnsGridLines() {
        return this.m_sheetColumnsGridLines;
    }

    public GridLines getSheetRowsGridLines() {
        return this.m_sheetRowsGridLines;
    }

    public GridLines getStatusDateGridLines() {
        return this.m_statusDateGridLines;
    }

    public GridLines getTitleHorizontalGridLines() {
        return this.m_titleHorizontalGridLines;
    }

    public GridLines getTitleVerticalGridLines() {
        return this.m_titleVerticalGridLines;
    }

    public GridLines getBarRowsGridLines() {
        return this.m_barRowsGridLines;
    }

    public GridLines getCurrentDateGridLines() {
        return this.m_currentDateGridLines;
    }

    public GridLines getGanttRowsGridLines() {
        return this.m_ganttRowsGridLines;
    }

    public GridLines getTopTierColumnGridLines() {
        return this.m_topTierColumnGridLines;
    }

    public GridLines getMiddleTierColumnGridLines() {
        return this.m_middleTierColumnGridLines;
    }

    public GridLines getBottomTierColumnGridLines() {
        return this.m_bottomTierColumnGridLines;
    }

    public String getNonWorkingDaysCalendarName() {
        return this.m_nonWorkingDaysCalendarName;
    }

    public GridLines getPageBreakGridLines() {
        return this.m_pageBreakGridLines;
    }

    public GridLines getProjectFinishGridLines() {
        return this.m_projectFinishGridLines;
    }

    public GridLines getProjectStartGridLines() {
        return this.m_projectStartGridLines;
    }

    public int getGanttBarHeight() {
        return this.m_ganttBarHeight;
    }

    public boolean getTimescaleScaleSeparator() {
        return this.m_timescaleScaleSeparator;
    }

    public TimescaleTier getTimescaleTopTier() {
        return this.m_timescaleTopTier;
    }

    public TimescaleTier getTimescaleMiddleTier() {
        return this.m_timescaleMiddleTier;
    }

    public TimescaleTier getTimescaleBottomTier() {
        return this.m_timescaleBottomTier;
    }

    public int getTimescaleSize() {
        return this.m_timescaleSize;
    }

    public int getTimescaleShowTiers() {
        return this.m_timescaleShowTiers;
    }

    public Color getNonWorkingColor() {
        return this.m_nonWorkingColor;
    }

    public ChartPattern getNonWorkingPattern() {
        return this.m_nonWorkingPattern;
    }

    public NonWorkingTimeStyle getNonWorkingStyle() {
        return this.m_nonWorkingStyle;
    }

    public boolean getAlwaysRollupGanttBars() {
        return this.m_alwaysRollupGanttBars;
    }

    public GanttBarDateFormat getBarDateFormat() {
        return this.m_barDateFormat;
    }

    public boolean getHideRollupBarsWhenSummaryExpanded() {
        return this.m_hideRollupBarsWhenSummaryExpanded;
    }

    public LinkStyle getLinkStyle() {
        return this.m_linkStyle;
    }

    public boolean getRoundBarsToWholeDays() {
        return this.m_roundBarsToWholeDays;
    }

    public boolean getShowBarSplits() {
        return this.m_showBarSplits;
    }

    public boolean getShowDrawings() {
        return this.m_showDrawings;
    }

    public GanttBarStyleException[] getBarStyleExceptions() {
        return this.m_barStyleExceptions;
    }

    public GanttBarStyle[] getBarStyles() {
        return this.m_barStyles;
    }

    public int getTableWidth() {
        return this.m_tableWidth;
    }

    public String getDefaultFilterName() {
        return this.m_defaultFilterName;
    }

    public Filter getDefaultFilter() {
        return this.m_filters.getFilterByName(this.m_defaultFilterName);
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public boolean getHighlightFilter() {
        return this.m_highlightFilter;
    }

    public boolean getShowInMenu() {
        return this.m_showInMenu;
    }

    public FontStyle getBarTextBottomFontStyle() {
        return this.m_barTextBottomFontStyle;
    }

    public FontStyle getBarTextInsideFontStyle() {
        return this.m_barTextInsideFontStyle;
    }

    public FontStyle getBarTextLeftFontStyle() {
        return this.m_barTextLeftFontStyle;
    }

    public FontStyle getBarTextRightFontStyle() {
        return this.m_barTextRightFontStyle;
    }

    public FontStyle getBarTextTopFontStyle() {
        return this.m_barTextTopFontStyle;
    }

    public FontStyle getCriticalTasksFontStyle() {
        return this.m_criticalTasksFontStyle;
    }

    public FontStyle getExternalTasksFontStyle() {
        return this.m_externalTasksFontStyle;
    }

    public FontStyle getHighlightedTasksFontStyle() {
        return this.m_highlightedTasksFontStyle;
    }

    public FontStyle getTopTimescaleFontStyle() {
        return this.m_topTimescaleFontStyle;
    }

    public FontStyle getMiddleTimescaleFontStyle() {
        return this.m_middleTimescaleFontStyle;
    }

    public FontStyle getMarkedTasksFontStyle() {
        return this.m_markedTasksFontStyle;
    }

    public FontStyle getMilestoneTasksFontStyle() {
        return this.m_milestoneTasksFontStyle;
    }

    public FontStyle getBottomTimescaleFontStyle() {
        return this.m_bottomTimescaleFontStyle;
    }

    public FontStyle getNonCriticalTasksFontStyle() {
        return this.m_nonCriticalTasksFontStyle;
    }

    public FontStyle getProjectSummaryTasksFontStyle() {
        return this.m_projectSummaryTasksFontStyle;
    }

    public FontStyle getRowAndColumnFontStyle() {
        return this.m_rowAndColumnFontStyle;
    }

    public FontStyle getSummaryTasksFontStyle() {
        return this.m_summaryTasksFontStyle;
    }

    public TableFontStyle[] getTableFontStyles() {
        return this.m_tableFontStyles;
    }

    public boolean getProgressLinesActualPlan() {
        return this.m_progressLinesActualPlan;
    }

    public boolean getProgressLinesAtCurrentDate() {
        return this.m_progressLinesAtCurrentDate;
    }

    public boolean getProgressLinesAtRecurringIntervals() {
        return this.m_progressLinesAtRecurringIntervals;
    }

    public Date getProgressLinesBeginAtDate() {
        return this.m_progressLinesBeginAtDate;
    }

    public boolean getProgressLinesBeginAtProjectStart() {
        return this.m_progressLinesBeginAtProjectStart;
    }

    public Color getProgressLinesCurrentLineColor() {
        return this.m_progressLinesCurrentLineColor;
    }

    public LineStyle getProgressLinesCurrentLineStyle() {
        return this.m_progressLinesCurrentLineStyle;
    }

    public Color getProgressLinesCurrentProgressPointColor() {
        return this.m_progressLinesCurrentProgressPointColor;
    }

    public int getProgressLinesCurrentProgressPointShape() {
        return this.m_progressLinesCurrentProgressPointShape;
    }

    public int getProgressLinesIntervalDailyDayNumber() {
        return this.m_progressLinesIntervalDailyDayNumber;
    }

    public boolean isProgressLinesIntervalDailyWorkday() {
        return this.m_progressLinesIntervalDailyWorkday;
    }

    public int getProgressLinesDateFormat() {
        return this.m_progressLinesDateFormat;
    }

    public boolean getProgressLinesDisplaySelected() {
        return this.m_progressLinesDisplaySelected;
    }

    public Date[] getProgressLinesDisplaySelectedDates() {
        return this.m_progressLinesDisplaySelectedDates;
    }

    public int getProgressLinesDisplayType() {
        return this.m_progressLinesDisplayType;
    }

    public boolean getProgressLinesEnabled() {
        return this.m_progressLinesEnabled;
    }

    public FontStyle getProgressLinesFontStyle() {
        return this.m_progressLinesFontStyle;
    }

    public Interval getProgressLinesInterval() {
        return this.m_progressLinesInterval;
    }

    public ProgressLineDay getProgressLinesIntervalMonthlyFirstLastDay() {
        return this.m_progressLinesIntervalMonthlyFirstLastDay;
    }

    public int getProgressLinesIntervalMonthlyFirstLastMonthNumber() {
        return this.m_progressLinesIntervalMonthlyFirstLastMonthNumber;
    }

    public int getProgressLinesIntervalMonthlyDayDayNumber() {
        return this.m_progressLinesIntervalMonthlyDayDayNumber;
    }

    public boolean getProgressLinesIntervalMonthlyDay() {
        return this.m_progressLinesIntervalMonthlyDay;
    }

    public int getProgressLinesIntervalMonthlyDayMonthNumber() {
        return this.m_progressLinesIntervalMonthlyDayMonthNumber;
    }

    public boolean getProgressLinesIntervalMonthlyFirstLast() {
        return this.m_progressLinesIntervalMonthlyFirstLast;
    }

    public Color getProgressLinesOtherLineColor() {
        return this.m_progressLinesOtherLineColor;
    }

    public LineStyle getProgressLinesOtherLineStyle() {
        return this.m_progressLinesOtherLineStyle;
    }

    public Color getProgressLinesOtherProgressPointColor() {
        return this.m_progressLinesOtherProgressPointColor;
    }

    public int getProgressLinesOtherProgressPointShape() {
        return this.m_progressLinesOtherProgressPointShape;
    }

    public boolean getProgressLinesShowDate() {
        return this.m_progressLinesShowDate;
    }

    public int getProgressLinesIntervalWeekleyWeekNumber() {
        return this.m_progressLinesIntervalWeekleyWeekNumber;
    }

    public boolean[] getProgressLinesIntervalWeeklyDay() {
        return this.m_progressLinesIntervalWeeklyDay;
    }

    protected int mapGanttBarHeight(int height) {
        switch (height) {
            case 0: {
                height = 6;
                break;
            }
            case 1: {
                height = 8;
                break;
            }
            case 2: {
                height = 10;
                break;
            }
            case 3: {
                height = 12;
                break;
            }
            case 4: {
                height = 14;
                break;
            }
            case 5: {
                height = 18;
                break;
            }
            case 6: {
                height = 24;
            }
        }
        return height;
    }

    protected FontStyle getFontStyle(byte[] data, int offset, Map<Integer, FontBase> fontBases) {
        Integer index = MPPUtility.getByte(data, offset);
        FontBase fontBase = fontBases.get(index);
        int style = MPPUtility.getByte(data, offset + 1);
        ColorType color = ColorType.getInstance(MPPUtility.getByte(data, offset + 2));
        boolean bold = (style & 1) != 0;
        boolean italic = (style & 2) != 0;
        boolean underline = (style & 4) != 0;
        FontStyle fontStyle = new FontStyle(fontBase, italic, bold, underline, false, color.getColor(), null, BackgroundPattern.SOLID);
        return fontStyle;
    }

    protected TableFontStyle getColumnFontStyle(byte[] data, int offset, Map<Integer, FontBase> fontBases) {
        int uniqueID = MPPUtility.getInt(data, offset);
        TaskField fieldType = MPPTaskField.getInstance(MPPUtility.getShort(data, offset + 4));
        Integer index = MPPUtility.getByte(data, offset + 8);
        int style = MPPUtility.getByte(data, offset + 9);
        ColorType color = ColorType.getInstance(MPPUtility.getByte(data, offset + 10));
        int change = MPPUtility.getByte(data, offset + 12);
        FontBase fontBase = fontBases.get(index);
        boolean bold = (style & 1) != 0;
        boolean italic = (style & 2) != 0;
        boolean underline = (style & 4) != 0;
        boolean boldChanged = (change & 1) != 0;
        boolean underlineChanged = (change & 2) != 0;
        boolean italicChanged = (change & 4) != 0;
        boolean colorChanged = (change & 8) != 0;
        boolean fontChanged = (change & 0x10) != 0;
        boolean backgroundColorChanged = uniqueID == -1;
        boolean backgroundPatternChanged = uniqueID == -1;
        return new TableFontStyle(uniqueID, fieldType, fontBase, italic, bold, underline, false, color.getColor(), Color.BLACK, BackgroundPattern.TRANSPARENT, italicChanged, boldChanged, underlineChanged, false, colorChanged, fontChanged, backgroundColorChanged, backgroundPatternChanged);
    }

    public List<Filter> getAutoFilters() {
        return this.m_autoFilters;
    }

    public Filter getAutoFilterByType(FieldType type) {
        return this.m_autoFiltersByType.get(type);
    }

    @Override
    public String toString() {
        int loop;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[GanttChartView");
        pw.println("   " + super.toString());
        pw.println("   highlightedTasksFontStyle=" + this.m_highlightedTasksFontStyle);
        pw.println("   rowAndColumnFontStyle=" + this.m_rowAndColumnFontStyle);
        pw.println("   nonCriticalTasksFontStyle=" + this.m_nonCriticalTasksFontStyle);
        pw.println("   criticalTasksFontStyle=" + this.m_criticalTasksFontStyle);
        pw.println("   summaryTasksFontStyle=" + this.m_summaryTasksFontStyle);
        pw.println("   milestoneTasksFontStyle=" + this.m_milestoneTasksFontStyle);
        pw.println("   topTimescaleFontStyle=" + this.m_topTimescaleFontStyle);
        pw.println("   middleTimescaleFontStyle=" + this.m_middleTimescaleFontStyle);
        pw.println("   bottomTimescaleFontStyle=" + this.m_bottomTimescaleFontStyle);
        pw.println("   barTextLeftFontStyle=" + this.m_barTextLeftFontStyle);
        pw.println("   barTextRightFontStyle=" + this.m_barTextRightFontStyle);
        pw.println("   barTextTopFontStyle=" + this.m_barTextTopFontStyle);
        pw.println("   barTextBottomFontStyle=" + this.m_barTextBottomFontStyle);
        pw.println("   barTextInsideFontStyle=" + this.m_barTextInsideFontStyle);
        pw.println("   markedTasksFontStyle=" + this.m_markedTasksFontStyle);
        pw.println("   projectSummaryTasksFontStyle=" + this.m_projectSummaryTasksFontStyle);
        pw.println("   externalTasksFontStyle=" + this.m_externalTasksFontStyle);
        pw.println("   SheetRowsGridLines=" + this.m_sheetRowsGridLines);
        pw.println("   SheetColumnsGridLines=" + this.m_sheetColumnsGridLines);
        pw.println("   TitleVerticalGridLines=" + this.m_titleVerticalGridLines);
        pw.println("   TitleHorizontalGridLines=" + this.m_titleHorizontalGridLines);
        pw.println("   TopTierColumnGridLines=" + this.m_topTierColumnGridLines);
        pw.println("   MiddleTierColumnGridLines=" + this.m_middleTierColumnGridLines);
        pw.println("   BottomTierColumnGridLines=" + this.m_bottomTierColumnGridLines);
        pw.println("   GanttRowsGridLines=" + this.m_ganttRowsGridLines);
        pw.println("   BarRowsGridLines=" + this.m_barRowsGridLines);
        pw.println("   CurrentDateGridLines=" + this.m_currentDateGridLines);
        pw.println("   PageBreakGridLines=" + this.m_pageBreakGridLines);
        pw.println("   ProjectStartGridLines=" + this.m_projectStartGridLines);
        pw.println("   ProjectFinishGridLines=" + this.m_projectFinishGridLines);
        pw.println("   StatusDateGridLines=" + this.m_statusDateGridLines);
        pw.println("   GanttBarHeight=" + this.m_ganttBarHeight);
        pw.println("   TimescaleTopTier=" + this.m_timescaleTopTier);
        pw.println("   TimescaleMiddleTier=" + this.m_timescaleMiddleTier);
        pw.println("   TimescaleBottomTier=" + this.m_timescaleBottomTier);
        pw.println("   TimescaleSeparator=" + this.m_timescaleScaleSeparator);
        pw.println("   TimescaleSize=" + this.m_timescaleSize + "%");
        pw.println("   NonWorkingDaysCalendarName=" + this.m_nonWorkingDaysCalendarName);
        pw.println("   NonWorkingColor=" + this.m_nonWorkingColor);
        pw.println("   NonWorkingPattern=" + this.m_nonWorkingPattern);
        pw.println("   NonWorkingStyle=" + this.m_nonWorkingStyle);
        pw.println("   ShowDrawings=" + this.m_showDrawings);
        pw.println("   RoundBarsToWholeDays=" + this.m_roundBarsToWholeDays);
        pw.println("   ShowBarSplits=" + this.m_showBarSplits);
        pw.println("   AlwaysRollupGanttBars=" + this.m_alwaysRollupGanttBars);
        pw.println("   HideRollupBarsWhenSummaryExpanded=" + this.m_hideRollupBarsWhenSummaryExpanded);
        pw.println("   BarDateFormat=" + this.m_barDateFormat);
        pw.println("   LinkStyle=" + this.m_linkStyle);
        pw.println("   ProgressLinesEnabled=" + this.m_progressLinesEnabled);
        pw.println("   ProgressLinesAtCurrentDate=" + this.m_progressLinesAtCurrentDate);
        pw.println("   ProgressLinesAtRecurringIntervals=" + this.m_progressLinesAtRecurringIntervals);
        pw.println("   ProgressLinesInterval=" + this.m_progressLinesInterval);
        pw.println("   ProgressLinesDailyDayNumber=" + this.m_progressLinesIntervalDailyDayNumber);
        pw.println("   ProgressLinesDailyWorkday=" + this.m_progressLinesIntervalDailyWorkday);
        pw.print("   ProgressLinesWeeklyDay=[");
        for (loop = 0; loop < this.m_progressLinesIntervalWeeklyDay.length; ++loop) {
            if (loop != 0) {
                pw.print(",");
            }
            pw.print(this.m_progressLinesIntervalWeeklyDay[loop]);
        }
        pw.println("]");
        pw.println("   ProgressLinesWeeklyWeekNumber=" + this.m_progressLinesIntervalWeekleyWeekNumber);
        pw.println("   ProgressLinesMonthlyDayOfMonth=" + this.m_progressLinesIntervalMonthlyDay);
        pw.println("   ProgressLinesMonthDayNumber=" + this.m_progressLinesIntervalMonthlyDayDayNumber);
        pw.println("   ProgressLinesMonthlyDay=" + this.m_progressLinesIntervalMonthlyFirstLastDay);
        pw.println("   ProgressLinesMonthlyFirst=" + this.m_progressLinesIntervalMonthlyFirstLast);
        pw.println("   ProgressLinesBeginAtProjectStart=" + this.m_progressLinesBeginAtProjectStart);
        pw.println("   ProgressLinesBeginAtDate=" + this.m_progressLinesBeginAtDate);
        pw.println("   ProgressLinesDisplaySelected=" + this.m_progressLinesDisplaySelected);
        pw.print("   ProgressLinesDisplaySelectedDates=[");
        if (this.m_progressLinesDisplaySelectedDates != null) {
            for (loop = 0; loop < this.m_progressLinesDisplaySelectedDates.length; ++loop) {
                if (loop != 0) {
                    pw.print(",");
                }
                pw.print(this.m_progressLinesDisplaySelectedDates[loop]);
            }
        }
        pw.println("]");
        pw.println("   ProgressLinesActualPlan=" + this.m_progressLinesActualPlan);
        pw.println("   ProgressLinesDisplayType=" + this.m_progressLinesDisplayType);
        pw.println("   ProgressLinesShowDate=" + this.m_progressLinesShowDate);
        pw.println("   ProgressLinesDateFormat=" + this.m_progressLinesDateFormat);
        pw.println("   ProgressLinesFontStyle=" + this.m_progressLinesFontStyle);
        pw.println("   ProgressLinesCurrentLineColor=" + this.m_progressLinesCurrentLineColor);
        pw.println("   ProgressLinesCurrentLineStyle=" + this.m_progressLinesCurrentLineStyle);
        pw.println("   ProgressLinesCurrentProgressPointColor=" + this.m_progressLinesCurrentProgressPointColor);
        pw.println("   ProgressLinesCurrentProgressPointShape=" + this.m_progressLinesCurrentProgressPointShape);
        pw.println("   ProgressLinesOtherLineColor=" + this.m_progressLinesOtherLineColor);
        pw.println("   ProgressLinesOtherLineStyle=" + this.m_progressLinesOtherLineStyle);
        pw.println("   ProgressLinesOtherProgressPointColor=" + this.m_progressLinesOtherProgressPointColor);
        pw.println("   ProgressLinesOtherProgressPointShape=" + this.m_progressLinesOtherProgressPointShape);
        pw.println("   TableWidth=" + this.m_tableWidth);
        pw.println("   DefaultFilterName=" + this.m_defaultFilterName);
        pw.println("   GroupName=" + this.m_groupName);
        pw.println("   HighlightFilter=" + this.m_highlightFilter);
        pw.println("   ShowInMenu=" + this.m_showInMenu);
        if (this.m_tableFontStyles != null) {
            for (loop = 0; loop < this.m_tableFontStyles.length; ++loop) {
                pw.println("   ColumnFontStyle=" + this.m_tableFontStyles[loop]);
            }
        }
        if (this.m_barStyles != null) {
            for (loop = 0; loop < this.m_barStyles.length; ++loop) {
                pw.println("   BarStyle=" + this.m_barStyles[loop]);
            }
        }
        if (this.m_barStyleExceptions != null) {
            for (loop = 0; loop < this.m_barStyleExceptions.length; ++loop) {
                pw.println("   BarStyleException=" + this.m_barStyleExceptions[loop]);
            }
        }
        if (!this.m_autoFilters.isEmpty()) {
            for (Filter f : this.m_autoFilters) {
                pw.println("   AutoFilter=" + f);
            }
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

