/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.DatatypeConverter;
import net.sf.mpxj.primavera.Row;

class MapRow
implements Row {
    protected Map<String, Object> m_map;

    public MapRow(Map<String, Object> map) {
        this.m_map = map;
    }

    @Override
    public final String getString(String name) {
        Object value = this.getObject(name);
        String result = value == null ? null : (value instanceof byte[] ? new String((byte[])value) : value.toString());
        return result;
    }

    @Override
    public final Integer getInteger(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Integer)) {
            result = ((Number)result).intValue();
        }
        return (Integer)result;
    }

    @Override
    public final Double getDouble(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Double)) {
            result = ((Number)result).doubleValue();
        }
        return (Double)result;
    }

    @Override
    public final boolean getBoolean(String name) {
        boolean result = false;
        Object value = this.getObject(name);
        if (value != null) {
            if (value instanceof Boolean) {
                result = BooleanHelper.getBoolean((Boolean)value);
            } else if (value instanceof Number) {
                result = ((Number)value).doubleValue() != 0.0;
            } else if (value instanceof String) {
                result = this.parseBoolean((String)value);
            }
        }
        return result;
    }

    @Override
    public final int getInt(String name) {
        return NumberHelper.getInt((Number)this.getObject(name));
    }

    @Override
    public final Date getDate(String name) {
        return (Date)this.getObject(name);
    }

    @Override
    public final Duration getDuration(String name) {
        return Duration.getInstance(NumberHelper.getDouble(this.getDouble(name)), TimeUnit.HOURS);
    }

    @Override
    public final UUID getUUID(String name) {
        return DatatypeConverter.parseUUID(this.getString(name));
    }

    private final Object getObject(String name) {
        return this.m_map.get(name);
    }

    private final boolean parseBoolean(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes"));
    }
}

