/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import net.sf.mpxj.Day;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Notes;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.common.AutoCloseableHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.primavera.MapRow;
import net.sf.mpxj.primavera.PrimaveraReader;
import net.sf.mpxj.primavera.Record;
import net.sf.mpxj.primavera.ResultSetRow;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.reader.AbstractProjectReader;

public final class PrimaveraDatabaseReader
extends AbstractProjectReader {
    private PrimaveraReader m_reader;
    private Integer m_projectID;
    private String m_schema = "";
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_allocatedConnection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();
    private UserFieldCounters m_taskUdfCounters = new UserFieldCounters();
    private UserFieldCounters m_resourceUdfCounters = new UserFieldCounters();
    private UserFieldCounters m_assignmentUdfCounters = new UserFieldCounters();
    private boolean m_matchPrimaveraWBS = true;
    private boolean m_wbsIsFullPath = true;
    private Map<FieldType, String> m_resourceFields = PrimaveraReader.getDefaultResourceFieldMap();
    private Map<FieldType, String> m_wbsFields = PrimaveraReader.getDefaultWbsFieldMap();
    private Map<FieldType, String> m_taskFields = PrimaveraReader.getDefaultTaskFieldMap();
    private Map<FieldType, String> m_assignmentFields = PrimaveraReader.getDefaultAssignmentFieldMap();
    private Map<FieldType, String> m_aliases = PrimaveraReader.getDefaultAliases();

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("select proj_id, proj_short_name from " + this.m_schema + "project where delete_date is null");
            for (Row row : rows) {
                Integer id = row.getInteger("proj_id");
                String name = row.getString("proj_short_name");
                result.put(id, name);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_reader = new PrimaveraReader(this.m_taskUdfCounters, this.m_resourceUdfCounters, this.m_assignmentUdfCounters, this.m_resourceFields, this.m_wbsFields, this.m_taskFields, this.m_assignmentFields, this.m_aliases, this.m_matchPrimaveraWBS, this.m_wbsIsFullPath);
            ProjectFile project = this.m_reader.getProject();
            this.addListenersToProject(project);
            this.processAnalytics();
            this.processProjectProperties();
            this.processActivityCodes();
            this.processUserDefinedFields();
            this.processExpenseCategories();
            this.processCostAccounts();
            this.processCalendars();
            this.processResources();
            this.processResourceRates();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.processExpenseItems();
            this.m_reader = null;
            project.updateStructure();
            ProjectFile projectFile = project;
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            if (this.m_allocatedConnection) {
                AutoCloseableHelper.closeQuietly(this.m_connection);
                this.m_connection = null;
            }
        }
    }

    public List<ProjectFile> readAll() throws MPXJException {
        Map<Integer, String> projects = this.listProjects();
        ArrayList<ProjectFile> result = new ArrayList<ProjectFile>(projects.keySet().size());
        for (Integer id : projects.keySet()) {
            this.setProjectID(id);
            result.add(this.read());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAnalytics() throws SQLException {
        this.allocateConnection();
        try {
            DatabaseMetaData meta = this.m_connection.getMetaData();
            String productName = meta.getDatabaseProductName();
            productName = productName == null || productName.isEmpty() ? "DATABASE" : productName.toUpperCase();
            ProjectProperties properties = this.m_reader.getProject().getProjectProperties();
            properties.setFileApplication("Primavera");
            properties.setFileType(productName);
        }
        finally {
            this.releaseConnection();
        }
    }

    private void processProjectProperties() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "project where proj_id=?", this.m_projectID);
        this.m_reader.processProjectProperties(rows, this.m_projectID);
        rows = this.getRows("select * from " + this.m_schema + "prefer where prefer.delete_date is null");
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            ProjectProperties ph = this.m_reader.getProject().getProjectProperties();
            ph.setCreationDate(row.getDate("create_date"));
            ph.setLastSaved(row.getDate("update_date"));
            ph.setMinutesPerDay(row.getDouble("day_hr_cnt") * 60.0);
            ph.setMinutesPerWeek(row.getDouble("week_hr_cnt") * 60.0);
            ph.setWeekStartDay(Day.getInstance(row.getInt("week_start_day_num")));
            this.processDefaultCurrency(row.getInteger("curr_id"));
        }
        this.processSchedulingProjectProperties();
    }

    private void processExpenseCategories() throws SQLException {
        this.m_reader.processExpenseCategories(this.getRows("select * from " + this.m_schema + "costtype"));
    }

    private void processExpenseItems() throws SQLException {
        this.m_reader.processExpenseItems(this.getRows("select * from " + this.m_schema + "projcost where proj_id=?", this.m_projectID));
    }

    private void processCostAccounts() throws SQLException {
        this.m_reader.processCostAccounts(this.getRows("select * from " + this.m_schema + "account"));
    }

    private void processActivityCodes() throws SQLException {
        List<Row> types = this.getRows("select * from " + this.m_schema + "actvtype where actv_code_type_id in (select distinct actv_code_type_id from taskactv where proj_id=?)", this.m_projectID);
        List<Row> typeValues = this.getRows("select * from " + this.m_schema + "actvcode where actv_code_id in (select distinct actv_code_id from taskactv where proj_id=?)", this.m_projectID);
        List<Row> assignments = this.getRows("select * from " + this.m_schema + "taskactv where proj_id=?", this.m_projectID);
        this.m_reader.processActivityCodes(types, typeValues, assignments);
    }

    private void processUserDefinedFields() throws SQLException {
        List<Row> fields = this.getRows("select * from " + this.m_schema + "udftype");
        List<Row> values = this.getRows("select * from " + this.m_schema + "udfvalue where proj_id=? or proj_id is null", this.m_projectID);
        this.m_reader.processUserDefinedFields(fields, values);
    }

    private void processSchedulingProjectProperties() throws SQLException {
        Row row;
        Record record;
        List<Row> rows = this.getRows("select * from " + this.m_schema + "projprop where proj_id=? and prop_name='scheduling'", this.m_projectID);
        if (!rows.isEmpty() && (record = Record.getRecord((row = rows.get(0)).getString("prop_value"))) != null) {
            String[] keyValues = record.getValue().split("\\|");
            MapRow mapRow = new MapRow(IntStream.range(1, keyValues.length).filter(i -> i % 2 != 0).mapToObj(i -> new Pair<String, String>(keyValues[i - 1], keyValues[i])).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
            this.m_reader.processScheduleOptions(mapRow);
        }
    }

    private void processDefaultCurrency(Integer currencyID) throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "currtype where curr_id=?", currencyID);
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            this.m_reader.processDefaultCurrency(row);
        }
    }

    private void processResources() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rsrc where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by rsrc_seq_num", this.m_projectID);
        this.m_reader.processResources(rows);
    }

    private void processResourceRates() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rsrcrate where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by rsrc_rate_id", this.m_projectID);
        this.m_reader.processResourceRates(rows);
    }

    private void processTasks() throws SQLException {
        List<Row> wbs = this.getRows("select * from " + this.m_schema + "projwbs where proj_id=? and delete_date is null order by parent_wbs_id,seq_num", this.m_projectID);
        List<Row> tasks = this.getRows("select * from " + this.m_schema + "task where proj_id=? and delete_date is null", this.m_projectID);
        Map<Integer, String> topics = this.m_reader.getNotebookTopics(this.getRows("select * from " + this.m_schema + "memotype"));
        Map<Integer, Notes> wbsNotes = this.m_reader.getNotes(topics, this.getRows("select * from " + this.m_schema + "wbsmemo where proj_id=?", this.m_projectID), "wbs_id", "wbs_memo");
        Map<Integer, Notes> taskNotes = this.m_reader.getNotes(topics, this.getRows("select * from " + this.m_schema + "taskmemo where proj_id=?", this.m_projectID), "task_id", "task_memo");
        this.m_reader.processTasks(wbs, tasks, wbsNotes, taskNotes);
    }

    private void processPredecessors() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "taskpred where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processPredecessors(rows);
    }

    private void processCalendars() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "calendar where (proj_id is null or proj_id=?) and delete_date is null", this.m_projectID);
        this.m_reader.processCalendars(rows);
    }

    private void processAssignments() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "taskrsrc where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processAssignments(rows);
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    @Override
    public ProjectFile read(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProjectFile> readAll(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFile read(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProjectFile> readAll(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getRows(String sql) throws SQLException {
        this.allocateConnection();
        try {
            ArrayList<Row> result = new ArrayList<Row>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            ArrayList<Row> arrayList = result;
            return arrayList;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getRows(String sql, Integer var) throws SQLException {
        this.allocateConnection();
        try {
            ArrayList<Row> result = new ArrayList<Row>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_ps.setInt(1, NumberHelper.getInt(var));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            ArrayList<Row> arrayList = result;
            return arrayList;
        }
        finally {
            this.releaseConnection();
        }
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
        }
    }

    private void releaseConnection() {
        AutoCloseableHelper.closeQuietly(this.m_rs);
        this.m_rs = null;
        AutoCloseableHelper.closeQuietly(this.m_ps);
        this.m_ps = null;
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData meta = this.m_rs.getMetaData();
        int columnCount = meta.getColumnCount() + 1;
        for (int loop = 1; loop < columnCount; ++loop) {
            String name = meta.getColumnName(loop).toLowerCase();
            Integer type = meta.getColumnType(loop);
            this.m_meta.put(name, type);
        }
    }

    public void setSchema(String schema) {
        if (schema == null) {
            schema = "";
        } else if (!schema.isEmpty() && !schema.endsWith(".")) {
            schema = schema + '.';
        }
        this.m_schema = schema;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public void setFieldNamesForTaskUdfType(UserFieldDataType type, String[] fieldNames) {
        this.m_taskUdfCounters.setFieldNamesForType(type, fieldNames);
    }

    public void setFieldNamesForResourceUdfType(UserFieldDataType type, String[] fieldNames) {
        this.m_resourceUdfCounters.setFieldNamesForType(type, fieldNames);
    }

    public void setFieldNamesForAssignmentUdfType(UserFieldDataType type, String[] fieldNames) {
        this.m_assignmentUdfCounters.setFieldNamesForType(type, fieldNames);
    }

    public Map<FieldType, String> getResourceFieldMap() {
        return this.m_resourceFields;
    }

    public Map<FieldType, String> getWbsFieldMap() {
        return this.m_wbsFields;
    }

    public Map<FieldType, String> getActivityFieldMap() {
        return this.m_taskFields;
    }

    public Map<FieldType, String> getAssignmentFieldMap() {
        return this.m_assignmentFields;
    }

    public Map<FieldType, String> getAliases() {
        return this.m_aliases;
    }

    public boolean getMatchPrimaveraWBS() {
        return this.m_matchPrimaveraWBS;
    }

    public void setMatchPrimaveraWBS(boolean matchPrimaveraWBS) {
        this.m_matchPrimaveraWBS = matchPrimaveraWBS;
    }

    public boolean getWbsIsFullPath() {
        return this.m_wbsIsFullPath;
    }

    public void setWbsIsFullPath(boolean wbsIsFullPath) {
        this.m_wbsIsFullPath = wbsIsFullPath;
    }
}

