/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ActivityCode;
import net.sf.mpxj.ActivityCodeContainer;
import net.sf.mpxj.ActivityCodeValue;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CostAccount;
import net.sf.mpxj.CostAccountContainer;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ExpenseCategory;
import net.sf.mpxj.ExpenseCategoryContainer;
import net.sf.mpxj.ExpenseItem;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.HtmlNotes;
import net.sf.mpxj.Notes;
import net.sf.mpxj.ParentNotes;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.StructuredNotes;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.ActivitySorter;
import net.sf.mpxj.primavera.ExternalRelation;
import net.sf.mpxj.primavera.PercentCompleteType;
import net.sf.mpxj.primavera.Record;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;

final class PrimaveraReader {
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private DateFormat m_calendarTimeFormat = new SimpleDateFormat("HH:mm");
    private Integer m_defaultCalendarID;
    private final UserFieldCounters m_taskUdfCounters;
    private final UserFieldCounters m_resourceUdfCounters;
    private final UserFieldCounters m_assignmentUdfCounters;
    private Map<FieldType, String> m_resourceFields;
    private Map<FieldType, String> m_wbsFields;
    private Map<FieldType, String> m_taskFields;
    private Map<FieldType, String> m_assignmentFields;
    private List<ExternalRelation> m_externalRelations = new ArrayList<ExternalRelation>();
    private final boolean m_matchPrimaveraWBS;
    private final boolean m_wbsIsFullPath;
    private Map<Integer, String> m_udfFields = new HashMap<Integer, String>();
    private Map<String, Map<Integer, List<Row>>> m_udfValues = new HashMap<String, Map<Integer, List<Row>>>();
    private Map<Integer, ActivityCodeValue> m_activityCodeMap = new HashMap<Integer, ActivityCodeValue>();
    private Map<Integer, List<Integer>> m_activityCodeAssignments = new HashMap<Integer, List<Integer>>();
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, TaskType> TASK_TYPE_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;
    private static final Map<String, TimeUnit> TIME_UNIT_MAP;
    private static final Map<String, CurrencySymbolPosition> CURRENCY_SYMBOL_POSITION_MAP;
    private static final Map<String, Boolean> STATICTYPE_UDF_MAP;
    private static final Map<String, FieldTypeClass> FIELD_TYPE_MAP;
    private static final Map<String, AccrueType> ACCRUE_TYPE_MAP;
    private static final long EXCEPTION_EPOCH = -2209161599935L;

    public PrimaveraReader(UserFieldCounters taskUdfCounters, UserFieldCounters resourceUdfCounters, UserFieldCounters assignmentUdfCounters, Map<FieldType, String> resourceFields, Map<FieldType, String> wbsFields, Map<FieldType, String> taskFields, Map<FieldType, String> assignmentFields, Map<FieldType, String> aliases, boolean matchPrimaveraWBS, boolean wbsIsFullPath) {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoTaskUniqueID(false);
        config.setAutoResourceUniqueID(false);
        config.setAutoAssignmentUniqueID(false);
        config.setAutoWBS(false);
        this.m_resourceFields = resourceFields;
        this.m_wbsFields = wbsFields;
        this.m_taskFields = taskFields;
        this.m_assignmentFields = assignmentFields;
        this.applyAliases(aliases);
        this.m_taskUdfCounters = taskUdfCounters;
        this.m_taskUdfCounters.reset();
        this.m_resourceUdfCounters = resourceUdfCounters;
        this.m_resourceUdfCounters.reset();
        this.m_assignmentUdfCounters = assignmentUdfCounters;
        this.m_assignmentUdfCounters.reset();
        this.m_matchPrimaveraWBS = matchPrimaveraWBS;
        this.m_wbsIsFullPath = wbsIsFullPath;
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public List<ExternalRelation> getExternalRelations() {
        return this.m_externalRelations;
    }

    public void processProjectProperties(List<Row> rows, Integer projectID) {
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            ProjectProperties properties = this.m_project.getProjectProperties();
            properties.setCreationDate(row.getDate("create_date"));
            properties.setFinishDate(row.getDate("plan_end_date"));
            properties.setName(row.getString("proj_short_name"));
            properties.setStartDate(row.getDate("plan_start_date"));
            properties.setDefaultTaskType(TASK_TYPE_MAP.get(row.getString("def_duration_type")));
            properties.setStatusDate(row.getDate("last_recalc_date"));
            properties.setFiscalYearStartMonth(row.getInteger("fy_start_month_num"));
            properties.setUniqueID(projectID == null ? null : projectID.toString());
            properties.setExportFlag(row.getBoolean("export_flag"));
            this.m_defaultCalendarID = row.getInteger("clndr_id");
        }
    }

    public void processExpenseCategories(List<Row> categories) {
        ExpenseCategoryContainer container = this.m_project.getExpenseCategories();
        categories.forEach(row -> container.add(new ExpenseCategory(row.getInteger("cost_type_id"), row.getString("cost_type"), row.getInteger("seq_num"))));
    }

    public void processCostAccounts(List<Row> accounts) {
        CostAccountContainer container = this.m_project.getCostAccounts();
        accounts.forEach(row -> container.add(new CostAccount(row.getInteger("acct_id"), row.getString("acct_short_name"), row.getString("acct_name"), row.getString("acct_descr"), row.getInteger("acct_seq_num"))));
        accounts.forEach(row -> ((CostAccount)container.getByUniqueID(row.getInteger("acct_id"))).setParent((CostAccount)container.getByUniqueID(row.getInteger("parent_acct_id"))));
    }

    public void processActivityCodes(List<Row> types, List<Row> typeValues, List<Row> assignments) {
        ActivityCode code;
        ActivityCodeContainer container = this.m_project.getActivityCodes();
        HashMap<Integer, ActivityCode> map = new HashMap<Integer, ActivityCode>();
        for (Row row : types) {
            code = new ActivityCode(row.getInteger("actv_code_type_id"), row.getString("actv_code_type"));
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        for (Row row : typeValues) {
            code = (ActivityCode)map.get(row.getInteger("actv_code_type_id"));
            if (code == null) continue;
            ActivityCodeValue value = code.addValue(row.getInteger("actv_code_id"), row.getString("short_name"), row.getString("actv_code_name"));
            this.m_activityCodeMap.put(value.getUniqueID(), value);
        }
        for (Row row : typeValues) {
            ActivityCodeValue child = this.m_activityCodeMap.get(row.getInteger("actv_code_id"));
            ActivityCodeValue parent = this.m_activityCodeMap.get(row.getInteger("parent_actv_code_id"));
            if (parent == null || child == null) continue;
            child.setParent(parent);
        }
        for (Row row : assignments) {
            Integer taskID = row.getInteger("task_id");
            List list = this.m_activityCodeAssignments.computeIfAbsent(taskID, k -> new ArrayList());
            list.add(row.getInteger("actv_code_id"));
        }
    }

    public void processUserDefinedFields(List<Row> fields, List<Row> values) {
        String tableName;
        HashMap<Integer, String> tableNameMap = new HashMap<Integer, String>();
        for (Row row : fields) {
            Integer fieldId = row.getInteger("udf_type_id");
            tableName = row.getString("table_name");
            tableNameMap.put(fieldId, tableName);
            FieldTypeClass fieldType = FIELD_TYPE_MAP.get(tableName);
            if (fieldType == null) continue;
            String fieldDataType = row.getString("logical_data_type");
            String fieldName = row.getString("udf_type_label");
            this.m_udfFields.put(fieldId, fieldName);
            this.addUserDefinedField(fieldType, UserFieldDataType.valueOf(fieldDataType), fieldName);
        }
        for (Row row : values) {
            Integer typeID = row.getInteger("udf_type_id");
            tableName = (String)tableNameMap.get(typeID);
            Map<Integer, List<Row>> tableData = this.m_udfValues.get(tableName);
            if (tableData == null) {
                tableData = new HashMap<Integer, List<Row>>();
                this.m_udfValues.put(tableName, tableData);
            }
            Integer id = row.getInteger("fk_id");
            List list = tableData.computeIfAbsent(id, k -> new ArrayList());
            list.add(row);
        }
    }

    public void processCalendars(List<Row> rows) {
        ProjectCalendar projectCalendar;
        HashMap<ProjectCalendar, Integer> baseCalendarMap = new HashMap<ProjectCalendar, Integer>();
        for (Row row : rows) {
            ProjectCalendar calendar = this.processCalendar(row);
            Integer baseCalendarID = row.getInteger("base_clndr_id");
            if (baseCalendarID == null) continue;
            baseCalendarMap.put(calendar, baseCalendarID);
        }
        for (Map.Entry entry : baseCalendarMap.entrySet()) {
            ProjectCalendar baseCalendar = this.m_project.getCalendarByUniqueID((Integer)entry.getValue());
            if (baseCalendar == null) continue;
            ((ProjectCalendar)entry.getKey()).setParent(baseCalendar);
        }
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoCalendarUniqueID(true);
        config.updateCalendarUniqueCounter();
        if (this.m_defaultCalendarID != null && (projectCalendar = this.m_project.getCalendarByUniqueID(this.m_defaultCalendarID)) != null) {
            this.m_project.setDefaultCalendar(projectCalendar);
        }
    }

    public ProjectCalendar processCalendar(Row row) {
        ProjectCalendar calendar = this.m_project.addCalendar();
        Integer id = row.getInteger("clndr_id");
        calendar.setUniqueID(id);
        calendar.setName(row.getString("clndr_name"));
        try {
            calendar.setMinutesPerDay((int)(NumberHelper.getDouble(row.getDouble("day_hr_cnt")) * 60.0));
            calendar.setMinutesPerWeek((int)(NumberHelper.getDouble(row.getDouble("week_hr_cnt")) * 60.0));
            calendar.setMinutesPerMonth((int)(NumberHelper.getDouble(row.getDouble("month_hr_cnt")) * 60.0));
            calendar.setMinutesPerYear((int)(NumberHelper.getDouble(row.getDouble("year_hr_cnt")) * 60.0));
        }
        catch (ClassCastException ex) {
            return calendar;
        }
        String calendarData = row.getString("clndr_data");
        if (calendarData != null && !calendarData.isEmpty()) {
            Record root = Record.getRecord(calendarData);
            if (root != null) {
                this.processCalendarDays(calendar, root);
                this.processCalendarExceptions(calendar, root);
            }
        } else {
            DateRange defaultHourRange = new DateRange(DateHelper.getTime(8, 0), DateHelper.getTime(16, 0));
            for (Day day : Day.values()) {
                if (day != Day.SATURDAY && day != Day.SUNDAY) {
                    calendar.setWorkingDay(day, true);
                    ProjectCalendarHours hours = calendar.addCalendarHours(day);
                    hours.addRange(defaultHourRange);
                    continue;
                }
                calendar.setWorkingDay(day, false);
            }
        }
        this.m_eventManager.fireCalendarReadEvent(calendar);
        return calendar;
    }

    private void processCalendarDays(ProjectCalendar calendar, Record root) {
        Record daysOfWeek = root.getChild("DaysOfWeek");
        if (daysOfWeek != null) {
            for (Record dayRecord : daysOfWeek.getChildren()) {
                this.processCalendarHours(calendar, dayRecord);
            }
        }
    }

    private void processCalendarHours(ProjectCalendar calendar, Record dayRecord) {
        Day day = Day.getInstance(Integer.parseInt(dayRecord.getField()));
        if (day != null) {
            List<Record> recHours = dayRecord.getChildren();
            if (recHours.size() == 0) {
                calendar.setWorkingDay(day, false);
            } else {
                calendar.setWorkingDay(day, true);
                ProjectCalendarHours hours = calendar.addCalendarHours(day);
                for (Record recWorkingHours : recHours) {
                    this.addHours(hours, recWorkingHours);
                }
            }
        }
    }

    private void addHours(ProjectCalendarDateRanges ranges, Record hoursRecord) {
        if (hoursRecord.getValue() != null) {
            String[] wh = hoursRecord.getValue().split("\\|");
            try {
                String endText;
                String startText;
                if (wh[0].equals("s")) {
                    startText = wh[1];
                    endText = wh[3];
                } else {
                    startText = wh[3];
                    endText = wh[1];
                }
                if (endText.equals("00:00")) {
                    endText = "24:00";
                }
                Date start = this.m_calendarTimeFormat.parse(startText);
                Date end = this.m_calendarTimeFormat.parse(endText);
                ranges.addRange(new DateRange(start, end));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void processCalendarExceptions(ProjectCalendar calendar, Record root) {
        Record exceptions = root.getChild("Exceptions");
        if (exceptions != null) {
            for (Record exception : exceptions.getChildren()) {
                long daysFromEpoch = Integer.parseInt(exception.getValue().split("\\|")[1]);
                Date startEx = DateHelper.getDateFromLong(-2209161599935L + daysFromEpoch * 86400000L);
                ProjectCalendarException pce = calendar.addCalendarException(startEx, startEx);
                for (Record exceptionHours : exception.getChildren()) {
                    this.addHours(pce, exceptionHours);
                }
            }
        }
    }

    public void processResources(List<Row> rows) {
        for (Row row : rows) {
            Resource resource = this.m_project.addResource();
            this.processFields(this.m_resourceFields, row, resource);
            resource.setResourceCalendar(this.getResourceCalendar(row.getInteger("clndr_id")));
            TimeUnit timeUnit = TIME_UNIT_MAP.get(row.getString("cost_qty_type"));
            resource.setStandardRateUnits(timeUnit);
            resource.setOvertimeRateUnits(timeUnit);
            this.populateUserDefinedFieldValues("RSRC", FieldTypeClass.RESOURCE, resource, resource.getUniqueID());
            resource.setNotesObject(this.getNotes(resource.getNotes()));
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private Notes getNotes(String text) {
        HtmlNotes notes = this.getHtmlNote(text);
        return notes == null || notes.isEmpty() ? null : notes;
    }

    private ProjectCalendar getResourceCalendar(Integer calendarID) {
        ProjectCalendar calendar;
        ProjectCalendar result = null;
        if (calendarID != null && (calendar = this.m_project.getCalendarByUniqueID(calendarID)) != null) {
            if (!calendar.isDerived()) {
                ProjectCalendar resourceCalendar = this.m_project.addCalendar();
                resourceCalendar.setParent(calendar);
                resourceCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                result = resourceCalendar;
            } else if (calendar.getResource() == null) {
                result = calendar;
            } else {
                ProjectCalendar copy = this.m_project.addCalendar();
                copy.copy(calendar);
                result = copy;
            }
        }
        return result;
    }

    public void processResourceRates(List<Row> rows) {
        Collections.sort(rows, new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                Integer id2;
                Integer id1 = r1.getInteger("rsrc_id");
                int cmp = NumberHelper.compare(id1, id2 = r2.getInteger("rsrc_id"));
                if (cmp != 0) {
                    return cmp;
                }
                Date d1 = r1.getDate("start_date");
                Date d2 = r2.getDate("start_date");
                return DateHelper.compare(d1, d2);
            }
        });
        for (int i = 0; i < rows.size(); ++i) {
            CostRateTable costRateTable;
            Resource resource;
            Row row = rows.get(i);
            Integer resourceID = row.getInteger("rsrc_id");
            Rate standardRate = new Rate(row.getDouble("cost_per_qty"), TimeUnit.HOURS);
            TimeUnit standardRateFormat = TimeUnit.HOURS;
            Rate overtimeRate = new Rate(0.0, TimeUnit.HOURS);
            TimeUnit overtimeRateFormat = TimeUnit.HOURS;
            Double costPerUse = NumberHelper.getDouble(0.0);
            Double maxUnits = NumberHelper.getDouble(NumberHelper.getDouble(row.getDouble("max_qty_per_hr")) * 100.0);
            Date startDate = row.getDate("start_date");
            Date endDate = DateHelper.END_DATE_NA;
            if (i + 1 < rows.size()) {
                Row nextRow = rows.get(i + 1);
                int nextResourceID = nextRow.getInt("rsrc_id");
                if (resourceID == nextResourceID) {
                    Calendar cal = DateHelper.popCalendar(nextRow.getDate("start_date"));
                    cal.add(12, -1);
                    endDate = cal.getTime();
                    DateHelper.pushCalendar(cal);
                }
            }
            if ((resource = this.m_project.getResourceByUniqueID(resourceID)) == null) continue;
            if (startDate.getTime() < DateHelper.START_DATE_NA.getTime()) {
                startDate = DateHelper.START_DATE_NA;
            }
            if (endDate.getTime() > DateHelper.END_DATE_NA.getTime()) {
                endDate = DateHelper.END_DATE_NA;
            }
            if ((costRateTable = resource.getCostRateTable(0)) == null) {
                costRateTable = new CostRateTable();
                resource.setCostRateTable(0, costRateTable);
            }
            CostRateTableEntry entry = new CostRateTableEntry(standardRate, standardRateFormat, overtimeRate, overtimeRateFormat, costPerUse, startDate, endDate);
            costRateTable.add(entry);
            resource.getAvailability().add(new Availability(startDate, endDate, maxUnits));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processTasks(List<Row> wbs, List<Row> tasks, Map<Integer, Notes> wbsNotes, Map<Integer, Notes> taskNotes) {
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        String projectName = projectProperties.getName();
        HashSet<Integer> uniqueIDs = new HashSet<Integer>();
        HashSet<Task> wbsTasks = new HashSet<Task>();
        if (!wbs.isEmpty()) {
            projectProperties.setProjectTitle(wbs.get(0).getString("wbs_name"));
        }
        for (Row row : wbs) {
            Task task = this.m_project.addTask();
            task.setProject(projectName);
            task.setSummary(true);
            this.processFields(this.m_wbsFields, row, task);
            this.populateUserDefinedFieldValues("PROJWBS", FieldTypeClass.TASK, task, task.getUniqueID());
            task.setNotesObject(wbsNotes.get(task.getUniqueID()));
            uniqueIDs.add(task.getUniqueID());
            wbsTasks.add(task);
            this.m_eventManager.fireTaskReadEvent(task);
        }
        FieldType activityIDField = this.getActivityIDField(this.m_taskFields);
        this.m_project.getChildTasks().clear();
        for (Row row : wbs) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("wbs_id"));
            Task parentTask = this.m_project.getTaskByUniqueID(row.getInteger("parent_wbs_id"));
            if (parentTask == null) {
                this.m_project.getChildTasks().add(task);
                continue;
            }
            this.m_project.getChildTasks().remove(task);
            parentTask.getChildTasks().add(task);
            if (this.m_wbsIsFullPath) {
                task.setWBS(parentTask.getWBS() + "." + task.getWBS());
            }
            if (activityIDField == null) continue;
            task.set(activityIDField, task.getWBS());
        }
        boolean bl = true;
        this.m_clashMap.clear();
        for (Row row : tasks) {
            Integer parentTaskID = row.getInteger("wbs_id");
            Task parentTask = this.m_project.getTaskByUniqueID(parentTaskID);
            Task task = parentTask == null ? this.m_project.addTask() : parentTask.addTask();
            task.setProject(projectName);
            this.processFields(this.m_taskFields, row, task);
            task.setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(row.getString("task_type"))));
            task.setIgnoreResourceCalendar(!"TT_Rsrc".equals(row.getString("task_type")));
            task.setPercentageComplete(this.calculatePercentComplete(row));
            if (this.m_matchPrimaveraWBS && parentTask != null) {
                task.setWBS(parentTask.getWBS());
            }
            Integer uniqueID = task.getUniqueID();
            this.populateUserDefinedFieldValues("TASK", FieldTypeClass.TASK, task, uniqueID);
            this.populateActivityCodes(task);
            task.setNotesObject(taskNotes.get(uniqueID));
            if (uniqueIDs.contains(uniqueID)) {
                void var10_13;
                while (uniqueIDs.contains((int)var10_13)) {
                    ++var10_13;
                }
                Integer newUniqueID = (int)var10_13;
                this.m_clashMap.put(uniqueID, newUniqueID);
                uniqueID = newUniqueID;
                task.setUniqueID(uniqueID);
            }
            uniqueIDs.add(uniqueID);
            Integer calId = row.getInteger("clndr_id");
            ProjectCalendar cal = this.m_project.getCalendarByUniqueID(calId);
            task.setCalendar(cal);
            Date startDate = row.getDate("act_start_date") == null ? row.getDate("restart_date") : row.getDate("act_start_date");
            task.setStart(startDate);
            Date endDate = row.getDate("act_end_date") == null ? row.getDate("reend_date") : row.getDate("act_end_date");
            task.setFinish(endDate);
            Duration work = Duration.add(task.getActualWork(), task.getRemainingWork(), projectProperties);
            task.setWork(work);
            this.m_eventManager.fireTaskReadEvent(task);
        }
        new ActivitySorter(TaskField.TEXT1, wbsTasks).sort(this.m_project);
        this.updateStructure();
        this.updateDates();
        this.updateWork();
    }

    private void populateActivityCodes(Task task) {
        List<Integer> list = this.m_activityCodeAssignments.get(task.getUniqueID());
        if (list != null) {
            for (Integer id : list) {
                ActivityCodeValue value = this.m_activityCodeMap.get(id);
                if (value == null) continue;
                task.addActivityCode(value);
            }
        }
    }

    private FieldType getActivityIDField(Map<FieldType, String> map) {
        FieldType result = null;
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            if (!entry.getValue().equals("task_code")) continue;
            result = entry.getKey();
            break;
        }
        return result;
    }

    private void addUserDefinedField(FieldTypeClass fieldType, UserFieldDataType dataType, String name) {
        try {
            switch (fieldType) {
                case TASK: {
                    TaskField taskField;
                    while (this.m_taskFields.containsKey(taskField = this.m_taskUdfCounters.nextField(TaskField.class, dataType)) || this.m_wbsFields.containsKey(taskField)) {
                    }
                    this.m_project.getCustomFields().getCustomField(taskField).setAlias(name);
                    break;
                }
                case RESOURCE: {
                    ResourceField resourceField;
                    while (this.m_resourceFields.containsKey(resourceField = this.m_resourceUdfCounters.nextField(ResourceField.class, dataType))) {
                    }
                    this.m_project.getCustomFields().getCustomField(resourceField).setAlias(name);
                    break;
                }
                case ASSIGNMENT: {
                    AssignmentField assignmentField;
                    while (this.m_assignmentFields.containsKey(assignmentField = this.m_assignmentUdfCounters.nextField(AssignmentField.class, dataType))) {
                    }
                    this.m_project.getCustomFields().getCustomField(assignmentField).setAlias(name);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addUDFValue(FieldTypeClass fieldType, FieldContainer container, Row row) {
        Integer fieldId = row.getInteger("udf_type_id");
        String fieldName = this.m_udfFields.get(fieldId);
        Object value = null;
        FieldType field = this.m_project.getCustomFields().getFieldByAlias(fieldType, fieldName);
        if (field != null) {
            DataType fieldDataType = field.getDataType();
            switch (fieldDataType) {
                case DATE: {
                    value = row.getDate("udf_date");
                    break;
                }
                case CURRENCY: 
                case NUMERIC: {
                    value = row.getDouble("udf_number");
                    break;
                }
                case GUID: 
                case INTEGER: {
                    value = row.getInteger("udf_code_id");
                    break;
                }
                case BOOLEAN: {
                    String text = row.getString("udf_text");
                    if (text != null) {
                        value = STATICTYPE_UDF_MAP.get(text);
                        if (value != null) break;
                        value = row.getBoolean("udf_text");
                        break;
                    }
                    value = row.getBoolean("udf_number");
                    break;
                }
                default: {
                    value = row.getString("udf_text");
                }
            }
            container.set(field, value);
        }
    }

    private void populateUserDefinedFieldValues(String tableName, FieldTypeClass type, FieldContainer container, Integer uniqueID) {
        List<Row> udf;
        Map<Integer, List<Row>> tableData = this.m_udfValues.get(tableName);
        if (tableData != null && (udf = tableData.get(uniqueID)) != null) {
            for (Row r : udf) {
                this.addUDFValue(type, container, r);
            }
        }
    }

    public Map<Integer, String> getNotebookTopics(List<Row> rows) {
        HashMap<Integer, String> topics = new HashMap<Integer, String>();
        rows.forEach(row -> topics.put(row.getInteger("memo_type_id"), row.getString("memo_type")));
        return topics;
    }

    public Map<Integer, Notes> getNotes(Map<Integer, String> topics, List<Row> rows, String idColumn, String textColumn) {
        Map map = rows.stream().collect(Collectors.groupingBy(r -> r.getInteger(idColumn), Collectors.groupingBy(r -> r.getInteger("memo_type_id"), Collectors.mapping(r -> r.getString(textColumn), Collectors.toList()))));
        HashMap<Integer, Notes> result = new HashMap<Integer, Notes>();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<Notes> list = new ArrayList<Notes>();
            for (Map.Entry topicEntry : entry.getValue().entrySet()) {
                topicEntry.getValue().stream().map(s -> this.getHtmlNote((String)s)).filter(n -> n != null && !n.isEmpty()).forEach(n -> list.add(new StructuredNotes((Integer)topicEntry.getKey(), (String)topics.get(topicEntry.getKey()), (Notes)n)));
            }
            result.put(entry.getKey(), new ParentNotes(list));
        }
        return result;
    }

    private HtmlNotes getHtmlNote(String text) {
        if (text == null) {
            return null;
        }
        String html = text.replaceAll("[\\uFEFF\\uFFFE\\x00]", "");
        html = html.replaceAll("\\x7F\\x7F", "\n");
        return new HtmlNotes(html);
    }

    private void populateField(FieldContainer container, FieldType target, FieldType planned, FieldType actual) {
        Object value = container.getCachedValue(actual);
        if (value == null) {
            value = container.getCachedValue(planned);
        }
        container.set(target, value);
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_project.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    private void updateDates() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            Date startDate = parentTask.getStart();
            Date finishDate = parentTask.getFinish();
            Date plannedStartDate = parentTask.getStart(1);
            Date plannedFinishDate = parentTask.getFinish(1);
            Date actualStartDate = parentTask.getActualStart();
            Date actualFinishDate = parentTask.getActualFinish();
            Date earlyStartDate = parentTask.getEarlyStart();
            Date earlyFinishDate = parentTask.getEarlyFinish();
            Date lateStartDate = parentTask.getLateStart();
            Date lateFinishDate = parentTask.getLateFinish();
            Date baselineStartDate = parentTask.getBaselineStart();
            Date baselineFinishDate = parentTask.getBaselineFinish();
            Date remainingEarlyStartDate = parentTask.getRemainingEarlyStart();
            Date remainingEarlyFinishDate = parentTask.getRemainingEarlyFinish();
            boolean critical = false;
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                startDate = DateHelper.min(startDate, task.getStart());
                finishDate = DateHelper.max(finishDate, task.getFinish());
                plannedStartDate = DateHelper.min(plannedStartDate, task.getStart(1));
                plannedFinishDate = DateHelper.max(plannedFinishDate, task.getFinish(1));
                actualStartDate = DateHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = DateHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = DateHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = DateHelper.max(earlyFinishDate, task.getEarlyFinish());
                remainingEarlyStartDate = DateHelper.min(remainingEarlyStartDate, task.getRemainingEarlyStart());
                remainingEarlyFinishDate = DateHelper.max(remainingEarlyFinishDate, task.getRemainingEarlyFinish());
                lateStartDate = DateHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = DateHelper.max(lateFinishDate, task.getLateFinish());
                baselineStartDate = DateHelper.min(baselineStartDate, task.getBaselineStart());
                baselineFinishDate = DateHelper.max(baselineFinishDate, task.getBaselineFinish());
                if (task.getActualFinish() != null) {
                    ++finished;
                }
                critical = critical || task.getCritical();
            }
            parentTask.setStart(startDate);
            parentTask.setFinish(finishDate);
            parentTask.setStart(1, plannedStartDate);
            parentTask.setFinish(1, plannedFinishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setRemainingEarlyStart(remainingEarlyStartDate);
            parentTask.setRemainingEarlyFinish(remainingEarlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            parentTask.setBaselineStart(baselineStartDate);
            parentTask.setBaselineFinish(baselineFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            Duration plannedDuration = null;
            if (plannedStartDate != null && plannedFinishDate != null) {
                plannedDuration = this.m_project.getDefaultCalendar().getWork(plannedStartDate, plannedFinishDate, TimeUnit.HOURS);
                parentTask.setDuration(2, plannedDuration);
            }
            Duration remainingDuration = null;
            if (parentTask.getActualFinish() == null) {
                Date taskFinishDate;
                Date taskStartDate = parentTask.getRemainingEarlyStart();
                if (taskStartDate == null && (taskStartDate = parentTask.getEarlyStart()) == null) {
                    taskStartDate = plannedStartDate;
                }
                if ((taskFinishDate = parentTask.getRemainingEarlyFinish()) == null && (taskFinishDate = parentTask.getEarlyFinish()) == null) {
                    taskFinishDate = plannedFinishDate;
                }
                if (taskStartDate != null && taskFinishDate != null) {
                    remainingDuration = this.m_project.getDefaultCalendar().getWork(taskStartDate, taskFinishDate, TimeUnit.HOURS);
                }
            } else {
                remainingDuration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            parentTask.setRemainingDuration(remainingDuration);
            if (plannedDuration != null && remainingDuration != null && plannedDuration.getDuration() != 0.0) {
                double durationPercentComplete = (plannedDuration.getDuration() - remainingDuration.getDuration()) / plannedDuration.getDuration() * 100.0;
                if (durationPercentComplete < 0.0) {
                    durationPercentComplete = 0.0;
                } else if (durationPercentComplete > 100.0) {
                    durationPercentComplete = 100.0;
                }
                parentTask.setPercentageComplete(durationPercentComplete);
            }
            parentTask.setCritical(critical);
        }
    }

    private void updateWork() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateWork(task);
        }
    }

    private void updateWork(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            ProjectProperties properties = this.m_project.getProjectProperties();
            Duration actualWork = null;
            Duration baselineWork = null;
            Duration remainingWork = null;
            Duration work = null;
            for (Task task : parentTask.getChildTasks()) {
                this.updateWork(task);
                actualWork = Duration.add(actualWork, task.getActualWork(), properties);
                baselineWork = Duration.add(baselineWork, task.getBaselineWork(), properties);
                remainingWork = Duration.add(remainingWork, task.getRemainingWork(), properties);
                work = Duration.add(work, task.getWork(), properties);
            }
            parentTask.setActualWork(actualWork);
            parentTask.setBaselineWork(baselineWork);
            parentTask.setRemainingWork(remainingWork);
            parentTask.setWork(work);
        }
    }

    public void processPredecessors(List<Row> rows) {
        for (Row row : rows) {
            Object relation;
            Integer currentID = this.mapTaskID(row.getInteger("task_id"));
            Integer predecessorID = this.mapTaskID(row.getInteger("pred_task_id"));
            Task currentTask = this.m_project.getTaskByUniqueID(currentID);
            Task predecessorTask = this.m_project.getTaskByUniqueID(predecessorID);
            RelationType type = RELATION_TYPE_MAP.get(row.getString("pred_type"));
            Duration lag = row.getDuration("lag_hr_cnt");
            if (currentTask == null) continue;
            Integer uniqueID = row.getInteger("task_pred_id");
            if (predecessorTask != null) {
                relation = currentTask.addPredecessor(predecessorTask, type, lag);
                ((Relation)relation).setUniqueID(uniqueID);
                this.m_eventManager.fireRelationReadEvent((Relation)relation);
                continue;
            }
            relation = new ExternalRelation(predecessorID, currentTask, type, lag, true);
            this.m_externalRelations.add((ExternalRelation)relation);
            ((ExternalRelation)relation).setUniqueID(uniqueID);
        }
    }

    public void processAssignments(List<Row> rows) {
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("task_id")));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("rsrc_id"));
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            this.processFields(this.m_assignmentFields, row, assignment);
            this.populateField(assignment, AssignmentField.START, AssignmentField.START1, AssignmentField.ACTUAL_START);
            this.populateField(assignment, AssignmentField.FINISH, AssignmentField.FINISH1, AssignmentField.ACTUAL_FINISH);
            Duration remainingWork = row.getDuration("remain_qty");
            Duration actualOvertimeWork = row.getDuration("act_ot_qty");
            Duration actualRegularWork = row.getDuration("act_reg_qty");
            Duration actualWork = Duration.add(actualOvertimeWork, actualRegularWork, this.m_project.getProjectProperties());
            Duration totalWork = Duration.add(actualWork, remainingWork, this.m_project.getProjectProperties());
            assignment.setActualWork(actualWork);
            assignment.setWork(totalWork);
            Double remainingCost = row.getDouble("remain_cost");
            Double actualOvertimeCost = row.getDouble("act_ot_cost");
            Double actualRegularCost = row.getDouble("act_reg_cost");
            double actualCost = NumberHelper.getDouble(actualOvertimeCost) + NumberHelper.getDouble(actualRegularCost);
            double totalCost = actualCost + NumberHelper.getDouble(remainingCost);
            assignment.setActualCost(NumberHelper.getDouble(actualCost));
            assignment.setCost(NumberHelper.getDouble(totalCost));
            double units = resource.getType() == ResourceType.MATERIAL ? (totalWork == null ? 0.0 : totalWork.getDuration() * 100.0) : NumberHelper.getDouble(row.getDouble("target_qty_per_hr")) * 100.0;
            assignment.setUnits(NumberHelper.getDouble(units));
            this.populateUserDefinedFieldValues("TASKRSRC", FieldTypeClass.ASSIGNMENT, assignment, assignment.getUniqueID());
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
        this.updateTaskCosts();
    }

    private void updateTaskCosts() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateTaskCosts(task);
        }
    }

    private void updateTaskCosts(Task parentTask) {
        boolean baselinePresent = false;
        double baselineCost = 0.0;
        double actualCost = 0.0;
        double remainingCost = 0.0;
        double cost = 0.0;
        for (Task child : parentTask.getChildTasks()) {
            this.updateTaskCosts(child);
            baselinePresent = baselinePresent || child.getBaselineCost() != null;
            baselineCost += NumberHelper.getDouble(child.getBaselineCost());
            actualCost += NumberHelper.getDouble(child.getActualCost());
            remainingCost += NumberHelper.getDouble(child.getRemainingCost());
            cost += NumberHelper.getDouble(child.getCost());
        }
        List<ResourceAssignment> resourceAssignments = parentTask.getResourceAssignments();
        for (ResourceAssignment assignment : resourceAssignments) {
            baselinePresent = baselinePresent || assignment.getBaselineCost() != null;
            baselineCost += NumberHelper.getDouble(assignment.getBaselineCost());
            actualCost += NumberHelper.getDouble(assignment.getActualCost());
            remainingCost += NumberHelper.getDouble(assignment.getRemainingCost());
            cost += NumberHelper.getDouble(assignment.getCost());
        }
        if (baselinePresent) {
            parentTask.setBaselineCost(NumberHelper.getDouble(baselineCost));
        }
        parentTask.setActualCost(NumberHelper.getDouble(actualCost));
        parentTask.setRemainingCost(NumberHelper.getDouble(remainingCost));
        parentTask.setCost(NumberHelper.getDouble(cost));
    }

    public void processDefaultCurrency(Row row) {
        ProjectProperties properties = this.m_project.getProjectProperties();
        properties.setCurrencySymbol(row.getString("curr_symbol"));
        properties.setSymbolPosition(CURRENCY_SYMBOL_POSITION_MAP.get(row.getString("pos_curr_fmt_type")));
        properties.setCurrencyDigits(row.getInteger("decimal_digit_cnt"));
        properties.setThousandsSeparator(row.getString("digit_group_symbol").charAt(0));
        properties.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
    }

    public void processExpenseItems(List<Row> rows) {
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("task_id"));
            if (task == null) continue;
            List<ExpenseItem> items = task.getExpenseItems();
            if (items == null) {
                items = new ArrayList<ExpenseItem>();
                task.setExpenseItems(items);
            }
            ExpenseItem ei = new ExpenseItem(task);
            items.add(ei);
            ei.setAccount((CostAccount)this.m_project.getCostAccounts().getByUniqueID(row.getInteger("acct_id")));
            ei.setAccrueType(ACCRUE_TYPE_MAP.get(row.getString("cost_load_type")));
            ei.setActualCost(row.getDouble("act_cost"));
            ei.setAutoComputeActuals(row.getBoolean("auto_compute_act_flag"));
            ei.setCategory((ExpenseCategory)this.m_project.getExpenseCategories().getByUniqueID(row.getInteger("cost_type_id")));
            ei.setDescription(row.getString("cost_descr"));
            ei.setDocumentNumber(row.getString("po_number"));
            ei.setName(row.getString("cost_name"));
            ei.setPlannedCost(row.getDouble("target_cost"));
            ei.setPlannedUnits(row.getDouble("target_qty"));
            ei.setPricePerUnit(row.getDouble("cost_per_qty"));
            ei.setRemainingCost(row.getDouble("remain_cost"));
            ei.setUniqueID(row.getInteger("cost_item_id"));
            ei.setUnitOfMeasure(row.getString("qty_name"));
            ei.setVendor(row.getString("vendor_name"));
            double pricePerUnit = NumberHelper.getDouble(ei.getPricePerUnit());
            if (pricePerUnit == 0.0) continue;
            ei.setActualUnits(NumberHelper.getDouble(ei.getActualCost()) / pricePerUnit);
            ei.setRemainingUnits(NumberHelper.getDouble(ei.getRemainingCost()) / pricePerUnit);
        }
    }

    public void processScheduleOptions(Row row) {
        TreeMap<String, Object> customProperties = new TreeMap<String, Object>();
        customProperties.put("ConsiderAssignmentsInOtherProjects", row.getBoolean("level_outer_assign_flag"));
        customProperties.put("ConsiderAssignmentsInOtherProjectsWithPriorityEqualHigherThan", row.getString("level_outer_assign_priority"));
        customProperties.put("PreserveScheduledEarlyAndLateDates", row.getBoolean("level_keep_sched_date_flag"));
        customProperties.put("LevelAllResources", row.getBoolean("level_all_rsrc_flag"));
        customProperties.put("LevelResourcesOnlyWithinActivityTotalFloat", row.getBoolean("level_within_float_flag"));
        customProperties.put("PreserveMinimumFloatWhenLeveling", row.getString("level_float_thrs_cnt"));
        customProperties.put("MaxPercentToOverallocateResources", row.getString("level_over_alloc_pct"));
        customProperties.put("LevelingPriorities", row.getString("levelprioritylist"));
        customProperties.put("SetDataDateAndPlannedStartToProjectForecastStart", row.getBoolean("sched_setplantoforecast"));
        customProperties.put("IgnoreRelationshipsToAndFromOtherProjects", row.getString("sched_outer_depend_type"));
        customProperties.put("MakeOpenEndedActivitiesCritical", row.getBoolean("sched_open_critical_flag"));
        customProperties.put("UseExpectedFinishDates", row.getBoolean("sched_use_expect_end_flag"));
        customProperties.put("WhenSchedulingProgressedActivitiesUseRetainedLogic", row.getBoolean("sched_retained_logic"));
        customProperties.put("WhenSchedulingProgressedActivitiesUseProgressOverride", row.getBoolean("sched_progress_override"));
        customProperties.put("ComputeStartToStartLagFromEarlyStart", row.getBoolean("sched_lag_early_start_flag"));
        customProperties.put("CalculateFloatBasedOnFishDateOfEachProject", row.getBoolean("sched_use_project_end_date_for_float"));
        customProperties.put("ComputeTotalFloatAs", row.getString("sched_float_type"));
        customProperties.put("CalendarForSchedulingRelationshipLag", row.getString("sched_calendar_on_relationship_lag"));
        customProperties.put("CalculateMultipleFloatPaths", row.getBoolean("enable_multiple_longest_path_calc"));
        customProperties.put("CalculateMultiplePathsUsingTotalFloat", row.getBoolean("use_total_float_multiple_longest_paths"));
        customProperties.put("DisplayMultipleFloatPathsEndingWithActivity", row.getString("key_activity_for_multiple_longest_paths"));
        customProperties.put("LimitNumberOfPathsToCalculate", row.getBoolean("limit_multiple_longest_path_calc"));
        customProperties.put("NumberofPathsToCalculate", row.getString("max_multiple_longest_path"));
        customProperties.put("LagCalendar", row.getString("sched_calendar_on_relationship_lag"));
        customProperties.put("RetainedLogic", row.getBoolean("sched_retained_logic"));
        customProperties.put("ProgressOverride", row.getBoolean("sched_progress_override"));
        customProperties.put("IgnoreOtherProjectRelationships", row.getString("sched_outer_depend_type"));
        customProperties.put("StartToStartLagCalculationType", row.getBoolean("sched_lag_early_start_flag"));
        this.m_project.getProjectProperties().setCustomProperties(customProperties);
    }

    private void processFields(Map<FieldType, String> map, Row row, FieldContainer container) {
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            Object value;
            FieldType field = entry.getKey();
            String name = entry.getValue();
            switch (field.getDataType()) {
                case INTEGER: {
                    value = row.getInteger(name);
                    break;
                }
                case BOOLEAN: {
                    value = row.getBoolean(name);
                    break;
                }
                case DATE: {
                    value = row.getDate(name);
                    break;
                }
                case CURRENCY: 
                case NUMERIC: 
                case PERCENTAGE: {
                    value = row.getDouble(name);
                    break;
                }
                case DELAY: 
                case WORK: 
                case DURATION: {
                    value = row.getDuration(name);
                    break;
                }
                case RESOURCE_TYPE: {
                    value = RESOURCE_TYPE_MAP.get(row.getString(name));
                    break;
                }
                case TASK_TYPE: {
                    value = TASK_TYPE_MAP.get(row.getString(name));
                    break;
                }
                case CONSTRAINT: {
                    value = CONSTRAINT_TYPE_MAP.get(row.getString(name));
                    break;
                }
                case PRIORITY: {
                    value = PRIORITY_MAP.get(row.getString(name));
                    break;
                }
                case GUID: {
                    value = row.getUUID(name);
                    break;
                }
                default: {
                    value = row.getString(name);
                }
            }
            container.set(field, value);
        }
    }

    private Integer mapTaskID(Integer id) {
        Integer mappedID = this.m_clashMap.get(id);
        if (mappedID == null) {
            mappedID = id;
        }
        return mappedID;
    }

    private void applyAliases(Map<FieldType, String> aliases) {
        CustomFieldContainer fields = this.m_project.getCustomFields();
        for (Map.Entry<FieldType, String> entry : aliases.entrySet()) {
            fields.getCustomField(entry.getKey()).setAlias(entry.getValue()).setUserDefined(false);
        }
    }

    private Number calculatePercentComplete(Row row) {
        Number result;
        if (row.getDate("act_end_date") != null) {
            result = 100;
        } else {
            switch (PercentCompleteType.getInstance(row.getString("complete_pct_type"))) {
                case UNITS: {
                    result = this.calculateUnitsPercentComplete(row);
                    break;
                }
                case DURATION: {
                    result = this.calculateDurationPercentComplete(row);
                    break;
                }
                default: {
                    result = this.calculatePhysicalPercentComplete(row);
                }
            }
        }
        return result;
    }

    private Number calculatePhysicalPercentComplete(Row row) {
        return row.getDouble("phys_complete_pct");
    }

    private Number calculateUnitsPercentComplete(Row row) {
        double actualEquipmentQuantity;
        double result = 0.0;
        double actualWorkQuantity = NumberHelper.getDouble(row.getDouble("act_work_qty"));
        double numerator = actualWorkQuantity + (actualEquipmentQuantity = NumberHelper.getDouble(row.getDouble("act_equip_qty")));
        if (numerator != 0.0) {
            double remainingEquipmentQuantity;
            double remainingWorkQuantity = NumberHelper.getDouble(row.getDouble("remain_work_qty"));
            double denominator = remainingWorkQuantity + actualWorkQuantity + (remainingEquipmentQuantity = NumberHelper.getDouble(row.getDouble("remain_equip_qty"))) + actualEquipmentQuantity;
            result = denominator == 0.0 ? 0.0 : numerator * 100.0 / denominator;
        }
        return NumberHelper.getDouble(result);
    }

    private Number calculateDurationPercentComplete(Row row) {
        double result = 0.0;
        double targetDuration = row.getDuration("target_drtn_hr_cnt").getDuration();
        double remainingDuration = row.getDuration("remain_drtn_hr_cnt").getDuration();
        if (targetDuration == 0.0) {
            if (remainingDuration == 0.0 && "TK_Complete".equals(row.getString("status_code"))) {
                result = 100.0;
            }
        } else if (remainingDuration < targetDuration) {
            result = (targetDuration - remainingDuration) * 100.0 / targetDuration;
        }
        return NumberHelper.getDouble(result);
    }

    public static Map<FieldType, String> getDefaultResourceFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(ResourceField.UNIQUE_ID, "rsrc_id");
        map.put(ResourceField.GUID, "guid");
        map.put(ResourceField.NAME, "rsrc_name");
        map.put(ResourceField.CODE, "employee_code");
        map.put(ResourceField.EMAIL_ADDRESS, "email_addr");
        map.put(ResourceField.NOTES, "rsrc_notes");
        map.put(ResourceField.CREATED, "create_date");
        map.put(ResourceField.TYPE, "rsrc_type");
        map.put(ResourceField.INITIALS, "rsrc_short_name");
        map.put(ResourceField.PARENT_ID, "parent_rsrc_id");
        map.put(ResourceField.TEXT1, "rsrc_short_name");
        return map;
    }

    public static Map<FieldType, String> getDefaultWbsFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(TaskField.UNIQUE_ID, "wbs_id");
        map.put(TaskField.GUID, "guid");
        map.put(TaskField.NAME, "wbs_name");
        map.put(TaskField.REMAINING_COST, "indep_remain_total_cost");
        map.put(TaskField.REMAINING_WORK, "indep_remain_work_qty");
        map.put(TaskField.DEADLINE, "anticip_end_date");
        map.put(TaskField.WBS, "wbs_short_name");
        return map;
    }

    public static Map<FieldType, String> getDefaultTaskFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(TaskField.UNIQUE_ID, "task_id");
        map.put(TaskField.GUID, "guid");
        map.put(TaskField.NAME, "task_name");
        map.put(TaskField.ACTUAL_DURATION, "act_drtn_hr_cnt");
        map.put(TaskField.REMAINING_DURATION, "remain_drtn_hr_cnt");
        map.put(TaskField.ACTUAL_WORK, "act_work_qty");
        map.put(TaskField.REMAINING_WORK, "remain_work_qty");
        map.put(TaskField.DURATION1, "target_work_qty");
        map.put(TaskField.DURATION2, "target_drtn_hr_cnt");
        map.put(TaskField.DURATION, "target_drtn_hr_cnt");
        map.put(TaskField.CONSTRAINT_DATE, "cstr_date");
        map.put(TaskField.ACTUAL_START, "act_start_date");
        map.put(TaskField.ACTUAL_FINISH, "act_end_date");
        map.put(TaskField.LATE_START, "late_start_date");
        map.put(TaskField.LATE_FINISH, "late_end_date");
        map.put(TaskField.EARLY_START, "early_start_date");
        map.put(TaskField.EARLY_FINISH, "early_end_date");
        map.put(TaskField.REMAINING_EARLY_START, "restart_date");
        map.put(TaskField.REMAINING_EARLY_FINISH, "reend_date");
        map.put(TaskField.START1, "target_start_date");
        map.put(TaskField.FINISH1, "target_end_date");
        map.put(TaskField.CONSTRAINT_TYPE, "cstr_type");
        map.put(TaskField.SECONDARY_CONSTRAINT_DATE, "cstr_date2");
        map.put(TaskField.SECONDARY_CONSTRAINT_TYPE, "cstr_type2");
        map.put(TaskField.PRIORITY, "priority_type");
        map.put(TaskField.CREATED, "create_date");
        map.put(TaskField.TYPE, "duration_type");
        map.put(TaskField.FREE_SLACK, "free_float_hr_cnt");
        map.put(TaskField.TOTAL_SLACK, "total_float_hr_cnt");
        map.put(TaskField.TEXT1, "task_code");
        map.put(TaskField.TEXT2, "task_type");
        map.put(TaskField.TEXT3, "status_code");
        map.put(TaskField.NUMBER1, "rsrc_id");
        map.put(TaskField.DATE1, "suspend_date");
        map.put(TaskField.DATE2, "resume_date");
        return map;
    }

    public static Map<FieldType, String> getDefaultAssignmentFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(AssignmentField.UNIQUE_ID, "taskrsrc_id");
        map.put(AssignmentField.GUID, "guid");
        map.put(AssignmentField.REMAINING_WORK, "remain_qty");
        map.put(AssignmentField.DURATION1, "target_qty");
        map.put(AssignmentField.ACTUAL_OVERTIME_WORK, "act_ot_qty");
        map.put(AssignmentField.COST1, "target_cost");
        map.put(AssignmentField.ACTUAL_OVERTIME_COST, "act_ot_cost");
        map.put(AssignmentField.REMAINING_COST, "remain_cost");
        map.put(AssignmentField.ACTUAL_START, "act_start_date");
        map.put(AssignmentField.ACTUAL_FINISH, "act_end_date");
        map.put(AssignmentField.START1, "target_start_date");
        map.put(AssignmentField.FINISH1, "target_end_date");
        map.put(AssignmentField.ASSIGNMENT_DELAY, "target_lag_drtn_hr_cnt");
        return map;
    }

    public static Map<FieldType, String> getDefaultAliases() {
        HashMap<FieldType, String> map = new HashMap<FieldType, String>();
        map.put(TaskField.DATE1, "Suspend Date");
        map.put(TaskField.DATE2, "Resume Date");
        map.put(TaskField.TEXT1, "Code");
        map.put(TaskField.TEXT2, "Activity Type");
        map.put(TaskField.TEXT3, "Status");
        map.put(TaskField.NUMBER1, "Primary Resource Unique ID");
        map.put(TaskField.DURATION1, "Planned Work");
        map.put(TaskField.DURATION2, "Planned Duration");
        map.put(TaskField.START1, "Planned Start");
        map.put(TaskField.FINISH1, "Planned Finish");
        map.put(ResourceField.TEXT1, "Resource ID");
        map.put(AssignmentField.START1, "Planned Start");
        map.put(AssignmentField.FINISH1, "Planned Finish");
        map.put(AssignmentField.COST1, "Planned Cost");
        map.put(AssignmentField.DURATION1, "Planned Work");
        return map;
    }

    static {
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Mat", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("RT_Equip", ResourceType.COST);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("CS_MSO", ConstraintType.START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MSOB", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MSOA", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEO", ConstraintType.FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MEOB", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEOA", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_ALAP", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("CS_MANDSTART", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MANDFIN", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("PT_Top", Priority.getInstance(900));
        PRIORITY_MAP.put("PT_High", Priority.getInstance(600));
        PRIORITY_MAP.put("PT_Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("PT_Low", Priority.getInstance(400));
        PRIORITY_MAP.put("PT_Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("PR_FS", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("PR_FF", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("PR_SS", RelationType.START_START);
        RELATION_TYPE_MAP.put("PR_SF", RelationType.START_FINISH);
        TASK_TYPE_MAP = new HashMap<String, TaskType>();
        TASK_TYPE_MAP.put("DT_FixedDrtn", TaskType.FIXED_DURATION);
        TASK_TYPE_MAP.put("DT_FixedQty", TaskType.FIXED_UNITS);
        TASK_TYPE_MAP.put("DT_FixedDUR2", TaskType.FIXED_WORK);
        TASK_TYPE_MAP.put("DT_FixedRate", TaskType.FIXED_WORK);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("TT_Task", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Rsrc", Boolean.FALSE);
        MILESTONE_MAP.put("TT_LOE", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Mile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_FinMile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_WBS", Boolean.FALSE);
        TIME_UNIT_MAP = new HashMap<String, TimeUnit>();
        TIME_UNIT_MAP.put("QT_Minute", TimeUnit.MINUTES);
        TIME_UNIT_MAP.put("QT_Hour", TimeUnit.HOURS);
        TIME_UNIT_MAP.put("QT_Day", TimeUnit.DAYS);
        TIME_UNIT_MAP.put("QT_Week", TimeUnit.WEEKS);
        TIME_UNIT_MAP.put("QT_Month", TimeUnit.MONTHS);
        TIME_UNIT_MAP.put("QT_Year", TimeUnit.YEARS);
        CURRENCY_SYMBOL_POSITION_MAP = new HashMap<String, CurrencySymbolPosition>();
        CURRENCY_SYMBOL_POSITION_MAP.put("#1.1", CurrencySymbolPosition.BEFORE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1#", CurrencySymbolPosition.AFTER);
        CURRENCY_SYMBOL_POSITION_MAP.put("# 1.1", CurrencySymbolPosition.BEFORE_WITH_SPACE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1 #", CurrencySymbolPosition.AFTER_WITH_SPACE);
        STATICTYPE_UDF_MAP = new HashMap<String, Boolean>();
        STATICTYPE_UDF_MAP.put("UDF_G0", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G1", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G2", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G3", Boolean.TRUE);
        STATICTYPE_UDF_MAP.put("UDF_G4", Boolean.TRUE);
        FIELD_TYPE_MAP = new HashMap<String, FieldTypeClass>();
        FIELD_TYPE_MAP.put("PROJWBS", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("TASK", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("RSRC", FieldTypeClass.RESOURCE);
        FIELD_TYPE_MAP.put("TASKRSRC", FieldTypeClass.ASSIGNMENT);
        ACCRUE_TYPE_MAP = new HashMap<String, AccrueType>();
        ACCRUE_TYPE_MAP.put("CL_Uniform", AccrueType.PRORATED);
        ACCRUE_TYPE_MAP.put("CL_End", AccrueType.END);
        ACCRUE_TYPE_MAP.put("CL_Start", AccrueType.START);
    }
}

