/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.menu;

import com.macrofocus.application.ToggleUICommand;
import com.macrofocus.application.menu.AbstractMenu;
import com.macrofocus.application.menu.SwingRadioButtonMenuItem;
import com.macrofocus.application.menu.ToggleGroup;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.helper.WeakActionListeners;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SwingMenu
extends AbstractMenu<JComponent> {
    private JMenu menu;
    private final WeakActionListeners actionListeners = new WeakActionListeners();
    private final PropertyListener<String> titleListener = new PropertyListener<String>(){

        public void propertyChanged(PropertyEvent<String> event) {
            SwingMenu.this.menu.setText((String)event.getNewValue());
        }
    };

    public SwingMenu(String title) {
        this.menu = new JMenu(title);
    }

    public SwingMenu(Property<String> title) {
        this.menu = new JMenu((String)title.getValue());
        title.addPropertyListener(this.titleListener);
    }

    public SwingMenu addMenu(String title) {
        SwingMenu subMenu = new SwingMenu(title);
        this.menu.add(subMenu.getNativeComponent());
        return subMenu;
    }

    public SwingMenu addMenu(Property title) {
        SwingMenu subMenu = new SwingMenu((Property<String>)title);
        this.menu.add(subMenu.getNativeComponent());
        return subMenu;
    }

    public void addAction(String title, String keystroke, final Command command) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(keystroke));
        menuItem.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command.execute();
            }
        }, (Object)menuItem));
        menuItem.setEnabled(command != null);
        this.menu.add(menuItem);
    }

    public void addAction(UICommand command) {
        JMenuItem menuItem = SwingMenu.createUICommandMenuItem(command, this.actionListeners);
        this.menu.add(menuItem);
    }

    public static JMenuItem createUICommandMenuItem(final UICommand command, WeakActionListeners actionListeners) {
        final JMenuItem menuItem = new JMenuItem((String)command.titleProperty().getValue());
        command.titleProperty().addPropertyListener((PropertyListener)new TitlePropertyListener(menuItem));
        if (command.keystrokeProperty() != null) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke((String)command.keystrokeProperty().getValue()));
            command.keystrokeProperty().addPropertyListener((PropertyListener)new PropertyListener<String>(){

                public void propertyChanged(PropertyEvent<String> event) {
                    menuItem.setAccelerator(KeyStroke.getKeyStroke((String)event.getNewValue()));
                }
            });
        }
        if (command.iconProperty() != null) {
            Object value = command.iconProperty().getValue();
            if (value instanceof Icon) {
                menuItem.setIcon((Icon)value);
            }
            command.iconProperty().addPropertyListener((PropertyListener)new PropertyListener<Object>(){

                public void propertyChanged(PropertyEvent<Object> event) {
                    if (event.getNewValue() instanceof Icon) {
                        menuItem.setIcon((Icon)event.getNewValue());
                    }
                }
            });
        }
        menuItem.setEnabled((Boolean)command.enabledProperty().getValue() != false && command != null);
        command.enabledProperty().addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event) {
                menuItem.setEnabled((Boolean)event.getNewValue());
            }
        });
        menuItem.addActionListener(actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command.execute(e.getSource());
            }
        }, (Object)menuItem));
        return menuItem;
    }

    public void addEllipsisAction(String title, String keystroke, final Command command) {
        JMenuItem menuItem = new JMenuItem(title + "...");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(keystroke));
        menuItem.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command.execute();
            }
        }, (Object)menuItem));
        menuItem.setEnabled(command != null);
        this.menu.add(menuItem);
    }

    public void addEllipsisAction(final UICommand command) {
        final JMenuItem menuItem = new JMenuItem((String)command.titleProperty().getValue() + "...");
        command.titleProperty().addPropertyListener((PropertyListener)new PropertyListener<String>(){

            public void propertyChanged(PropertyEvent<String> event) {
                menuItem.setText((String)event.getNewValue() + "...");
            }
        });
        if (command.keystrokeProperty() != null) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke((String)command.keystrokeProperty().getValue()));
            command.keystrokeProperty().addPropertyListener((PropertyListener)new PropertyListener<String>(){

                public void propertyChanged(PropertyEvent<String> event) {
                    menuItem.setAccelerator(KeyStroke.getKeyStroke((String)event.getNewValue()));
                }
            });
        }
        if (command.iconProperty() != null) {
            Object value = command.iconProperty().getValue();
            if (value instanceof Icon) {
                menuItem.setIcon((Icon)value);
            }
            command.iconProperty().addPropertyListener((PropertyListener)new PropertyListener<Object>(){

                public void propertyChanged(PropertyEvent<Object> event) {
                    if (event.getNewValue() instanceof Icon) {
                        menuItem.setIcon((Icon)event.getNewValue());
                    }
                }
            });
        }
        menuItem.setEnabled((Boolean)command.enabledProperty().getValue() != false && command != null);
        command.enabledProperty().addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event) {
                menuItem.setEnabled((Boolean)event.getNewValue());
            }
        });
        menuItem.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command.execute(e.getSource());
            }
        }, (Object)menuItem));
        this.menu.add(menuItem);
    }

    public void addCheckBox(ToggleUICommand command) {
        JCheckBoxMenuItem menuItem = SwingMenu.createToggleUICommandMenuItem(command, this.actionListeners);
        this.menu.add(menuItem);
    }

    public static JCheckBoxMenuItem createToggleUICommandMenuItem(final ToggleUICommand command, WeakActionListeners actionListeners) {
        final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem((String)command.titleProperty().getValue());
        command.titleProperty().addPropertyListener((PropertyListener)new TitlePropertyListener(menuItem));
        if (command.keystrokeProperty() != null) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke((String)command.keystrokeProperty().getValue()));
            command.keystrokeProperty().addPropertyListener((PropertyListener)new PropertyListener<String>(){

                public void propertyChanged(PropertyEvent<String> event) {
                    menuItem.setAccelerator(KeyStroke.getKeyStroke((String)event.getNewValue()));
                }
            });
        }
        menuItem.setEnabled((Boolean)command.enabledProperty().getValue() != false && command != null);
        command.enabledProperty().addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event) {
                menuItem.setEnabled((Boolean)event.getNewValue());
            }
        });
        menuItem.addActionListener(actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command.execute(e.getSource());
            }
        }, (Object)menuItem));
        menuItem.setState((Boolean)command.toggleProperty().getValue());
        command.toggleProperty().addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event) {
                menuItem.setState((Boolean)event.getNewValue());
            }
        });
        return menuItem;
    }

    public void addCheckBox(String title, String keystroke, MutableProperty<Boolean> property) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(keystroke));
        new BooleanPropertyToggleButtonModelCoordinator(property, menuItem.getModel());
        this.menu.add(menuItem);
    }

    public <T> void addRadio(String title, MutableProperty<T> property, T ... values) {
        SwingMenu subMenu = this.addMenu(title);
        for (T value : values) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(value.toString());
            if (property != null) {
                new EqualPropertyToggleButtonModelCoordinator<T>(property, value, menuItem.getModel());
            }
            subMenu.getNativeComponent().add(menuItem);
        }
        this.menu.add(subMenu.getNativeComponent());
    }

    public void addRadio(ToggleUICommand command, ToggleGroup group) {
        SwingRadioButtonMenuItem menuItem = new SwingRadioButtonMenuItem(command);
        this.menu.add(menuItem.getNativeComponent());
        group.add(command);
    }

    public void addLink(Property<String> property, String url) {
        JMenuItem menuItem = new JMenuItem((String)property.getValue());
        menuItem.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Desktop.getDesktop().browse(new URL("url").toURI());
                }
                catch (IOException e) {
                    Logging.getInstance().process((Throwable)e);
                }
                catch (URISyntaxException e) {
                    Logging.getInstance().process((Throwable)e);
                }
            }
        }, (Object)menuItem));
        menuItem.setEnabled(url != null);
        this.menu.add(menuItem);
    }

    public void addSeparator() {
        this.menu.add(new JSeparator());
    }

    public void removeAll() {
        this.menu.removeAll();
    }

    public JMenu getNativeComponent() {
        return this.menu;
    }

    public void add(JMenuItem menuItem) {
        this.menu.add(menuItem);
    }

    private static class TitlePropertyListener
    implements PropertyListener<String> {
        private final JMenuItem menuItem;

        public TitlePropertyListener(JMenuItem menuItem) {
            this.menuItem = menuItem;
        }

        public void propertyChanged(PropertyEvent<String> event) {
            this.menuItem.setText((String)event.getNewValue());
        }
    }

    private static final class BooleanPropertyToggleButtonModelCoordinator {
        public BooleanPropertyToggleButtonModelCoordinator(final MutableProperty<Boolean> property, final ButtonModel buttonModel) {
            if (property != null) {
                property.addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

                    public void propertyChanged(PropertyEvent<Boolean> event) {
                        buttonModel.setSelected((Boolean)event.getNewValue());
                    }
                });
                buttonModel.setSelected((Boolean)property.getValue());
                buttonModel.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        property.setValue((Object)buttonModel.isSelected());
                    }
                });
            }
        }
    }

    private static final class EqualPropertyToggleButtonModelCoordinator<V> {
        public EqualPropertyToggleButtonModelCoordinator(final MutableProperty<V> property, final V value, final ButtonModel buttonModel) {
            property.addPropertyListener(new PropertyListener<V>(){

                public void propertyChanged(PropertyEvent<V> event) {
                    buttonModel.setSelected(event.getNewValue() == value);
                }
            });
            buttonModel.setSelected(property.getValue() == value);
            buttonModel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (buttonModel.isSelected()) {
                        property.setValue(value);
                    }
                }
            });
        }
    }
}

