/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockbarDeactivator;
import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.DockbarSlidePanel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;

class DockbarTracker
implements PropertyChangeListener,
AWTEventListener {
    DockbarTracker() {
    }

    public static void register() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DockbarTracker tracker = new DockbarTracker();
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                focusManager.addPropertyChangeListener(tracker);
                long evtType = 48L;
                Toolkit.getDefaultToolkit().addAWTEventListener(tracker, evtType);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Component newWindow;
        if ("activeWindow".equals(evt.getPropertyName()) && (newWindow = (Component)evt.getNewValue()) != null) {
            DockbarManager.windowChanged(newWindow);
        }
    }

    @Override
    public void eventDispatched(AWTEvent evt) {
        DockbarDeactivator deactivator;
        int evtType = evt.getID();
        if (evtType != 503 && evtType != 501) {
            return;
        }
        DockbarManager mgr = DockbarManager.getCurrent();
        DockbarDeactivator dockbarDeactivator = deactivator = mgr == null ? null : mgr.getDockbarDeactivator();
        if (deactivator == null || !mgr.isDockbarActive()) {
            return;
        }
        MouseEvent me = (MouseEvent)evt;
        DockbarSlidePanel slidePanel = mgr.getSlidePanel();
        Point p = SwingUtilities.convertPoint((Component)me.getSource(), me.getPoint(), slidePanel.getRootPane());
        boolean mouseOver = SwingUtilities.convertRectangle(slidePanel.getParent(), slidePanel.getBounds(), slidePanel.getRootPane()).contains(p);
        if (evtType == 501) {
            deactivator.mousePressed(p, mouseOver);
        } else {
            this.handleMouseMove(deactivator, p, mouseOver);
        }
    }

    private void handleMouseMove(DockbarDeactivator deactivator, Point mousePoint, boolean mouseOver) {
        if (mouseOver) {
            if (!deactivator.isMouseOver()) {
                deactivator.mouseEntered(mousePoint);
            }
        } else if (deactivator.isMouseOver()) {
            deactivator.mouseExited(mousePoint);
        }
    }
}

