/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DragManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingPort;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class DragOperation
implements IDockingConstants {
    private Component dragSource;
    private JComponent dockable;
    private IDockingPort parentDockingPort;
    private Point mouseOffset;
    private Point currentMouse;
    private Point currentMouseOnScreen;
    private EventListener[] cachedListeners;
    private DragManager dragListener;
    private IDockingPort targetPort;
    private String targetRegion;
    private boolean overWindow;
    private boolean pseudoDrag;
    private long started;
    private IDockable dockableRef;
    private IDockingPort sourcePort;
    private boolean canceled;
    private int dropTabIndex;

    public DragOperation(JComponent dockable, Point dragOrigin, MouseEvent evt) {
        if (dockable == null) {
            throw new NullPointerException("'dockable' parameter cannot be null.");
        }
        if (evt == null) {
            throw new NullPointerException("'evt' parameter cannot be null.");
        }
        if (!(evt.getSource() instanceof Component)) {
            throw new IllegalArgumentException("'evt.getSource()' must be an instance of java.awt.Component.");
        }
        if (dragOrigin == null) {
            dragOrigin = evt.getPoint();
        }
        this.init(dockable, (Component)evt.getSource(), dragOrigin, false);
    }

    private void init(JComponent dockable, Component dragSource, Point currentMouse, boolean fakeDrag) {
        this.dockable = dockable;
        this.dragSource = dragSource;
        this.currentMouse = currentMouse;
        this.currentMouseOnScreen = (Point)currentMouse.clone();
        SwingUtilities.convertPointToScreen(this.currentMouseOnScreen, dragSource);
        this.mouseOffset = this.calculateMouseOffset(currentMouse);
        this.pseudoDrag = fakeDrag;
        if (!fakeDrag) {
            this.parentDockingPort = (IDockingPort)((Object)SwingUtilities.getAncestorOfClass(IDockingPort.class, dockable));
        }
        this.sourcePort = DockingManager.getDockingPort(dockable);
        this.started = -1L;
    }

    private Point calculateMouseOffset(Point evtPoint) {
        if (evtPoint == null) {
            return null;
        }
        Point dockableLoc = this.dockable.getLocationOnScreen();
        Point p = new Point(evtPoint);
        SwingUtilities.convertPointToScreen(p, this.dragSource);
        Point offset = new Point();
        offset.x = dockableLoc.x - p.x;
        offset.y = dockableLoc.y - p.y;
        return offset;
    }

    public JComponent getDockableComponent() {
        return this.dockable;
    }

    public IDockable getDockableReference() {
        if (this.dockableRef == null) {
            this.dockableRef = DockingManager.getDockable(this.dockable);
        }
        return this.dockableRef;
    }

    public Point getMouseOffset() {
        return (Point)this.mouseOffset.clone();
    }

    public void updateMouse(MouseEvent me) {
        if (me != null && me.getSource() == this.dragSource) {
            this.currentMouse = me.getPoint();
            this.currentMouseOnScreen = (Point)this.currentMouse.clone();
            SwingUtilities.convertPointToScreen(this.currentMouseOnScreen, this.dragSource);
        }
    }

    public Point getCurrentMouse() {
        return this.getCurrentMouse(false);
    }

    public Point getCurrentMouse(boolean relativeToScreen) {
        Point p = relativeToScreen ? this.currentMouseOnScreen : this.currentMouse;
        return p == null ? null : new Point(p);
    }

    public Rectangle getDragRect(boolean relativeToScreen) {
        Point p = this.getCurrentMouse(relativeToScreen);
        Point offset = this.getMouseOffset();
        p.x += offset.x;
        p.y += offset.y;
        Rectangle r = new Rectangle(this.getDragSize());
        r.setLocation(p);
        return r;
    }

    public Point getCurrentMouse(Component target) {
        if (target == null || !target.isVisible()) {
            return null;
        }
        return SwingUtilities.convertPoint(this.dragSource, this.currentMouse, target);
    }

    public Dimension getDragSize() {
        return this.dockable.getSize();
    }

    public Component getDragSource() {
        return this.dragSource;
    }

    public void setTarget(IDockingPort port, String region) {
        this.targetPort = port;
        this.targetRegion = region == null ? "UNKNOWN" : region;
    }

    public IDockingPort getTargetPort() {
        return this.targetPort;
    }

    public String getTargetRegion() {
        return this.targetRegion;
    }

    public EventListener[] getCachedListeners() {
        return this.cachedListeners == null ? new EventListener[]{} : this.cachedListeners;
    }

    public void setCachedListeners(EventListener[] listeners) {
        this.cachedListeners = listeners;
    }

    public DragManager getDragListener() {
        return this.dragListener;
    }

    public void setDragListener(DragManager listener) {
        this.dragListener = listener;
    }

    public boolean isOverWindow() {
        return this.overWindow;
    }

    public void setOverWindow(boolean overWindow) {
        this.overWindow = overWindow;
    }

    public boolean isPseudoDrag() {
        return this.pseudoDrag;
    }

    public IDockingPort getParentDockingPort() {
        return this.parentDockingPort;
    }

    public void start() {
        if (this.started == -1L) {
            this.started = System.currentTimeMillis();
        }
    }

    public long getStartTime() {
        return this.started;
    }

    public IDockingPort getSourcePort() {
        return this.sourcePort;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public int getDropTabIndex() {
        return this.dropTabIndex;
    }

    public void setDropTabIndex(int dropTabIndex) {
        this.dropTabIndex = dropTabIndex;
    }
}

