/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.data.AbstractMutableDataModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.MutableDataEvent;
import com.macrofocus.data.db.JDBCTypes;
import com.macrofocus.data.row.RowModel;
import com.macrofocus.data.row.SimpleRowModel;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RowMajorDataModel
extends AbstractMutableDataModel {
    private final List rowModels;
    private Class[] classes = null;
    private Object[] names = null;

    public RowMajorDataModel(ResultSet rs) {
        this();
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            this.classes = new Class[columnCount];
            this.names = new Object[columnCount];
            for (int c = 1; c <= columnCount; ++c) {
                this.names[c - 1] = meta.getColumnName(c);
                this.classes[c - 1] = JDBCTypes.getType(meta.getColumnType(c));
            }
            while (rs.next()) {
                Object[] array = new Object[columnCount];
                for (int c = 1; c <= columnCount; ++c) {
                    Class cl = this.classes[c - 1];
                    Object object = null;
                    if (cl.equals(String.class)) {
                        object = rs.getString(c);
                    } else if (cl.equals(Integer.class)) {
                        object = rs.getInt(c);
                    } else if (cl.equals(Long.class)) {
                        object = rs.getLong(c);
                    } else if (cl.equals(Double.class)) {
                        object = rs.getDouble(c);
                    } else if (cl.equals(BigDecimal.class)) {
                        object = rs.getBigDecimal(c);
                    } else if (cl.equals(Boolean.class)) {
                        object = rs.getBoolean(c);
                    } else {
                        System.err.println("RowMajorDataModel: Unknown class " + String.valueOf(cl));
                        object = rs.getObject(c);
                    }
                    array[c - 1] = object;
                }
                this.addRowModel(new SimpleRowModel(array, this.classes, this.names));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public RowMajorDataModel(DataModel dataModel) {
        this();
        for (int row = 0; row < dataModel.getRowCount(); ++row) {
            this.addRowModel(dataModel.getRowModel(row));
        }
    }

    public RowMajorDataModel(Object[] names, Class[] classes) {
        this.classes = classes;
        this.names = names;
        this.rowModels = new ArrayList();
    }

    public RowMajorDataModel() {
        this.rowModels = new ArrayList();
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return ((RowModel)this.rowModels.get(row)).isAvailable(column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return ((RowModel)this.rowModels.get(row)).getObject(column);
    }

    @Override
    public Object getColumnName(int column) {
        if (this.names != null) {
            return this.names[column];
        }
        return ((RowModel)this.rowModels.get(0)).getName(column);
    }

    @Override
    public Class getColumnClass(int column) {
        if (this.classes != null) {
            return this.classes[column];
        }
        return ((RowModel)this.rowModels.get(0)).getMembership(column);
    }

    @Override
    public int getRowCount() {
        return this.rowModels.size();
    }

    @Override
    public int getColumnCount() {
        if (this.classes != null) {
            return this.classes.length;
        }
        if (this.rowModels.size() > 0) {
            return ((RowModel)this.rowModels.get(0)).getColumnCount();
        }
        return 0;
    }

    @Override
    public RowModel getRowModel(int row) {
        return (RowModel)this.rowModels.get(row);
    }

    public void addRowModel(RowModel rowModel) {
        this.rowModels.add(rowModel);
        this.notifyMutableDataChanged(new MutableDataEvent(this, this, -1, -1));
    }

    public void addRowModel(int index, RowModel rowModel) {
        this.rowModels.add(index, rowModel);
        this.notifyMutableDataChanged(new MutableDataEvent(this, this, -1, -1));
    }

    public void removeRowModel(RowModel rowModel) {
        this.rowModels.remove(rowModel);
        this.notifyMutableDataChanged(new MutableDataEvent(this, this, -1, -1));
    }

    public void removeRowModel(int index) {
        this.rowModels.remove(index);
        this.notifyMutableDataChanged(new MutableDataEvent(this, this, -1, -1));
    }
}

