/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.timed;

import com.macrofocus.data.matrix.timed.AbstractTimedMatrixModel;
import com.macrofocus.data.matrix.timed.TimedMatrixModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;

public final class CacheTimedMatrixModel
extends AbstractTimedMatrixModel
implements Externalizable {
    static final long serialVersionUID = -4851670709070124343L;
    private double[][] array;
    private boolean[][] isAvailable;
    private Date[] datesAsDate;
    private long[] datesAsLong;
    private Object datesName;
    private Object[] name;
    private int rowCount;
    private int columnCount;

    public CacheTimedMatrixModel() {
    }

    public CacheTimedMatrixModel(TimedMatrixModel matrixModel) {
        this(matrixModel, true, true, false);
    }

    public CacheTimedMatrixModel(TimedMatrixModel matrixModel, boolean allAvailable, boolean datesAsLong, boolean datesAsDate) {
        int row;
        int row2;
        int column;
        this.columnCount = matrixModel.getColumnCount();
        this.rowCount = matrixModel.getRowCount();
        this.array = new double[this.rowCount][this.columnCount];
        this.name = new Object[this.columnCount];
        this.datesName = matrixModel.getDatesName();
        for (column = 0; column < matrixModel.getColumnCount(); ++column) {
            this.name[column] = matrixModel.getColumnName(column);
            for (row2 = 0; row2 < matrixModel.getRowCount(); ++row2) {
                if (!matrixModel.isAvailable(row2, column)) continue;
                this.array[row2][column] = matrixModel.getDouble(row2, column);
            }
        }
        if (!allAvailable) {
            this.isAvailable = new boolean[this.rowCount][this.columnCount];
            for (column = 0; column < matrixModel.getColumnCount(); ++column) {
                for (row2 = 0; row2 < matrixModel.getRowCount(); ++row2) {
                    this.isAvailable[row2][column] = matrixModel.isAvailable(row2, column);
                }
            }
        } else {
            this.isAvailable = null;
        }
        if (datesAsLong) {
            this.datesAsLong = new long[this.rowCount];
            for (row = 0; row < matrixModel.getRowCount(); ++row) {
                this.datesAsLong[row] = matrixModel.getTimestamp(row).getTime();
            }
        } else {
            this.datesAsLong = null;
        }
        if (datesAsDate) {
            this.datesAsDate = new Date[this.rowCount];
            for (row = 0; row < matrixModel.getRowCount(); ++row) {
                this.datesAsDate[row] = matrixModel.getTimestamp(row);
            }
        } else {
            this.datesAsDate = null;
        }
    }

    @Override
    public Date getTimestamp(int row) {
        return this.datesAsDate != null ? this.datesAsDate[row] : new Date(this.datesAsLong[row]);
    }

    @Override
    public long getTime(int row) {
        return this.datesAsLong != null ? this.datesAsLong[row] : this.datesAsDate[row].getTime();
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this.isAvailable == null || this.isAvailable[row][column];
    }

    @Override
    public Object getDatesName() {
        return this.datesName;
    }

    @Override
    public Object getColumnName(int column) {
        return this.name[column];
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public Class getColumnClass(int column) {
        return Double.class;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public double getDouble(int row, int column) {
        try {
            return this.array[row][column];
        }
        catch (Exception e) {
            System.err.println("Error at " + row + ", " + column);
            return Double.NaN;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int column;
        int row;
        out.writeInt(10100);
        out.writeInt(this.getRowCount());
        out.writeInt(this.getColumnCount());
        out.writeBoolean(this.isAvailable != null);
        out.writeBoolean(false);
        out.writeBoolean(true);
        for (int column2 = 0; column2 < this.getColumnCount(); ++column2) {
            out.writeObject(this.name[column2]);
        }
        if (this.isAvailable != null) {
            for (row = 0; row < this.getRowCount(); ++row) {
                for (column = 0; column < this.getColumnCount(); ++column) {
                    out.writeBoolean(this.isAvailable[row][column]);
                }
            }
        }
        for (row = 0; row < this.getRowCount(); ++row) {
            for (column = 0; column < this.getColumnCount(); ++column) {
                if (this.isAvailable != null && !this.isAvailable(row, column)) continue;
                out.writeDouble(this.array[row][column]);
            }
        }
        out.writeObject(this.datesName);
        for (row = 0; row < this.getRowCount(); ++row) {
            out.writeLong(this.getTimestamp(row).getTime());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        block17: {
            int column;
            int row;
            int version;
            block16: {
                int column2;
                int row2;
                version = in.readInt();
                if (version != 10000) break block16;
                this.rowCount = in.readInt();
                this.columnCount = in.readInt();
                this.name = new Object[this.columnCount];
                this.isAvailable = new boolean[this.rowCount][this.columnCount];
                this.array = new double[this.rowCount][this.columnCount];
                for (int column3 = 0; column3 < this.columnCount; ++column3) {
                    this.name[column3] = in.readObject();
                }
                for (row2 = 0; row2 < this.getRowCount(); ++row2) {
                    for (column2 = 0; column2 < this.getColumnCount(); ++column2) {
                        this.isAvailable[row2][column2] = in.readBoolean();
                    }
                }
                for (row2 = 0; row2 < this.getRowCount(); ++row2) {
                    for (column2 = 0; column2 < this.getColumnCount(); ++column2) {
                        if (!this.isAvailable(row2, column2)) continue;
                        this.array[row2][column2] = in.readDouble();
                    }
                }
                this.isAvailable = null;
                this.datesName = in.readObject();
                this.datesAsDate = new Date[this.rowCount];
                for (row2 = 0; row2 < this.getRowCount(); ++row2) {
                    this.datesAsDate[row2] = (Date)in.readObject();
                }
                break block17;
            }
            if (version <= 10000) break block17;
            this.rowCount = in.readInt();
            this.columnCount = in.readInt();
            boolean isAvailable = in.readBoolean();
            boolean datesAsDate = in.readBoolean();
            boolean datesAsLong = in.readBoolean();
            this.name = new Object[this.columnCount];
            this.array = new double[this.rowCount][this.columnCount];
            for (int column4 = 0; column4 < this.columnCount; ++column4) {
                this.name[column4] = in.readObject();
            }
            if (isAvailable) {
                this.isAvailable = new boolean[this.rowCount][this.columnCount];
                for (row = 0; row < this.getRowCount(); ++row) {
                    for (column = 0; column < this.getColumnCount(); ++column) {
                        this.isAvailable[row][column] = in.readBoolean();
                    }
                }
            }
            for (row = 0; row < this.getRowCount(); ++row) {
                for (column = 0; column < this.getColumnCount(); ++column) {
                    if (this.isAvailable != null && !this.isAvailable(row, column)) continue;
                    this.array[row][column] = in.readDouble();
                }
            }
            this.datesName = in.readObject();
            if (datesAsDate) {
                this.datesAsDate = new Date[this.rowCount];
                for (row = 0; row < this.getRowCount(); ++row) {
                    this.datesAsDate[row] = (Date)in.readObject();
                }
            }
            if (datesAsLong) {
                this.datesAsLong = new long[this.rowCount];
                for (row = 0; row < this.getRowCount(); ++row) {
                    this.datesAsLong[row] = in.readLong();
                }
            }
        }
    }
}

