/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.data.source.FileURLDataSource;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HTMLTableDataSource
extends FileURLDataSource {
    static final String type = "HTMLTable";

    public HTMLTableDataSource(File file) {
        super(file);
    }

    public HTMLTableDataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        DefaultTableModel tableModel = HTMLTableDataSource.parseHtmlTable(Jsoup.parse((InputStream)bis, (String)"UTF-8", (String)""));
        bis.close();
        return tableModel;
    }

    public static DefaultTableModel parseHtmlTable(Document doc) {
        Element table = doc.selectFirst("table");
        if (table == null) {
            return new DefaultTableModel();
        }
        Elements headerCells = new Elements();
        for (Object tr : table.select("tr")) {
            Elements ths = tr.select("th");
            if (ths.isEmpty()) continue;
            headerCells = ths;
            break;
        }
        Vector<String> columnNames = new Vector<String>();
        for (Element th : headerCells) {
            columnNames.add(HTMLTableDataSource.cleanHeaderText(th.text()));
        }
        final Vector data = new Vector();
        for (Element tr : table.select("tr")) {
            Elements tds = tr.select("td");
            if (tds.isEmpty()) continue;
            Vector<Object> row = new Vector<Object>();
            for (Element td : tds) {
                row.add(HTMLTableDataSource.parseValue(td.text()));
            }
            data.add(row);
        }
        return new DefaultTableModel(data, columnNames){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                for (Vector row : data) {
                    Object value = row.get(columnIndex);
                    if (value == null) continue;
                    return value.getClass();
                }
                return Object.class;
            }
        };
    }

    private static String cleanHeaderText(String text) {
        return text.replaceAll("\\[.*?\\]", "").replaceAll("\\s+", " ").trim();
    }

    private static Object parseValue(String text) {
        if (text == null) {
            return null;
        }
        String cleaned = text.replace("\u00a0", " ").replaceAll("\\[.*?\\]", "").replaceAll(",", "").replaceAll("\u00b1", "").trim();
        if (cleaned.endsWith("%")) {
            try {
                return Double.parseDouble(cleaned.replace("%", "").replace("+", ""));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            if (cleaned.matches("[-+]?\\d+")) {
                return Integer.parseInt(cleaned);
            }
            if (cleaned.matches("[-+]?\\d*\\.\\d+")) {
                return Double.parseDouble(cleaned);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return cleaned;
    }
}

