/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.table.ODFTableTableModel;
import com.macrofocus.data.table.SimpleTableModel;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.util.file.FileHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.apache.poi.ss.usermodel.Sheet;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;

public class ODFSpreadsheetDataSource
extends FileURLDataSource {
    static final String type = "ODFSpreadsheet";
    private String sheetName;

    public ODFSpreadsheetDataSource(File file) {
        this(file, null);
    }

    public ODFSpreadsheetDataSource(URL url) {
        this(url, null);
    }

    public ODFSpreadsheetDataSource(File file, String sheetName) {
        super(file);
        this.sheetName = sheetName;
    }

    public ODFSpreadsheetDataSource(URL url, String sheetName) {
        super(url);
        this.sheetName = sheetName;
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public Element save(File file, ElementFactory factory) {
        Element dataSource = factory.newElement("DataSource");
        dataSource.addAttribute(factory.newAttribute("type", this.getType()));
        if (this.file != null) {
            dataSource.addAttribute(factory.newAttribute("path", this.file.getPath()));
            dataSource.addAttribute(factory.newAttribute("absolutePath", this.file.getAbsolutePath()));
            try {
                dataSource.addAttribute(factory.newAttribute("relativePath", FileHelper.getRelativePath(this.file.getAbsolutePath(), file.getAbsolutePath(), File.separator)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            dataSource.addAttribute(factory.newAttribute("url", this.url.toExternalForm()));
        }
        if (this.sheetName != null) {
            dataSource.addAttribute(factory.newAttribute("sheet", this.sheetName));
        }
        return dataSource;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        try (BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));){
            SimpleTableModel simpleTableModel;
            OdfTable sheet;
            OdfSpreadsheetDocument wb = OdfSpreadsheetDocument.loadDocument((InputStream)bis);
            if (this.sheetName != null && wb.getTableByName(this.sheetName) != null) {
                sheet = wb.getTableByName(this.sheetName);
            } else {
                ArrayList<OdfTable> sheets = new ArrayList<OdfTable>();
                OdfTable selected = null;
                for (OdfTable s : wb.getTableList()) {
                    if (s.getRowCount() <= 0) continue;
                    if (selected == null) {
                        selected = s;
                    }
                    sheets.add(s);
                }
                if (sheets.isEmpty()) {
                    Iterator iterator = null;
                    return iterator;
                }
                if (sheets.size() == 1 || contentPane == null) {
                    sheet = selected != null ? selected : (OdfTable)sheets.get(0);
                } else {
                    Frame frame = JOptionPane.getFrameForComponent(contentPane);
                    SheetSelector selector = new SheetSelector(frame, contentPane, "Select which worksheet to load:", "Choose worksheet", sheets.toArray(), selected);
                    selector.setVisible(true);
                    sheet = selector.getValue();
                    if (sheet != null) {
                        this.sheetName = sheet.getTableName();
                    }
                }
            }
            if (sheet != null) {
                simpleTableModel = new SimpleTableModel(new ODFTableTableModel(sheet));
                return simpleTableModel;
            }
            simpleTableModel = null;
            return simpleTableModel;
        }
    }

    private class SheetSelector
    extends JDialog {
        private JList list;
        private final WeakActionListeners actionListeners;

        private SheetSelector(Frame frame, Component locationComp, String labelText, String title, Object[] data, OdfTable initialValue) {
            super(frame, title, true);
            this.actionListeners = new WeakActionListeners();
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(this.actionListeners.create(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SheetSelector.this.list.clearSelection();
                    SheetSelector.this.setVisible(false);
                }
            }, (Object)cancelButton));
            final JButton okButton = new JButton("Ok");
            okButton.setActionCommand("Ok");
            okButton.addActionListener(this.actionListeners.create(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SheetSelector.this.setVisible(false);
                }
            }, (Object)okButton));
            this.getRootPane().setDefaultButton(cancelButton);
            this.list = new JList(data){

                @Override
                public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                    int row;
                    if (orientation == 1 && direction < 0 && (row = this.getFirstVisibleIndex()) != -1) {
                        Rectangle r = this.getCellBounds(row, row);
                        if (r.y == visibleRect.y && row != 0) {
                            Point loc = r.getLocation();
                            --loc.y;
                            int prevIndex = this.locationToIndex(loc);
                            Rectangle prevR = this.getCellBounds(prevIndex, prevIndex);
                            if (prevR == null || prevR.y >= r.y) {
                                return 0;
                            }
                            return prevR.height;
                        }
                    }
                    return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
                }
            };
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    return super.getListCellRendererComponent((JList<?>)list, ((Sheet)value).getSheetName(), index, isSelected, cellHasFocus);
                }
            });
            this.list.setSelectionMode(0);
            this.list.setVisibleRowCount(-1);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        okButton.doClick();
                    }
                }
            });
            JScrollPane listScroller = new JScrollPane(this.list);
            listScroller.setPreferredSize(new Dimension(250, 80));
            listScroller.setAlignmentX(0.0f);
            JPanel listPane = new JPanel();
            listPane.setLayout(new BoxLayout(listPane, 3));
            JLabel label = new JLabel(labelText);
            label.setLabelFor(this.list);
            listPane.add(label);
            listPane.add(Box.createRigidArea(new Dimension(0, 5)));
            listPane.add(listScroller);
            listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new BoxLayout(buttonPane, 2));
            buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            buttonPane.add(Box.createHorizontalGlue());
            buttonPane.add(cancelButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(okButton);
            Container contentPane = this.getContentPane();
            contentPane.add((Component)listPane, "Center");
            contentPane.add((Component)buttonPane, "Last");
            this.setValue(initialValue);
            this.pack();
            this.setLocationRelativeTo(locationComp);
        }

        private void setValue(OdfTable newValue) {
            this.list.setSelectedValue(newValue, true);
        }

        public OdfTable getValue() {
            return (OdfTable)this.list.getSelectedValue();
        }
    }
}

