/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONTableModel
extends AbstractTableModel {
    private String[] labels;
    private Class[] classes;
    private JSONArray array;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Object str = sb.toString();
        str = ((String)str).trim();
        if (((String)str).startsWith("[") && ((String)str).endsWith("]")) {
            str = "{ \"data\": " + (String)str + "}";
        }
        return str;
    }

    public JSONTableModel(InputStream is) throws IOException {
        String str = JSONTableModel.convertStreamToString(is);
        try {
            Object o;
            JSONObject root = new JSONObject(str);
            this.array = root.getJSONArray("data");
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < this.array.length(); ++i) {
                o = this.array.getJSONObject(i);
                for (String key : JSONObject.getNames((JSONObject)o)) {
                    keys.add(key);
                }
            }
            this.labels = new String[keys.size()];
            int index = 0;
            o = keys.iterator();
            while (o.hasNext()) {
                String key;
                this.labels[index] = key = (String)o.next();
                ++index;
            }
            this.classes = new Class[keys.size()];
            for (int i = 0; i < this.classes.length; ++i) {
                this.classes[i] = Object.class;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.labels[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.classes[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.array.length();
    }

    @Override
    public int getColumnCount() {
        return this.labels.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            JSONObject jsonObject = this.array.getJSONObject(rowIndex);
            if (jsonObject.has(this.labels[columnIndex])) {
                Object value = jsonObject.get(this.labels[columnIndex]);
                if (value == JSONObject.NULL) {
                    return null;
                }
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    Object[] a = new Object[array.length()];
                    for (int i = 0; i < array.length(); ++i) {
                        a[i] = array.get(i);
                    }
                    return a;
                }
                return value;
            }
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

