/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.series;

import com.macrofocus.data.type.series.NumericalSeries;
import com.macrofocus.data.type.series.SimpleSeries;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;

public class DoubleSeries
extends SimpleSeries<Double>
implements NumericalSeries<Double>,
Externalizable {
    private static final long serialVersionUID = 451381591833689419L;
    private Double minValue;
    private Double maxValue;

    public DoubleSeries() {
        super(Double.class);
    }

    public DoubleSeries(String values) {
        super(Double.class);
        StrTokenizer tokenizer = new StrTokenizer(values, StrMatcher.charMatcher((char)';'));
        while (tokenizer.hasNext()) {
            String token = tokenizer.nextToken();
            Double v = Double.parseDouble(token);
            this.addValue(v);
        }
    }

    @Override
    public void addValue(Double value) {
        super.addValue(value);
        if (this.minValue == null || value < this.minValue) {
            this.minValue = value;
        }
        if (this.maxValue == null || value > this.maxValue) {
            this.maxValue = value;
        }
    }

    @Override
    public Double getMinValue() {
        return this.minValue;
    }

    @Override
    public Double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeInt(this.getItemCount());
        for (int i = 0; i < this.getItemCount(); ++i) {
            out.writeDouble((Double)this.getValue(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        int itemCount = in.readInt();
        for (int i = 0; i < itemCount; ++i) {
            this.addValue(in.readDouble());
        }
    }
}

