/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.type.timeseries.Event;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractEvent
implements Event {
    private final List<Event.Listener> listeners;
    private Long time;

    protected AbstractEvent(Long time) {
        this.time = time;
        this.listeners = new ArrayList<Event.Listener>();
    }

    @Override
    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
        this.notifyEventChanged();
    }

    @Override
    public void addEventListener(Event.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(Event.Listener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyEventChanged() {
        for (Event.Listener listener : this.listeners) {
            listener.eventChanged();
        }
    }
}

