/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.component;
import org.web3d.x3d.jsail.Core.meta;
import org.web3d.x3d.jsail.Core.unit;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class head
extends X3DConcreteStatement {
    private ArrayList<String> commentsList;
    private ArrayList<component> componentList = new ArrayList();
    private ArrayList<meta> metaList = new ArrayList();
    private ArrayList<unit> unitList = new ArrayList();
    public static final String NAME = "head";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 1;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "component": {
                result = "MFNode";
                break;
            }
            case "meta": {
                result = "MFNode";
                break;
            }
            case "unit": {
                result = "MFNode";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "component": {
                result = "inputOutput";
                break;
            }
            case "meta": {
                result = "inputOutput";
                break;
            }
            case "unit": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    public head() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.componentList = new ArrayList();
        this.metaList = new ArrayList();
        this.unitList = new ArrayList();
        this.commentsList = new ArrayList();
    }

    public ArrayList<component> getComponentList() {
        return this.componentList;
    }

    public head setComponentList(ArrayList<component> newValue) {
        this.componentList = newValue;
        for (component arrayElement : this.componentList) {
            arrayElement.setParent(this);
        }
        return this;
    }

    public head addComponent(component newValue) {
        if (newValue == null) {
            this.clearComponent();
            return this;
        }
        this.componentList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head setComponent(component newValue) {
        if (newValue == null) {
            this.clearComponent();
            return this;
        }
        for (component element : this.componentList) {
            element.clearParent();
        }
        this.clearComponent();
        this.componentList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head clearComponent() {
        for (component element : this.componentList) {
            element.clearParent();
        }
        this.componentList.clear();
        return this;
    }

    public boolean hasComponent() {
        return !this.componentList.isEmpty();
    }

    public ArrayList<meta> getMetaList() {
        return this.metaList;
    }

    public head setMetaList(ArrayList<meta> newValue) {
        this.metaList = newValue;
        for (meta arrayElement : this.metaList) {
            arrayElement.setParent(this);
        }
        return this;
    }

    public head addMeta(meta newValue) {
        if (newValue == null) {
            this.clearMeta();
            return this;
        }
        this.metaList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head setMeta(meta newValue) {
        if (newValue == null) {
            this.clearMeta();
            return this;
        }
        for (meta element : this.metaList) {
            element.clearParent();
        }
        this.clearMeta();
        this.metaList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head clearMeta() {
        for (meta element : this.metaList) {
            element.clearParent();
        }
        this.metaList.clear();
        return this;
    }

    public boolean hasMeta() {
        return !this.metaList.isEmpty();
    }

    public ArrayList<unit> getUnitList() {
        return this.unitList;
    }

    public head setUnitList(ArrayList<unit> newValue) {
        this.unitList = newValue;
        for (unit arrayElement : this.unitList) {
            arrayElement.setParent(this);
        }
        return this;
    }

    public head addUnit(unit newValue) {
        if (newValue == null) {
            this.clearUnit();
            return this;
        }
        this.unitList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head setUnit(unit newValue) {
        if (newValue == null) {
            this.clearUnit();
            return this;
        }
        for (unit element : this.unitList) {
            element.clearParent();
        }
        this.clearUnit();
        this.unitList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head clearUnit() {
        for (unit element : this.unitList) {
            element.clearParent();
        }
        this.unitList.clear();
        return this;
    }

    public boolean hasUnit() {
        return !this.unitList.isEmpty();
    }

    public head addComponent(String componentName, int level) {
        return this.addComponent(new component(componentName, level));
    }

    public head addUnit(String newName, String newCategory, float newConversionFactor) {
        return this.addUnit(new unit(newName, newCategory, newConversionFactor));
    }

    public head addUnit(String newName, String newCategory, double newConversionFactor) {
        return this.addUnit(new unit(newName, newCategory, newConversionFactor));
    }

    public head addMeta(String newName, String newDescription) {
        return this.addMeta(new meta(newName, newDescription));
    }

    @Override
    public head addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public head addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public head addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.componentList.isEmpty() || !this.metaList.isEmpty() || !this.unitList.isEmpty() || !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<head");
        if (hasAttributes) {
            // empty if block
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            for (component component2 : this.componentList) {
                stringX3D.append(((X3DConcreteElement)component2).toStringX3D(indentLevel + indentIncrement));
            }
            for (unit unit2 : this.unitList) {
                stringX3D.append(((X3DConcreteElement)unit2).toStringX3D(indentLevel + indentIncrement));
            }
            for (meta meta2 : this.metaList) {
                stringX3D.append(meta2.toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</head>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean hasChild = !this.componentList.isEmpty() || !this.metaList.isEmpty() || !this.unitList.isEmpty() || !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("# head").append("\n");
        if (hasAttributes) {
            // empty if block
        }
        if (hasChild) {
            for (component component2 : this.componentList) {
                stringClassicVRML.append(((X3DConcreteElement)component2).toStringClassicVRML(indentLevel));
            }
            for (unit unit2 : this.unitList) {
                stringClassicVRML.append(((X3DConcreteElement)unit2).toStringClassicVRML(indentLevel));
            }
            for (meta meta2 : this.metaList) {
                stringClassicVRML.append(meta2.toStringClassicVRML(indentLevel));
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
            }
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        int j;
        this.validationResult = new StringBuilder();
        for (component component2 : this.componentList) {
            ((X3DConcreteElement)component2).validate();
            this.validationResult.append(component2.getValidationResult());
        }
        this.setComponentList(this.getComponentList());
        if (!this.hasMeta()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D head has no meta elements and thus is undescribed\n");
        }
        for (meta meta2 : this.metaList) {
            ((X3DConcreteElement)meta2).validate();
            this.validationResult.append(meta2.getValidationResult());
        }
        this.setMetaList(this.getMetaList());
        if (!this.hasMeta()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D head has no meta elements and thus is undescribed\n");
        }
        for (unit unit2 : this.unitList) {
            ((X3DConcreteElement)unit2).validate();
            this.validationResult.append(unit2.getValidationResult());
        }
        this.setUnitList(this.getUnitList());
        if (!this.hasMeta()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D head has no meta elements and thus is undescribed\n");
        }
        int index = 0;
        for (component componentStatement : this.componentList) {
            for (j = 0; j < index; ++j) {
                if (!componentStatement.getName().equalsIgnoreCase(this.componentList.get(j).getName())) continue;
                this.validationResult.append("Redundant statements found, same category:\n  ").append(componentStatement.toStringX3D()).append(" and\n  ").append(this.componentList.get(j).toStringX3D());
            }
            ++index;
        }
        index = 0;
        for (unit unitStatement : this.unitList) {
            for (j = 0; j < index; ++j) {
                if (!unitStatement.getCategory().equalsIgnoreCase(this.unitList.get(j).getCategory())) continue;
                this.validationResult.append("Redundant statements found: ").append(unitStatement.toStringX3D()).append(" and ").append(this.unitList.get(j).toStringX3D());
            }
            ++index;
        }
        index = -1;
        for (meta metaStatement : this.metaList) {
            for (j = 0; j < index; ++j) {
                if (metaStatement.getName().equalsIgnoreCase(this.metaList.get(j).getName()) && metaStatement.getContent().equalsIgnoreCase(this.metaList.get(j).getContent())) {
                    this.validationResult.append("WARNING_MESSAGE").append(": duplicate statement found: <meta name='").append(metaStatement.getName()).append("' content='").append(metaStatement.getContent()).append("'/>\n");
                    continue;
                }
                if (!metaStatement.getName().equalsIgnoreCase(this.metaList.get(j).getName()) || !metaStatement.getName().equalsIgnoreCase("description") && !metaStatement.getName().equalsIgnoreCase("created") && !metaStatement.getName().equalsIgnoreCase("modified") && !metaStatement.getName().equalsIgnoreCase("identifier") && !metaStatement.getName().equalsIgnoreCase("title") && !metaStatement.getName().equalsIgnoreCase("subject")) continue;
                this.validationResult.append("Duplicate found: <meta name='").append(metaStatement.getName()).append("'/>\n");
            }
            ++index;
        }
        return this.validationResult.toString();
    }

    public meta findMetaByName(String metaName) {
        for (meta element : this.metaList) {
            if (!element.getName().equalsIgnoreCase(metaName)) continue;
            return element;
        }
        return null;
    }

    public boolean hasMeta(String metaName) {
        return this.findMetaByName(metaName) != null;
    }

    public component findComponentByName(String componentName) {
        for (component element : this.componentList) {
            if (!element.getName().equalsIgnoreCase(componentName)) continue;
            return element;
        }
        return null;
    }

    public boolean hasComponent(String componentName) {
        return this.findComponentByName(componentName) != null;
    }

    public unit findUnitByName(String unitName) {
        for (unit element : this.unitList) {
            if (!element.getName().equalsIgnoreCase(unitName)) continue;
            return element;
        }
        return null;
    }

    public boolean hasUnit(String unitName) {
        return this.findUnitByName(unitName) != null;
    }
}

