/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.AbstractCalendarAndExceptionFactory;
import net.sf.mpxj.mpp.VarMeta;
import net.sf.mpxj.mpp.VarMeta12;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

class MPP14CalendarFactory
extends AbstractCalendarAndExceptionFactory {
    private static final Integer CALENDAR_NAME = 1;
    private static final Integer CALENDAR_DATA = 8;
    private final int m_calendarIDOffset;
    private final int m_baseIDOffset;
    private final int m_resourceIDOffset;

    public MPP14CalendarFactory(ProjectFile file) {
        super(file);
        if (NumberHelper.getInt(file.getProjectProperties().getApplicationVersion()) > 14) {
            this.m_calendarIDOffset = 8;
            this.m_baseIDOffset = 0;
            this.m_resourceIDOffset = 4;
        } else {
            this.m_calendarIDOffset = 0;
            this.m_baseIDOffset = 4;
            this.m_resourceIDOffset = 8;
        }
    }

    @Override
    protected int getCalendarIDOffset() {
        return this.m_calendarIDOffset;
    }

    @Override
    protected int getBaseIDOffset() {
        return this.m_baseIDOffset;
    }

    @Override
    protected int getResourceIDOffset() {
        return this.m_resourceIDOffset;
    }

    @Override
    protected int getCalendarHoursOffset() {
        return 0;
    }

    @Override
    protected Integer getCalendarNameVarDataType() {
        return CALENDAR_NAME;
    }

    @Override
    protected Integer getCalendarDataVarDataType() {
        return CALENDAR_DATA;
    }

    @Override
    protected VarMeta getCalendarVarMeta(DirectoryEntry directory) throws IOException {
        return new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)directory.getEntry("VarMeta")));
    }
}

