/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public final class DatatypeConverter {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            df.setLenient(false);
            return df;
        }
    };
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            df.setLenient(false);
            return df;
        }
    };
    private static final ThreadLocal<NumberFormat> DOUBLE_FORMAT = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            DecimalFormat format = new DecimalFormat("#.##");
            format.setGroupingUsed(false);
            return format;
        }
    };

    public static final UUID parseUUID(String value) {
        UUID result = null;
        if (value != null && !value.isEmpty()) {
            if (value.charAt(0) == '{') {
                result = UUID.fromString(value.substring(1, value.length() - 1));
            } else if (value.length() == 22) {
                int i;
                byte[] data = javax.xml.bind.DatatypeConverter.parseBase64Binary((String)(value + "=="));
                long msb = 0L;
                long lsb = 0L;
                for (i = 0; i < 8; ++i) {
                    msb = msb << 8 | (long)(data[i] & 0xFF);
                }
                for (i = 8; i < 16; ++i) {
                    lsb = lsb << 8 | (long)(data[i] & 0xFF);
                }
                result = new UUID(msb, lsb);
            } else {
                result = UUID.nameUUIDFromBytes(value.getBytes());
            }
        }
        return result;
    }

    public static String printUUID(UUID guid) {
        return guid == null ? null : "{" + guid.toString().toUpperCase() + "}";
    }

    public static final String printDateTime(Date value) {
        return value == null ? null : DATE_FORMAT.get().format(value);
    }

    public static final Date parseDateTime(String value) {
        Date result = null;
        if (value != null && value.length() != 0) {
            try {
                result = DATE_FORMAT.get().parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printTime(Date value) {
        return value == null ? null : TIME_FORMAT.get().format(value);
    }

    public static final Date parseTime(String value) {
        Date result = null;
        if (value != null && value.length() != 0) {
            try {
                result = TIME_FORMAT.get().parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final Boolean parseIntegerBoolean(String value) {
        Boolean result = value == null ? null : Boolean.valueOf(value.equals("1"));
        return result;
    }

    public static final String printIntegerBoolean(Boolean value) {
        String result = value == null ? null : (value != false ? "1" : "0");
        return result;
    }

    public static final Double parseDouble(String value) {
        Double result = value == null ? null : Double.valueOf(javax.xml.bind.DatatypeConverter.parseDouble((String)value));
        return result;
    }

    public static final String printDouble(Double value) {
        String result = value == null ? null : DOUBLE_FORMAT.get().format(value);
        return result;
    }
}

