/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.resources;

import com.macrofocus.resources.AbstractResourcesModel;
import com.macrofocus.resources.ResourcesEvent;
import com.macrofocus.resources.ResourcesListener;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.resources.properties.WeakPropertiesModel;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Locale;

public class WeakResourcesModel
extends AbstractResourcesModel {
    private WeakReference<ResourcesModel> delegate;
    private WeakPropertiesModel propertiesModel = null;
    private final ResourcesListener resourcesListener = new ResourcesListener(){

        @Override
        public void resourcesLocaleChanged(ResourcesEvent event) {
            WeakResourcesModel.this.notifyResourcesLocaleChanged(new ResourcesEvent(event.getSource(), WeakResourcesModel.this));
        }
    };

    public WeakResourcesModel(ResourcesModel delegate) {
        this.delegate = new WeakReference<ResourcesModel>(delegate);
        delegate.addWeakResourcesListener(this.resourcesListener);
    }

    @Override
    public URL getUrl(Class context, String filename) {
        return ((ResourcesModel)this.delegate.get()).getUrl(context, filename);
    }

    @Override
    public URL getLocalizedUrl(String name, String extension) {
        return ((ResourcesModel)this.delegate.get()).getLocalizedUrl(name, extension);
    }

    @Override
    public URL getUrl(String filename) {
        return ((ResourcesModel)this.delegate.get()).getUrl(filename);
    }

    @Override
    public PropertiesModel getPropertiesModel() {
        if (this.propertiesModel == null) {
            this.propertiesModel = new WeakPropertiesModel(((ResourcesModel)this.delegate.get()).getPropertiesModel());
        }
        return this.propertiesModel;
    }

    @Override
    public void setLocale(Locale locale) {
        ((ResourcesModel)this.delegate.get()).setLocale(locale);
    }

    @Override
    public Locale getLocale() {
        return ((ResourcesModel)this.delegate.get()).getLocale();
    }

    @Override
    public void reload() {
        ((ResourcesModel)this.delegate.get()).reload();
    }

    @Override
    public void retrievePreferences() {
        ((ResourcesModel)this.delegate.get()).retrievePreferences();
    }

    @Override
    public void savePreferences() {
        ((ResourcesModel)this.delegate.get()).savePreferences();
    }

    @Override
    public void resetPreferences() {
        ((ResourcesModel)this.delegate.get()).resetPreferences();
    }

    public String toString() {
        return "WeakResourcesModel{delegate=" + String.valueOf(this.delegate.get()) + "}";
    }
}

