/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import org.geotools.data.AttributeWriter;
import org.opengis.feature.type.AttributeDescriptor;

public class JoiningAttributeWriter
implements AttributeWriter {
    private AttributeWriter[] writers;
    private int[] index;
    private AttributeDescriptor[] metaData;

    public JoiningAttributeWriter(AttributeWriter ... writers) {
        this.writers = writers;
        this.metaData = this.joinMetaData(writers);
    }

    private AttributeDescriptor[] joinMetaData(AttributeWriter ... writers) {
        int total = 0;
        this.index = new int[writers.length];
        int ii = writers.length;
        for (int i = 0; i < ii; ++i) {
            this.index[i] = total;
            total += writers[i].getAttributeCount();
        }
        AttributeDescriptor[] md = new AttributeDescriptor[total];
        int idx = 0;
        for (AttributeWriter writer : writers) {
            int jj = writer.getAttributeCount();
            for (int j = 0; j < jj; ++j) {
                md[idx] = writer.getAttributeType(j);
                ++idx;
            }
        }
        return md;
    }

    @Override
    public void close() throws IOException {
        IOException dse = null;
        for (AttributeWriter writer : this.writers) {
            try {
                writer.close();
            }
            catch (IOException e) {
                dse = e;
            }
        }
        if (dse != null) {
            throw dse;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        for (AttributeWriter writer : this.writers) {
            if (!writer.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void next() throws IOException {
        for (AttributeWriter writer : this.writers) {
            writer.next();
        }
    }

    @Override
    public void write(int position, Object attribute) throws IOException {
        AttributeWriter writer = null;
        for (int i = this.index.length - 1; i >= 0; --i) {
            if (position < this.index[i]) continue;
            position -= this.index[i];
            writer = this.writers[i];
            break;
        }
        if (writer == null) {
            throw new ArrayIndexOutOfBoundsException(position);
        }
        writer.write(position, attribute);
    }

    @Override
    public int getAttributeCount() {
        return this.metaData.length;
    }

    @Override
    public AttributeDescriptor getAttributeType(int i) {
        return this.metaData[i];
    }
}

