/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi;

import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.AbstractLabeling;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapWorker;
import com.treemap.swing.fastvoronoi.SimpleVoronoiDiagram;
import com.treemap.swing.fastvoronoi.Site;
import com.treemap.swing.fastvoronoi.VoronoiDiagram;
import com.treemap.swing.fastvoronoi.polygon.Point2D;
import com.treemap.swing.fastvoronoi.polygon.PolygonSimple;
import java.awt.geom.Line2D;
import java.util.Random;

public class FastVoronoiAlgorithm
extends AbstractAlgorithm {
    private static int maximalIterationNumber = 2000;
    private static double errorThreshold = 0.05;
    private static double smallestWeight = 1.0E-8;

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        if (children.length > 1) {
            try {
                VoronoiDiagram voronoiTreemap = this.computeVoronoiTreemap(shape, children, sumSizes);
                for (int i = 0; i < children.length; ++i) {
                    MutableTreeMapNode child = children[i];
                    child.setShape(voronoiTreemap.getClippedPolygon(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                for (int i = 0; i < children.length; ++i) {
                    MutableTreeMapNode child = children[i];
                    child.setShape(null);
                }
            }
        } else {
            children[0].setShape(shape);
        }
        return false;
    }

    public boolean isCompatible(Shape shape) {
        return true;
    }

    private VoronoiDiagram computeVoronoiTreemap(Shape shape, MutableTreeMapNode[] children, double sumSizes) {
        double totalArea = AbstractLabeling.getArea((Shape)shape);
        assert (!Double.isNaN(totalArea));
        assert (!Double.isInfinite(totalArea));
        Site[] sites = this.initSites(shape, children);
        double[] weights = this.initWeights(sumSizes, children);
        double error = Double.POSITIVE_INFINITY;
        VoronoiDiagram voronoiDiagram = this.computePowerDiagram(shape, sites, weights);
        for (int i = 1; i <= maximalIterationNumber; ++i) {
            this.adaptPositionsWeights(children, voronoiDiagram, sites, weights);
            voronoiDiagram = this.computePowerDiagram(shape, sites, weights);
            this.adaptWeights(totalArea, children, sumSizes, voronoiDiagram, sites, weights);
            voronoiDiagram = this.computePowerDiagram(shape, sites, weights);
            error = this.computeError(totalArea, children, sumSizes, voronoiDiagram, sites, weights);
            if (!(error < errorThreshold)) continue;
            return voronoiDiagram;
        }
        return voronoiDiagram;
    }

    private Site[] initSites(Shape shape, MutableTreeMapNode[] children) {
        Site[] sites = new Site[children.length];
        Rectangle2D bounds = shape.getBounds2D();
        Random random = new Random(0L);
        for (int i = 0; i < sites.length; ++i) {
            double y;
            double x;
            while (!shape.contains((com.macrofocus.geom.Point2D)new Point2D.Double(x = bounds.getX() + random.nextDouble() * bounds.getWidth(), y = bounds.getY() + random.nextDouble() * bounds.getHeight()))) {
            }
            sites[i] = new Site((com.macrofocus.geom.Point2D)new Point2D.Double(x, y));
        }
        return sites;
    }

    private double[] initWeights(double sumSizes, MutableTreeMapNode[] children) {
        double[] weights = new double[children.length];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = smallestWeight;
        }
        return weights;
    }

    private VoronoiDiagram computePowerDiagram(Shape shape, Site[] sites, double[] weights) {
        return new SimpleVoronoiDiagram(shape, sites, weights);
    }

    private void adaptPositionsWeights(MutableTreeMapNode[] children, VoronoiDiagram voronoiDiagram, Site[] sites, double[] weights) {
        for (int i = 0; i < sites.length; ++i) {
            com.macrofocus.geom.Point2D centroid;
            Shape polygon = voronoiDiagram.getClippedPolygon(i);
            if (polygon == null) continue;
            if (polygon instanceof PolygonSimple) {
                Point2D c = ((PolygonSimple)polygon).getCentroid();
                centroid = new Point2D.Double(c.getX(), c.getY());
            } else {
                centroid = AbstractLabeling.getCentroid((Shape)polygon);
            }
            if (Double.isInfinite(centroid.getX()) || Double.isInfinite(centroid.getY()) || Double.isNaN(centroid.getX()) || Double.isNaN(centroid.getY())) {
                Rectangle2D polygonBounds2D = polygon.getBounds2D();
                sites[i].setPosition((com.macrofocus.geom.Point2D)new Point2D.Double(polygonBounds2D.getCenterX(), polygonBounds2D.getCenterY()));
            } else {
                sites[i].setPosition(centroid);
            }
            double distanceBorder = this.distanceToBorder(centroid, voronoiDiagram.getPolygon(i));
            weights[i] = Math.pow(Math.min(Math.sqrt(weights[i]), distanceBorder), 2.0);
        }
    }

    private void adaptWeights(double totalArea, MutableTreeMapNode[] children, double sumSizes, VoronoiDiagram voronoiDiagram, Site[] sites, double[] weights) {
        Site[] nearestNeighbor = this.nearestNeighbor(voronoiDiagram, sites);
        for (int i = 0; i < sites.length; ++i) {
            Shape polygon = voronoiDiagram.getClippedPolygon(i);
            if (polygon == null || nearestNeighbor[i] == null) continue;
            double currentArea = AbstractLabeling.getArea((Shape)polygon);
            double targetArea = totalArea * children[i].getSize() / sumSizes;
            double adapt = targetArea / currentArea;
            double wnew = Math.sqrt(weights[i]) * adapt;
            assert (sites[i].getPosition() != null);
            assert (nearestNeighbor[i] != null);
            double wmax = sites[i].getPosition().distance(nearestNeighbor[i].getPosition());
            weights[i] = Math.pow(Math.min(wnew, wmax), 2.0);
            weights[i] = Math.max(weights[i], smallestWeight);
        }
    }

    private Site[] nearestNeighbor(VoronoiDiagram voronoiDiagram, Site[] sites) {
        Site[] nearestNeighbor = new Site[sites.length];
        for (int i = 0; i < sites.length; ++i) {
            Site site = sites[i];
            Double minDistance = Double.MAX_VALUE;
            for (int j = 0; j < sites.length; ++j) {
                double distance;
                if (i == j) continue;
                Site site1 = sites[j];
                Shape polygon = voronoiDiagram.getClippedPolygon(j);
                if (polygon == null || !((distance = site.getPosition().distanceSq(site1.getPosition())) < minDistance)) continue;
                nearestNeighbor[i] = site1;
                minDistance = distance;
            }
        }
        return nearestNeighbor;
    }

    private double computeError(double totalArea, MutableTreeMapNode[] children, double sumSizes, VoronoiDiagram voronoiDiagram, Site[] sites, double[] weights) {
        double error = 0.0;
        for (int i = 0; i < sites.length; ++i) {
            Site site = sites[i];
            Shape polygon = voronoiDiagram.getClippedPolygon(i);
            if (polygon == null) continue;
            double currentArea = AbstractLabeling.getArea((Shape)polygon);
            double targetArea = totalArea * children[i].getSize() / sumSizes;
            error += Math.abs(currentArea - targetArea);
        }
        return error / (2.0 * totalArea);
    }

    private double distanceToBorder(com.macrofocus.geom.Point2D point, Shape shape) {
        PathIterator pi = shape.getPathIterator(null);
        double[] data = new double[6];
        int previousX = 0;
        int previousY = 0;
        double minDistance = Double.MAX_VALUE;
        while (!pi.isDone()) {
            int segType = pi.currentSegment(data);
            switch (segType) {
                case 0: {
                    previousX = (int)data[0];
                    previousY = (int)data[1];
                    break;
                }
                case 1: {
                    int currentX = (int)data[0];
                    int currentY = (int)data[1];
                    double distance = Line2D.ptSegDist(previousX, previousY, currentX, currentY, point.getX(), point.getY());
                    if (distance < minDistance) {
                        minDistance = distance;
                    }
                    previousX = currentX;
                    previousY = currentY;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new Error("Segmented type unsupported");
                }
            }
            pi.next();
        }
        return minDistance;
    }

    public String toString() {
        return "Fast Voronoi";
    }
}

