/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.debug;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Polygon;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.MutableTreeMapNode;
import com.treemap.swing.crossplatform.ShapeShape;
import com.treemap.swing.voronoi.Point2d;
import com.treemap.swing.voronoi.VoronoiCell;
import com.treemap.swing.voronoi.VoronoiOutputRaster;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Debugger {
    private static Debugger instance;
    private int estimatedPixelXells;
    private int actualPixelCells;
    private double totalAlgorithmDuration;
    private List<DataEntry> dataEntries = new ArrayList<DataEntry>();
    private int zeroAreaCellsCount = 0;
    private List<Double> errors = new ArrayList<Double>();
    private VoronoiCell maxErrorCell;
    private MutableTreeMapNode interrestingChild;
    private final String nameMapSuffix = ".namemap";
    private final String rasterSuffix = ".bmp";
    private final String domainBoundsKeyWord = "DomainBounds";
    private final int nullZellId = 0;
    private final int outsideCellId = 1;
    private double maxError = 0.0;
    private double rms = 0.0;
    private static int windowCounter;
    private static final Dimension cellRasterSize;

    private Debugger() {
    }

    public static Debugger instance() {
        if (instance == null) {
            instance = new Debugger();
        }
        return instance;
    }

    public void setEstimatedPixelXells(int estimatedPixelXells) {
        this.estimatedPixelXells = estimatedPixelXells;
    }

    public void setActualPixelCells(int actualPixelCells) {
        this.actualPixelCells = actualPixelCells;
    }

    public void print() {
        System.out.println(this);
        System.out.printf("Total Time: %.1f%n", this.totalAlgorithmDuration);
        for (DataEntry dataEntry : this.dataEntries) {
            double actualRemainingTime = this.totalAlgorithmDuration - dataEntry.duration;
            double estRemainingTime = dataEntry.remainingTimeEstimation;
            System.out.printf("Time Elapsed: %3.1f/%3.1f, Est. Progress: %2.1f, Remaining: Est. %3.1f, Actual. %3.1f, Deviation: Abs. %2.1f, Rel. %.1f%% , nCells = %d, nPixels = %d, nPixelCells = %d, layout duration %.1f, %s %n", dataEntry.duration, this.totalAlgorithmDuration, dataEntry.estimatedProgress * 100.0, estRemainingTime, actualRemainingTime, estRemainingTime - actualRemainingTime, 100.0 * actualRemainingTime / estRemainingTime - 100.0, dataEntry.getnCells(), dataEntry.getnPixels(), dataEntry.getPixelCells(), dataEntry.getLayoutDuration(), dataEntry.name);
        }
    }

    public String toString() {
        return String.format("Estimated PixelCells=%d, Actual PixelCells=%d, Deviation %.1f%% }", this.estimatedPixelXells, this.actualPixelCells, 100.0 * (double)this.estimatedPixelXells / (double)this.actualPixelCells - 100.0);
    }

    public void add(DataEntry dataEntry, boolean printInfos) {
        this.dataEntries.add(dataEntry);
        if (printInfos) {
            System.out.printf("%s: Time Elapsed: %3.1f, Est. Progress: %2.1f%%, Remaining: Est. %.1f %n", dataEntry.name, dataEntry.duration, dataEntry.estimatedProgress * 100.0, dataEntry.remainingTimeEstimation);
        }
    }

    public void setTotalAlgorithmDuration(double totalAlgorithmDuration) {
        this.totalAlgorithmDuration = totalAlgorithmDuration;
    }

    public void exportTimeDataToCsv(String path) {
        try {
            String sep = "\t";
            String suffix = ".csv";
            if (!((String)path).endsWith(".csv")) {
                path = (String)path + ".csv";
            }
            PrintWriter writer = new PrintWriter(new File((String)path + ".csv"));
            String str = "Time Elapsed: , Total, Est. Progress, Remaining: Est., Actual., Deviation: Abs. , Rel. %% , nCells, nPixels, nPixelCells, Layout Duration %n";
            str.replace(",", "\t");
            writer.printf(str, new Object[0]);
            for (DataEntry dataEntry : this.dataEntries) {
                double actualRemainingTime = this.totalAlgorithmDuration - dataEntry.duration;
                double estRemainingTime = dataEntry.remainingTimeEstimation;
                str = "%e,%e,%e,%e,%e,%e,%e,%d,%d,%d,%e%n";
                str.replace(",", "\t");
                writer.printf(str, dataEntry.duration, this.totalAlgorithmDuration, dataEntry.estimatedProgress * 100.0, estRemainingTime, actualRemainingTime, estRemainingTime - actualRemainingTime, 100.0 * actualRemainingTime / estRemainingTime - 100.0, dataEntry.getnCells(), dataEntry.getnPixels(), dataEntry.getPixelCells(), dataEntry.getLayoutDuration());
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setZeroAreaCellsCount(int zeroAreaCellsCount) {
        this.zeroAreaCellsCount = zeroAreaCellsCount;
    }

    public void incZeroAreaCellsCount() {
        ++this.zeroAreaCellsCount;
    }

    public int getZeroAreaCellsCount() {
        return this.zeroAreaCellsCount;
    }

    public void addError(double errorAbsolute) {
        this.errors.add(errorAbsolute);
    }

    public void printErrors() {
        this.calculateRmsAndMaxError();
        System.out.printf("RMS error %.1f%%, max %.1f%% with %d values", this.rms * 100.0, this.maxError * 100.0, this.errors.size());
    }

    public double getRms() {
        this.calculateRmsAndMaxError();
        return this.rms;
    }

    private void calculateRmsAndMaxError() {
        double sumSq = 0.0;
        this.maxError = 0.0;
        for (Double error : this.errors) {
            this.maxError = Math.max(error, this.maxError);
            sumSq += error * error;
        }
        this.rms = Math.sqrt(sumSq / (double)this.errors.size());
    }

    public void clearErrorValues() {
        this.errors.clear();
    }

    public double getMaxError() {
        this.calculateRmsAndMaxError();
        return this.maxError;
    }

    public void setMaxErrorCell(VoronoiCell maxErrorCell) {
        this.maxErrorCell = maxErrorCell;
    }

    public VoronoiCell getMaxErrorCell() {
        return this.maxErrorCell;
    }

    public static void showCellOutlines(final List<Vertex> vertexes, final VoronoiCell[] cells, MutableTreeMapNode parent, final boolean drawCellNames, final String fillName) {
        int cornerCircleSize = 7;
        JPanel content = new JPanel(new BorderLayout());
        final JLabel statusBar = new JLabel();
        JPanel drawPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D g = (Graphics2D)graphics;
                g.translate(7, 7);
                for (VoronoiCell cell : cells) {
                    Rectangle2D bounds = null;
                    Shape shape = cell.getChild().getShape();
                    Polygon polygon = cell.getPolygon();
                    if (polygon != null) {
                        bounds = polygon.getBounds2D();
                        g.setColor(Color.black);
                        g.draw(new ShapeShape((Shape)polygon));
                    }
                    if (shape != null) {
                        bounds = shape.getBounds2D();
                        try {
                            if (fillName != null && cell.getChild().toString().startsWith(fillName)) {
                                g.setColor(Color.green);
                                g.fill(new ShapeShape(shape));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        g.setColor(Color.blue);
                        g.draw(new ShapeShape(shape));
                    }
                    if (!drawCellNames || bounds == null) continue;
                    String cellName = cell.getChild().toString();
                    String displayName = cellName != null ? cellName : "No Name";
                    g.drawString(displayName, (float)bounds.getCenterX(), (float)bounds.getCenterY());
                }
                if (vertexes != null) {
                    for (Vertex corner : vertexes) {
                        if (corner.isTouchingParentSpline()) {
                            g.setColor(Color.green);
                        } else {
                            g.setColor(Color.red);
                        }
                        Point2d location = corner.getLocation();
                        Shape circle = Debugger.getCircle(location, 7);
                        g.draw(new ShapeShape(circle));
                        g.drawLine((int)location.x - 3, (int)location.y, (int)location.x + 3, (int)location.y);
                        g.drawLine((int)location.x, (int)location.y - 3, (int)location.x, (int)location.y + 3);
                    }
                }
            }
        };
        final Point locationOnDiagrqam = new Point();
        drawPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                locationOnDiagrqam.setLocation(e.getPoint());
                locationOnDiagrqam.translate(-7, -7);
                StringBuilder text = new StringBuilder(locationOnDiagrqam.toString());
                for (VoronoiCell cell : cells) {
                    Polygon shape = cell.getPolygon();
                    if (shape == null || !shape.getBounds2D().contains((double)e.getPoint().x, (double)e.getPoint().y) || !shape.contains((Point2D)new Point2D.Double((double)e.getPoint().x, (double)e.getPoint().y))) continue;
                    text.append(' ');
                    text.append(cell.getChild().toString());
                    break;
                }
                if (vertexes != null) {
                    for (Vertex vertex : vertexes) {
                        Rectangle circleBounds = Debugger.getCircle(vertex.getLocation(), 7).getBounds();
                        if (!circleBounds.contains((double)locationOnDiagrqam.x, (double)locationOnDiagrqam.y)) continue;
                        text.append(" Vertex ");
                        text.append(vertex.getId());
                        text.append(' ');
                        text.append(vertex.getLocation());
                    }
                }
                statusBar.setText(text.toString());
            }
        });
        content.add((Component)drawPanel, "Center");
        content.add((Component)statusBar, "South");
        int offset = windowCounter * 20;
        JFrame frame = new JFrame("Voronoi Debug Spline Fit View: " + String.valueOf(parent));
        frame.setSize(800, 800);
        frame.setLocation(offset, offset);
        frame.getContentPane().add(content);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        ++windowCounter;
    }

    private static Shape getCircle(Point2d location, int cornerCircleSize) {
        return new Ellipse2D.Double((double)((int)location.x - cornerCircleSize / 2), (double)((int)location.y - cornerCircleSize / 2), (double)cornerCircleSize, (double)cornerCircleSize);
    }

    public void setInterrestingChild(MutableTreeMapNode interrestingChild) {
        this.interrestingChild = interrestingChild;
    }

    public MutableTreeMapNode getInterrestingChild() {
        return this.interrestingChild;
    }

    public static void draw(VoronoiOutputRaster voronoiOutput, String str1, Color color1, String str2, Color color2, String str3, Color color3, File file) {
        VoronoiCell[][] cellRaster = voronoiOutput.getCellRaster();
        voronoiOutput.getCellRasterSize(cellRasterSize);
        BufferedImage image = new BufferedImage(Debugger.cellRasterSize.width, Debugger.cellRasterSize.height, 5);
        for (int y = 0; y < Debugger.cellRasterSize.height; ++y) {
            for (int x = 0; x < Debugger.cellRasterSize.width; ++x) {
                VoronoiCell cell = cellRaster[x][y];
                Color color = cell == VoronoiCell.outsideDomainCell ? Color.white : (cell == null || cell.getChild() == null || cell.getChild().toString() == null ? Color.black : (cell.getChild().toString().startsWith(str1) ? color1 : (cell.getChild().toString().startsWith(str2) ? color2 : (cell.getChild().toString().startsWith(str3) ? color3 : Color.black))));
                image.setRGB(x, y, color.getRGB());
            }
        }
        if (file != null) {
            try {
                ImageIO.write((RenderedImage)image, "bmp", file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save(VoronoiOutputRaster raster, String dirPath, String name, VoronoiCell[] cells) {
        try {
            HashMap<String, Integer> nameIdMap = new HashMap<String, Integer>(cells.length);
            int id = 2;
            for (VoronoiCell cell : cells) {
                nameIdMap.put(cell.getChild().toString(), id++);
            }
            String headerPath = this.getHeaderPath(dirPath, name);
            PrintWriter writer = new PrintWriter(new File(headerPath));
            for (Map.Entry nameIdEntry : nameIdMap.entrySet()) {
                writer.println((String)nameIdEntry.getKey() + ", " + String.valueOf(nameIdEntry.getValue()));
            }
            java.awt.Rectangle domainBounds = raster.getDomainBounds();
            writer.println("DomainBounds = " + String.valueOf(domainBounds));
            writer.close();
            BufferedImage image = new BufferedImage(domainBounds.width, domainBounds.height, 5);
            for (int x = 0; x < domainBounds.width; ++x) {
                for (int y = 0; y < domainBounds.height; ++y) {
                    boolean nullCell;
                    VoronoiCell cell = raster.get(domainBounds.x + x, domainBounds.y + y);
                    boolean bl = nullCell = cell == null;
                    int value = !nullCell ? (cell == VoronoiCell.outsideDomainCell ? 1 : (Integer)nameIdMap.get(cell.getChild().toString())) : 0;
                    image.setRGB(x, y, value);
                }
            }
            String rasterPath = this.getRasterPath(dirPath, name);
            ImageIO.write((RenderedImage)image, "bmp", new File(rasterPath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public VoronoiOutputRaster load(String dirPath, String name, VoronoiCell[] cells) {
        try {
            String line;
            HashMap<String, VoronoiCell> nameCellMap = new HashMap<String, VoronoiCell>(cells.length);
            for (VoronoiCell cell : cells) {
                nameCellMap.put(cell.getChild().toString(), cell);
            }
            VoronoiOutputRaster raster = new VoronoiOutputRaster();
            HashMap<Integer, String> idNameMap = new HashMap<Integer, String>(cells.length);
            BufferedReader headerReader = new BufferedReader(new FileReader(new File(this.getHeaderPath(dirPath, name))));
            Rectangle domainBounds = null;
            while ((line = headerReader.readLine()) != null) {
                if (line.startsWith("DomainBounds")) {
                    int start = line.indexOf("[") + 1;
                    int end = line.indexOf("]");
                    String strRectangleData = line.substring(start, end);
                    String[] rectElements = strRectangleData.split(",");
                    int x = this.getNumber(rectElements[0]);
                    int y = this.getNumber(rectElements[1]);
                    int w = this.getNumber(rectElements[2]);
                    int h = this.getNumber(rectElements[3]);
                    domainBounds = new Rectangle(x, y, w, h);
                    raster.setDomain((Shape)domainBounds);
                    continue;
                }
                int lastSeparatorIndex = line.lastIndexOf(44);
                String strId = line.substring(lastSeparatorIndex + 1).trim();
                String cellName = line.substring(0, lastSeparatorIndex).trim();
                int id = Integer.parseInt(strId);
                idNameMap.put(id, cellName);
            }
            headerReader.close();
            BufferedImage image = ImageIO.read(new File(this.getRasterPath(dirPath, name)));
            for (int x = 0; x < domainBounds.width; ++x) {
                for (int y = 0; y < domainBounds.height; ++y) {
                    int id = image.getRGB(x, y) & 0xFFF;
                    VoronoiCell cell = id == 0 ? null : (id == 1 ? VoronoiCell.outsideDomainCell : (VoronoiCell)nameCellMap.get(idNameMap.get(id)));
                    raster.set(domainBounds.x + x, domainBounds.y + y, cell);
                }
            }
            return raster;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private int getNumber(String element) {
        return Integer.parseInt(element.substring(element.indexOf("=") + 1));
    }

    private String getRasterPath(String dirPath, String name) {
        if (!((String)dirPath).endsWith(File.separator)) {
            dirPath = (String)dirPath + File.separator;
        }
        return (String)dirPath + name + ".bmp";
    }

    private String getHeaderPath(String dirPath, String name) {
        if (!((String)dirPath).endsWith(File.separator)) {
            dirPath = (String)dirPath + File.separator;
        }
        return (String)dirPath + name + ".namemap";
    }

    static {
        windowCounter = 0;
        cellRasterSize = new Dimension();
    }

    public static class DataEntry {
        private final String name;
        private final double duration;
        private final double estimatedProgress;
        private final double remainingTimeEstimation;
        private final int pixelCells;
        private final int nPixels;
        private final int nCells;
        private final double layoutDuration;

        public DataEntry(String name, double duration, double estimatedProgress, double remainingTimeEstimation, int pixelCells, int nPixels, int nCells, double layoutDuration) {
            this.name = name;
            this.duration = duration;
            this.estimatedProgress = estimatedProgress;
            this.remainingTimeEstimation = remainingTimeEstimation;
            this.pixelCells = pixelCells;
            this.nPixels = nPixels;
            this.nCells = nCells;
            this.layoutDuration = layoutDuration;
        }

        public double getLayoutDuration() {
            return this.layoutDuration;
        }

        public double getDuration() {
            return this.duration;
        }

        public double getEstimatedProgress() {
            return this.estimatedProgress;
        }

        public double getRemainingTimeEstimation() {
            return this.remainingTimeEstimation;
        }

        public int getPixelCells() {
            return this.pixelCells;
        }

        public int getnPixels() {
            return this.nPixels;
        }

        public int getnCells() {
            return this.nCells;
        }
    }
}

