/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSRecordType3;
import org.opendatafoundation.data.spss.SPSSUtils;

public class SPSSRecordType2
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int variableTypeCode;
    int hasLabel;
    int missingValueFormatCode;
    int printFormatCode;
    int printFormatDecimals;
    int printFormatWidth;
    int printFormatType;
    int printFormatZero;
    int writeFormatCode;
    int writeFormatDecimals;
    int writeFormatWidth;
    int writeFormatType;
    int writeFormatZero;
    String name;
    int labelLength;
    String label;
    byte[][] missingValue = new byte[3][8];
    SPSSFile file;
    SPSSRecordType3 valueLabelSet;

    public String getFormatTypeCode(int n) {
        String string = "UNK";
        switch (n) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = "A";
                break;
            }
            case 2: {
                string = "AHEX";
                break;
            }
            case 3: {
                string = "COMMA";
                break;
            }
            case 4: {
                string = "DOLLAR";
                break;
            }
            case 5: {
                string = "F";
                break;
            }
            case 6: {
                string = "IB";
                break;
            }
            case 7: {
                string = "PIBHEX";
                break;
            }
            case 8: {
                string = "P";
                break;
            }
            case 9: {
                string = "PIB";
                break;
            }
            case 10: {
                string = "PK";
                break;
            }
            case 11: {
                string = "RB";
                break;
            }
            case 12: {
                string = "RBHEX";
                break;
            }
            case 15: {
                string = "Z";
                break;
            }
            case 16: {
                string = "N";
                break;
            }
            case 17: {
                string = "E";
                break;
            }
            case 20: {
                string = "DATE";
                break;
            }
            case 21: {
                string = "TIME";
                break;
            }
            case 22: {
                string = "DATETIME";
                break;
            }
            case 23: {
                string = "ADATE";
                break;
            }
            case 24: {
                string = "JDATE";
                break;
            }
            case 25: {
                string = "DTIME";
                break;
            }
            case 26: {
                string = "WKDAY";
                break;
            }
            case 27: {
                string = "MONTH";
                break;
            }
            case 28: {
                string = "MOYR";
                break;
            }
            case 29: {
                string = "QYR";
                break;
            }
            case 30: {
                string = "WKYR";
                break;
            }
            case 31: {
                string = "PCT";
                break;
            }
            case 32: {
                string = "DOT";
                break;
            }
            case 33: {
                string = "CCA";
                break;
            }
            case 34: {
                string = "CCB";
                break;
            }
            case 35: {
                string = "CCC";
                break;
            }
            case 36: {
                string = "CCD";
                break;
            }
            case 37: {
                string = "CCE";
                break;
            }
            case 38: {
                string = "EDATE";
                break;
            }
            case 39: {
                string = "SDATE";
            }
        }
        return string;
    }

    public String getFormatTypeLabel(int n) {
        String string = "Unknown";
        switch (n) {
            case 0: {
                string = "Continuation of string variable";
                break;
            }
            case 1: {
                string = "Alphanumeric";
                break;
            }
            case 2: {
                string = "Alphanumeric hexadecimal";
                break;
            }
            case 3: {
                string = "F format with comma";
                break;
            }
            case 4: {
                string = "Integer binary";
                break;
            }
            case 5: {
                string = "F (default numeric) format";
                break;
            }
            case 6: {
                string = "Integer binary";
                break;
            }
            case 7: {
                string = "Positive integer binary - hexadecimal";
                break;
            }
            case 8: {
                string = "Packed decimal";
                break;
            }
            case 9: {
                string = "Positive integer binary (unsigned)";
                break;
            }
            case 10: {
                string = "Positive packed decimal (unsigned)";
                break;
            }
            case 11: {
                string = "Floating point binary";
                break;
            }
            case 12: {
                string = "Floating point binary - hex";
                break;
            }
            case 15: {
                string = "Zoned decimal";
                break;
            }
            case 16: {
                string = "N format - unsigned with leading zeroes";
                break;
            }
            case 17: {
                string = "E fromat - with explicit power of 10";
                break;
            }
            case 20: {
                string = "Date format dd-mmm-yyyy";
                break;
            }
            case 21: {
                string = "Time format hh:mm:ss.s";
                break;
            }
            case 22: {
                string = "Date and time";
                break;
            }
            case 23: {
                string = "Date in mm/dd/yyyy form";
                break;
            }
            case 24: {
                string = "Julian date - yyyyddd";
                break;
            }
            case 25: {
                string = "Date-time dd hh:mm:ss.s";
                break;
            }
            case 26: {
                string = "Day of the week";
                break;
            }
            case 27: {
                string = "Month";
                break;
            }
            case 28: {
                string = "mmm yyyy";
                break;
            }
            case 29: {
                string = "q Q yyyy";
                break;
            }
            case 30: {
                string = "ww WK yyyy";
                break;
            }
            case 31: {
                string = "Percent - F followed by '%'";
                break;
            }
            case 32: {
                string = "Like COMMA, swicthing dot for comma";
                break;
            }
            case 33: {
                string = "User-programmable currency format (1)";
                break;
            }
            case 34: {
                string = "User-programmable currency format (2)";
                break;
            }
            case 35: {
                string = "User-programmable currency format (3)";
                break;
            }
            case 36: {
                string = "User-programmable currency format (4)";
                break;
            }
            case 37: {
                string = "User-programmable currency format (5)";
                break;
            }
            case 38: {
                string = "Date in dd.mm.yyyy style";
                break;
            }
            case 39: {
                string = "Date in yyyy/mm/dd style";
            }
        }
        return string;
    }

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.file = sPSSFile;
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSInt();
        if (this.recordTypeCode != 2) {
            throw new SPSSFileException("Error reading variable Record: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 2.");
        }
        this.variableTypeCode = sPSSFile.readSPSSInt();
        this.hasLabel = sPSSFile.readSPSSInt();
        this.missingValueFormatCode = sPSSFile.readSPSSInt();
        if (Math.abs(this.missingValueFormatCode) > 3) {
            throw new SPSSFileException("Error reading variable Record: invalid missing value format code [" + this.missingValueFormatCode + "]. Range is -3 to 3.");
        }
        this.printFormatCode = sPSSFile.readSPSSInt();
        this.printFormatDecimals = this.printFormatCode >> 0 & 0xFF;
        this.printFormatWidth = this.printFormatCode >> 8 & 0xFF;
        this.printFormatType = this.printFormatCode >> 16 & 0xFF;
        this.printFormatZero = this.printFormatCode >> 24 & 0xFF;
        this.writeFormatCode = sPSSFile.readSPSSInt();
        this.writeFormatDecimals = this.writeFormatCode >> 0 & 0xFF;
        this.writeFormatWidth = this.writeFormatCode >> 8 & 0xFF;
        this.writeFormatType = this.writeFormatCode >> 16 & 0xFF;
        this.writeFormatZero = this.writeFormatCode >> 24 & 0xFF;
        this.name = sPSSFile.readSPSSString(8).replaceAll("\\s+$", "");
        if (this.hasLabel == 1) {
            this.labelLength = sPSSFile.readSPSSInt();
            this.label = sPSSFile.readSPSSString(this.labelLength);
            if (this.labelLength % 4 != 0) {
                sPSSFile.skipBytes(4 - this.labelLength % 4);
            }
        }
        for (int i = 0; i < Math.abs(this.missingValueFormatCode); ++i) {
            sPSSFile.read(this.missingValue[i]);
        }
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 2 - VARIABLE";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nVariable Type   : " + this.variableTypeCode;
        string = string + "\nHas Label       : " + this.hasLabel;
        string = string + "\nMissing Format  : " + this.missingValueFormatCode;
        string = string + "\nPrint Format    : " + this.printFormatCode;
        string = string + "\n- Decimals      : " + this.printFormatDecimals;
        string = string + "\n- Width         : " + this.printFormatWidth;
        string = string + "\n- Type          : " + this.printFormatType + " [" + this.getFormatTypeCode(this.printFormatType) + "/" + this.getFormatTypeLabel(this.printFormatType) + "]";
        string = string + "\n- Zero          : " + this.printFormatZero;
        string = string + "\nWrite Format    : " + this.writeFormatCode;
        string = string + "\n- Decimals      : " + this.writeFormatDecimals;
        string = string + "\n- Width         : " + this.writeFormatWidth;
        string = string + "\n- Type          : " + this.writeFormatType + " [" + this.getFormatTypeCode(this.writeFormatType) + "/" + this.getFormatTypeLabel(this.writeFormatType) + "]";
        string = string + "\n- Zero          : " + this.writeFormatZero;
        string = string + "\nName            : " + this.name;
        if (this.hasLabel == 1) {
            string = string + "\nLabel length    : " + this.labelLength;
            string = string + "\nLabel           : " + this.label;
        }
        if (this.missingValueFormatCode > 0) {
            for (int i = 0; i < this.missingValueFormatCode; ++i) {
                string = string + "\nMissing " + i + "       :";
                string = this.variableTypeCode == 0 ? string + "" + SPSSUtils.byte8ToDouble(this.missingValue[i]) : string + (this.file.charset == null ? SPSSUtils.byte8ToString(this.missingValue[i]) : SPSSUtils.byte8ToString(this.missingValue[i], this.file.charset));
            }
        } else if (this.missingValueFormatCode <= -2) {
            string = string + "\nMissing range   : ";
            string = this.variableTypeCode == 0 ? string + "" + SPSSUtils.byte8ToDouble(this.missingValue[0]) : string + (this.file.charset == null ? SPSSUtils.byte8ToString(this.missingValue[0]) : SPSSUtils.byte8ToString(this.missingValue[0], this.file.charset));
            string = string + " - ";
            string = this.variableTypeCode == 0 ? string + "" + SPSSUtils.byte8ToDouble(this.missingValue[1]) : string + (this.file.charset == null ? SPSSUtils.byte8ToString(this.missingValue[1]) : SPSSUtils.byte8ToString(this.missingValue[1], this.file.charset));
            if (this.missingValueFormatCode == -3) {
                string = string + "\nMissing 3       : ";
                string = this.variableTypeCode == 0 ? string + "" + SPSSUtils.byte8ToDouble(this.missingValue[2]) : string + (this.file.charset == null ? SPSSUtils.byte8ToString(this.missingValue[2]) : SPSSUtils.byte8ToString(this.missingValue[2], this.file.charset));
            }
        }
        return string;
    }
}

