/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import org.openexi.proc.common.BinaryDataSource;
import org.openexi.proc.common.EventCode;
import org.openexi.proc.common.EventDescription;
import org.openexi.proc.common.EventType;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.events.EXIEventComment;
import org.openexi.proc.events.EXIEventDTD;
import org.openexi.proc.events.EXIEventEntityReference;
import org.openexi.proc.events.EXIEventProcessingInstruction;
import org.openexi.proc.events.EXIEventSchemaNil;
import org.openexi.proc.events.EXIEventWildcardStartElement;
import org.openexi.proc.grammars.EventCodeTuple;
import org.openexi.proc.grammars.EventTypeSchema;
import org.openexi.proc.io.BinaryValueScanner;
import org.openexi.proc.io.Scanner;
import org.openexi.proc.io.ValueScanner;
import org.openexi.schema.Characters;

abstract class SimpleScanner
extends Scanner {
    private final EXIEventTransientCharacters m_transientCharacters = new EXIEventTransientCharacters();
    private final EXIEventTransientElement m_transientElement = new EXIEventTransientElement();
    private final EXIEventTransientAttribute m_transientAttribute = new EXIEventTransientAttribute();
    private final EXIEventTransientBinaryData m_transientBinaryData = new EXIEventTransientBinaryData();

    SimpleScanner(boolean bl) {
        super(bl);
    }

    public final void setBlockSize(int n) {
    }

    public final void setBinaryChunkSize(int n) {
        this.m_binaryChunkSize = n;
    }

    public final EventDescription nextEvent() throws IOException {
        EventCode eventCode;
        EventCodeTuple eventCodeTuple = this.getNextEventCodes();
        if (eventCodeTuple == null) {
            return null;
        }
        while (true) {
            int n;
            if ((n = eventCodeTuple.width) != 0) {
                int n2 = this.readNBitUnsigned(n, this.m_inputStream);
                eventCode = eventCodeTuple.reversed ? eventCodeTuple.eventCodes[eventCodeTuple.itemsCount - (n2 + 1)] : eventCodeTuple.eventCodes[n2];
            } else {
                eventCode = eventCodeTuple.headItem;
            }
            if (eventCode.itemType != -1) break;
            eventCodeTuple = (EventCodeTuple)eventCode;
        }
        EventType eventType = (EventType)eventCode;
        switch (eventType.itemType) {
            case 13: {
                this.currentState.targetGrammar.startDocument(this.currentState);
                return eventType.asEventDescription();
            }
            case 10: {
                return this.doDocumentTypeDefinition(eventType);
            }
            case 11: {
                return this.doElement(eventType);
            }
            case 12: 
            case 16: {
                return this.doAttribute(eventType);
            }
            case 23: {
                return this.doAttributeInvalid(eventType);
            }
            case 19: {
                return this.doCharactersTyped(eventType);
            }
            case 20: {
                return this.doCharactersMixed(eventType);
            }
            case 3: {
                return this.doCharactersUntyped(eventType);
            }
            case 9: {
                if (eventType.depth != 1) {
                    this.currentState.targetGrammar.end(this.currentState);
                }
                this.currentState = this.m_statesStack[--this.m_n_stackedStates - 1];
                this.m_nameLocusLastDepth -= 2;
                if (this.m_preserveNS) {
                    --this.m_prefixUriBindingsLocusLastDepth;
                }
                return eventType.asEventDescription();
            }
            case 4: {
                this.currentState.targetGrammar.endDocument(this.currentState);
                return eventType.asEventDescription();
            }
            case 15: {
                return this.doElementWildcardNS(eventType);
            }
            case 5: 
            case 14: {
                return this.doElementWildcardAny(eventType);
            }
            case 18: {
                return this.doAttributeWildcardNS(eventType);
            }
            case 8: 
            case 17: {
                return this.doAttributeWildcardAny(eventType);
            }
            case 21: {
                return this.doXsiNil(eventType);
            }
            case 22: {
                return this.doXsiType(eventType);
            }
            case 7: {
                return this.readNS(eventType);
            }
            case 6: {
                throw new UnsupportedOperationException("Event type SC is not supported yet.");
            }
            case 0: {
                return this.doProcessingInstruction(eventType);
            }
            case 1: {
                return this.doComment(eventType);
            }
            case 2: {
                return this.doEntityReferemce(eventType);
            }
        }
        assert (false);
        return null;
    }

    private EventDescription doDocumentTypeDefinition(EventType eventType) throws IOException {
        String string = this.readText().makeString();
        Characters characters = this.readText();
        String string2 = characters.length != 0 ? characters.makeString() : null;
        Characters characters2 = this.readText();
        String string3 = characters2.length != 0 ? characters2.makeString() : null;
        return new EXIEventDTD(string, string2, string3, this.readText(), eventType);
    }

    private EventDescription doElement(EventType eventType) throws IOException {
        this.m_characterBuffer.nextIndex = 0;
        int n = eventType.getURIId();
        int n2 = eventType.getNameId();
        String string = this.m_preserveNS ? this.readPrefixOfQName(n) : null;
        this.currentState.targetGrammar.element(eventType, this.currentState);
        this.m_nameLocusLastDepth += 2;
        this.m_nameLocusStack[this.m_nameLocusLastDepth] = n2;
        this.m_nameLocusStack[this.m_nameLocusLastDepth + 1] = n;
        if (this.m_preserveNS) {
            this.m_prefixUriBindingsLocusStack[++this.m_prefixUriBindingsLocusLastDepth] = this.m_prefixUriBindings;
            this.m_transientElement.prefix = string;
            this.m_transientElement.eventType = eventType;
            return this.m_transientElement;
        }
        return eventType.asEventDescription();
    }

    private EventDescription doAttribute(EventType eventType) throws IOException {
        int n = eventType.getURIId();
        int n2 = eventType.getNameId();
        String string = this.m_preserveNS ? this.readPrefixOfQName(n) : null;
        this.attribute(eventType);
        if (eventType.itemType == 12 && n == 2 && n2 == 1) {
            return this.readXsiTypeValue(string, eventType);
        }
        this.m_transientAttribute.prefix = string;
        this.m_transientAttribute.eventType = eventType;
        if (eventType.itemType == 16) {
            EventTypeSchema eventTypeSchema = (EventTypeSchema)eventType;
            int n3 = eventTypeSchema.nd;
            if (n3 != -1) {
                int n4 = this.m_types[n3 + 2];
                ValueScanner valueScanner = this.m_valueScannerTable[this.m_codecTable[n4]];
                this.m_transientAttribute.text = valueScanner.scan(n2, n, n3);
                return this.m_transientAttribute;
            }
        }
        this.m_transientAttribute.text = this.m_valueScannerTable[15].scan(n2, n, -1);
        return this.m_transientAttribute;
    }

    private EventDescription doAttributeInvalid(EventType eventType) throws IOException {
        int n = eventType.getURIId();
        int n2 = eventType.getNameId();
        String string = this.m_preserveNS ? this.readPrefixOfQName(n) : null;
        Characters characters = this.m_valueScannerTable[15].scan(n2, n, -1);
        this.attribute(eventType);
        this.m_transientAttribute.prefix = string;
        this.m_transientAttribute.text = characters;
        this.m_transientAttribute.eventType = eventType;
        return this.m_transientAttribute;
    }

    private EventDescription doCharactersTyped(EventType eventType) throws IOException {
        Characters characters;
        short s;
        this.currentState.targetGrammar.chars(eventType, this.currentState);
        int n = this.currentState.contentDatatype;
        assert (n != -1);
        int n2 = this.schema.getSerialOfType(n);
        ValueScanner valueScanner = this.m_valueScannerTable[this.m_codecTable[n2]];
        if (this.m_binaryDataEnabled && ((s = valueScanner.getCodecID()) == 1 || s == 2)) {
            ((BinaryValueScanner)valueScanner).scan(-1L, this.m_transientBinaryData.binaryData);
            this.m_transientBinaryData.eventType = eventType;
            return this.m_transientBinaryData;
        }
        this.m_transientCharacters.characters = characters = valueScanner.scan(this.m_nameLocusStack[this.m_nameLocusLastDepth], this.m_nameLocusStack[this.m_nameLocusLastDepth + 1], n);
        this.m_transientCharacters.eventType = eventType;
        return this.m_transientCharacters;
    }

    private EventDescription doCharactersMixed(EventType eventType) throws IOException {
        this.undeclaredCharacters(eventType.getIndex());
        Characters characters = this.m_valueScannerTable[15].scan(this.m_nameLocusStack[this.m_nameLocusLastDepth], this.m_nameLocusStack[this.m_nameLocusLastDepth + 1], -1);
        return new EXIEventSchemaMixedCharacters(characters, eventType);
    }

    private EventDescription doCharactersUntyped(EventType eventType) throws IOException {
        this.undeclaredCharacters(eventType.getIndex());
        Characters characters = this.m_valueScannerTable[15].scan(this.m_nameLocusStack[this.m_nameLocusLastDepth], this.m_nameLocusStack[this.m_nameLocusLastDepth + 1], -1);
        return new EXIEventUndeclaredCharacter(characters, eventType);
    }

    private EventDescription doAttributeWildcardAny(EventType eventType) throws IOException {
        int n;
        this.readQName(this.qname);
        String string = this.qname.prefix;
        if (eventType.itemType == 8) {
            this.wildcardAttribute(eventType.getIndex(), this.qname.uriId, this.qname.localNameId);
        }
        if (this.qname.uriId == 2 && this.qname.localNameId == 1) {
            assert (eventType.itemType == 8);
            return this.readXsiTypeValue(string, eventType);
        }
        String string2 = this.stringTable.getURI(this.qname.uriId);
        String string3 = this.stringTable.getLocalNamePartition((int)this.qname.uriId).localNameEntries[this.qname.localNameId].localName;
        int n2 = -1;
        if (eventType.itemType != 8 && (n = this.schema.getGlobalAttrOfSchema(string2, string3)) != -1) {
            n2 = this.schema.getTypeOfAttr(n);
        }
        Characters characters = this.getValueScanner(n2).scan(this.qname.localNameId, this.qname.uriId, n2);
        return new EXIEventWildcardAttribute(string2, string3, this.qname.uriId, this.qname.localNameId, string, characters, eventType);
    }

    private EventDescription doAttributeWildcardNS(EventType eventType) throws IOException {
        this.readQName(this.qname, eventType.getURIId());
        String string = this.qname.prefix;
        String string2 = this.stringTable.getURI(this.qname.uriId);
        String string3 = this.stringTable.getLocalNamePartition((int)this.qname.uriId).localNameEntries[this.qname.localNameId].localName;
        int n = -1;
        int n2 = this.schema.getGlobalAttrOfSchema(string2, string3);
        if (n2 != -1) {
            n = this.schema.getTypeOfAttr(n2);
        }
        Characters characters = this.getValueScanner(n).scan(this.qname.localNameId, this.qname.uriId, n);
        return new EXIEventWildcardAttribute(string2, string3, this.qname.uriId, this.qname.localNameId, string, characters, eventType);
    }

    private EventDescription doElementWildcardNS(EventType eventType) throws IOException {
        this.m_characterBuffer.nextIndex = 0;
        this.readQName(this.qname, eventType.getURIId());
        String string = this.stringTable.getURI(this.qname.uriId);
        String string2 = this.stringTable.getLocalNamePartition((int)this.qname.uriId).localNameEntries[this.qname.localNameId].localName;
        this.m_nameLocusLastDepth += 2;
        this.m_nameLocusStack[this.m_nameLocusLastDepth] = this.qname.localNameId;
        this.m_nameLocusStack[this.m_nameLocusLastDepth + 1] = this.qname.uriId;
        if (this.m_preserveNS) {
            this.m_prefixUriBindingsLocusStack[++this.m_prefixUriBindingsLocusLastDepth] = this.m_prefixUriBindings;
        }
        this.startWildcardElement(eventType.getIndex(), this.qname.uriId, this.qname.localNameId);
        return new EXIEventWildcardStartElement(string, string2, this.qname.uriId, this.qname.localNameId, this.qname.prefix, eventType);
    }

    private EventDescription doElementWildcardAny(EventType eventType) throws IOException {
        this.m_characterBuffer.nextIndex = 0;
        this.readQName(this.qname);
        String string = this.stringTable.getURI(this.qname.uriId);
        String string2 = this.stringTable.getLocalNamePartition((int)this.qname.uriId).localNameEntries[this.qname.localNameId].localName;
        this.m_nameLocusLastDepth += 2;
        this.m_nameLocusStack[this.m_nameLocusLastDepth] = this.qname.localNameId;
        this.m_nameLocusStack[this.m_nameLocusLastDepth + 1] = this.qname.uriId;
        if (this.m_preserveNS) {
            this.m_prefixUriBindingsLocusStack[++this.m_prefixUriBindingsLocusLastDepth] = this.m_prefixUriBindings;
        }
        this.startWildcardElement(eventType.getIndex(), this.qname.uriId, this.qname.localNameId);
        return new EXIEventWildcardStartElement(string, string2, this.qname.uriId, this.qname.localNameId, this.qname.prefix, eventType);
    }

    private EventDescription doXsiNil(EventType eventType) throws IOException {
        int n = eventType.getURIId();
        String string = this.m_preserveNS ? this.readPrefixOfQName(n) : null;
        EXIEventSchemaNil eXIEventSchemaNil = this.readXsiNilValue(string, eventType);
        if (eXIEventSchemaNil.isNilled()) {
            this.nillify(eventType.getIndex());
        }
        return eXIEventSchemaNil;
    }

    private EventDescription doXsiType(EventType eventType) throws IOException {
        int n = eventType.getURIId();
        String string = this.m_preserveNS ? this.readPrefixOfQName(n) : null;
        return this.readXsiTypeValue(string, eventType);
    }

    private EventDescription doProcessingInstruction(EventType eventType) throws IOException {
        this.miscContent(eventType.getIndex());
        String string = this.readText().makeString();
        Characters characters = this.readText();
        return new EXIEventProcessingInstruction(string, characters, eventType);
    }

    private EventDescription doComment(EventType eventType) throws IOException {
        this.miscContent(eventType.getIndex());
        return new EXIEventComment(this.readText(), eventType);
    }

    private EventDescription doEntityReferemce(EventType eventType) throws IOException {
        this.miscContent(eventType.getIndex());
        String string = this.readText().makeString();
        return new EXIEventEntityReference(string, eventType);
    }

    private void readQName(QName qName) throws IOException {
        int n = this.readURI();
        StringTable.LocalNamePartition localNamePartition = this.stringTable.getLocalNamePartition(n);
        qName.uriId = n;
        qName.localNameId = this.readLocalName(localNamePartition);
        qName.prefix = this.m_preserveNS ? this.readPrefixOfQName(n) : null;
    }

    private void readQName(QName qName, int n) throws IOException {
        StringTable.LocalNamePartition localNamePartition = this.stringTable.getLocalNamePartition(n);
        int n2 = this.readLocalName(localNamePartition);
        qName.uriId = n;
        qName.localNameId = n2;
        qName.prefix = this.m_preserveNS ? this.readPrefixOfQName(n) : null;
    }

    private static final class EXIEventTransientBinaryData
    implements EventDescription {
        final BinaryDataSource binaryData = new BinaryDataSource();
        EventType eventType = null;

        EXIEventTransientBinaryData() {
        }

        public byte getEventKind() {
            return 13;
        }

        public String getURI() {
            return null;
        }

        public String getName() {
            return "#text";
        }

        public int getURIId() {
            return -1;
        }

        public int getNameId() {
            return -1;
        }

        public String getPrefix() {
            return null;
        }

        public Characters getCharacters() {
            return null;
        }

        public BinaryDataSource getBinaryDataSource() {
            return this.binaryData;
        }

        public EventType getEventType() {
            return this.eventType;
        }
    }

    private static final class EXIEventWildcardAttribute
    implements EventDescription {
        private final EventType m_eventType;
        private final String m_uri;
        private final String m_name;
        private final int m_uriId;
        private final int m_nameId;
        private final String m_prefix;
        private final Characters m_text;

        public EXIEventWildcardAttribute(String string, String string2, int n, int n2, String string3, Characters characters, EventType eventType) {
            this.m_prefix = string3;
            this.m_eventType = eventType;
            this.m_uri = string;
            this.m_name = string2;
            this.m_uriId = n;
            this.m_nameId = n2;
            this.m_text = characters;
        }

        public byte getEventKind() {
            return 3;
        }

        public int getURIId() {
            return this.m_uriId;
        }

        public int getNameId() {
            return this.m_nameId;
        }

        public String getPrefix() {
            return this.m_prefix;
        }

        public Characters getCharacters() {
            return this.m_text;
        }

        public BinaryDataSource getBinaryDataSource() {
            return null;
        }

        public EventType getEventType() {
            return this.m_eventType;
        }

        public String getName() {
            return this.m_name;
        }

        public String getURI() {
            return this.m_uri;
        }
    }

    private static final class EXIEventSchemaMixedCharacters
    implements EventDescription {
        private final EventType m_eventType;
        private final Characters m_text;

        public EXIEventSchemaMixedCharacters(Characters characters, EventType eventType) {
            assert (eventType.itemType == 20);
            this.m_eventType = eventType;
            this.m_text = characters;
        }

        public byte getEventKind() {
            return 6;
        }

        public String getURI() {
            return null;
        }

        public String getName() {
            return "#text";
        }

        public String getPrefix() {
            return null;
        }

        public int getNameId() {
            return -1;
        }

        public int getURIId() {
            return -1;
        }

        public Characters getCharacters() {
            return this.m_text;
        }

        public BinaryDataSource getBinaryDataSource() {
            return null;
        }

        public EventType getEventType() {
            return this.m_eventType;
        }
    }

    private static final class EXIEventUndeclaredCharacter
    implements EventDescription {
        private final EventType m_eventType;
        private Characters m_text;

        public EXIEventUndeclaredCharacter(Characters characters, EventType eventType) {
            assert (eventType.itemType == 3);
            this.m_eventType = eventType;
            this.m_text = characters;
        }

        public byte getEventKind() {
            return 6;
        }

        public String getURI() {
            return null;
        }

        public String getName() {
            return "#text";
        }

        public int getNameId() {
            return -1;
        }

        public int getURIId() {
            return -1;
        }

        public String getPrefix() {
            return null;
        }

        public Characters getCharacters() {
            return this.m_text;
        }

        public BinaryDataSource getBinaryDataSource() {
            return null;
        }

        public EventType getEventType() {
            return this.m_eventType;
        }
    }

    private static final class EXIEventTransientAttribute
    implements EventDescription {
        String prefix;
        EventType eventType;
        Characters text;

        private EXIEventTransientAttribute() {
        }

        public final byte getEventKind() {
            return 3;
        }

        public final String getURI() {
            return this.eventType.uri;
        }

        public final String getName() {
            return this.eventType.name;
        }

        public final int getURIId() {
            return this.eventType.getURIId();
        }

        public final int getNameId() {
            return this.eventType.getNameId();
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public Characters getCharacters() {
            return this.text;
        }

        public BinaryDataSource getBinaryDataSource() {
            return null;
        }

        public final EventType getEventType() {
            return this.eventType;
        }
    }

    private static final class EXIEventTransientElement
    implements EventDescription {
        String prefix;
        EventType eventType;

        private EXIEventTransientElement() {
        }

        public final byte getEventKind() {
            return 2;
        }

        public String getName() {
            return this.eventType.name;
        }

        public String getURI() {
            return this.eventType.uri;
        }

        public int getNameId() {
            return this.eventType.getNameId();
        }

        public int getURIId() {
            return this.eventType.getURIId();
        }

        public String getPrefix() {
            return this.prefix;
        }

        public final Characters getCharacters() {
            return null;
        }

        public BinaryDataSource getBinaryDataSource() {
            return null;
        }

        public final EventType getEventType() {
            return this.eventType;
        }
    }

    private static final class EXIEventTransientCharacters
    implements EventDescription {
        Characters characters = null;
        EventType eventType = null;

        EXIEventTransientCharacters() {
        }

        public byte getEventKind() {
            return 6;
        }

        public String getURI() {
            return null;
        }

        public String getName() {
            return "#text";
        }

        public int getURIId() {
            return -1;
        }

        public int getNameId() {
            return -1;
        }

        public String getPrefix() {
            return null;
        }

        public Characters getCharacters() {
            return this.characters;
        }

        public BinaryDataSource getBinaryDataSource() {
            return null;
        }

        public EventType getEventType() {
            return this.eventType;
        }
    }
}

