/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.arrow;

import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.DataFrameExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class ArrowDataFrameExporter
extends DataFrameExporter {
    private static RootAllocator allocator;
    private static int batch;

    public static <R, C, V> void exportArrow(DataFrame<R, C, V> df, File file) throws IOException {
        FileOutputStream output = new FileOutputStream(file);
        ArrowDataFrameExporter.exportArrow(df, output);
    }

    public static <R, C, V> void exportArrow(DataFrame<R, C, V> df, OutputStream output) throws IOException {
        if (allocator == null) {
            ArrowDataFrameExporter.allocate(Long.MAX_VALUE);
        }
        Schema schema = ArrowDataFrameExporter.toArrowSchema(df);
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
             ArrowStreamWriter writer = new ArrowStreamWriter(root, (DictionaryProvider)provider, output);){
            writer.start();
            int size = df.getRowCount();
            int entries = size;
            for (int from = 0; from < size; from += batch) {
                int count = Math.min(batch, entries - from);
                root.setRowCount(count);
                List fields = root.getSchema().getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    Field field = (Field)fields.get(i);
                    FieldVector vector = root.getVector(field.getName());
                    Object column = df.getColumnKey(i);
                    Class type = df.getColumnClass(column);
                    Class clazz = df.getColumnClass(column);
                    if (clazz == Integer.class) {
                        ArrowDataFrameExporter.writeIntObjectField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == Long.class) {
                        ArrowDataFrameExporter.writeLongObjectField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == Double.class) {
                        ArrowDataFrameExporter.writeDoubleObjectField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == Float.class) {
                        ArrowDataFrameExporter.writeFloatObjectField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == Boolean.class) {
                        ArrowDataFrameExporter.writeBooleanObjectField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == Byte.class) {
                        ArrowDataFrameExporter.writeByteObjectField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == Short.class) {
                        ArrowDataFrameExporter.writeShortObjectField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == Character.class) {
                        ArrowDataFrameExporter.writeCharObjectField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == BigDecimal.class) {
                        ArrowDataFrameExporter.writeDecimalField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == String.class) {
                        ArrowDataFrameExporter.writeStringField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == LocalDate.class) {
                        ArrowDataFrameExporter.writeDateField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == LocalTime.class) {
                        ArrowDataFrameExporter.writeTimeField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == LocalDateTime.class) {
                        ArrowDataFrameExporter.writeDateTimeField(df, column, vector, from, count);
                        continue;
                    }
                    if (clazz == URL.class) {
                        ArrowDataFrameExporter.writeURLField(df, column, vector, from, count);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
                }
                writer.writeBatch();
            }
        }
    }

    public static void allocate(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Invalid RootAllocator limit: " + limit);
        }
        allocator = new RootAllocator(limit);
    }

    private static <R, C, V> void writeIntField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        IntVector vector = (IntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, ((Integer)df.getValueAt(df.getRowKey(j), column)).intValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeIntObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        IntVector vector = (IntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Integer x = (Integer)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.intValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeBooleanField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BitVector vector = (BitVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, (Boolean)df.getValueAt(df.getRowKey(j), column) != false ? 1 : 0);
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeBooleanObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BitVector vector = (BitVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Boolean x = (Boolean)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x != false ? 1 : 0);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeCharField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        UInt2Vector vector = (UInt2Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, ((Character)df.getValueAt(df.getRowKey(j), column)).charValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeCharObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        UInt2Vector vector = (UInt2Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Character x = (Character)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.charValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeByteField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, ((Byte)df.getValueAt(df.getRowKey(j), column)).byteValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeByteObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Byte x = (Byte)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.byteValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeShortField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, ((Short)df.getValueAt(df.getRowKey(j), column)).shortValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeShortObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Short x = (Short)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.shortValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeLongField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BigIntVector vector = (BigIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, ((Long)df.getValueAt(df.getRowKey(j), column)).longValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeLongObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BigIntVector vector = (BigIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Long x = (Long)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.longValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeFloatField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float4Vector vector = (Float4Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, ((Float)df.getValueAt(df.getRowKey(j), column)).floatValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeFloatObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float4Vector vector = (Float4Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Float x = (Float)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.floatValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeDoubleField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float8Vector vector = (Float8Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, ((Double)df.getValueAt(df.getRowKey(j), column)).doubleValue());
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeDoubleObjectField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float8Vector vector = (Float8Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            Double x = (Double)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.doubleValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeStringField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) throws UnsupportedEncodingException {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        VarCharVector vector = (VarCharVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            String x = (String)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.getBytes("UTF-8"));
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeDecimalField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) throws UnsupportedEncodingException {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        DecimalVector vector = (DecimalVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            BigDecimal x = (BigDecimal)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeDateField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        DateDayVector vector = (DateDayVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            LocalDate x = (LocalDate)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, (int)x.toEpochDay());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeTimeField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TimeNanoVector vector = (TimeNanoVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            LocalTime x = (LocalTime)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toNanoOfDay());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeDateTimeField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TimeStampMilliTZVector vector = (TimeStampMilliTZVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            LocalDateTime x = (LocalDateTime)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toInstant(OffsetDateTime.now().getOffset()).toEpochMilli());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeByteArrayField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        VarBinaryVector vector = (VarBinaryVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            byte[] bytes = (byte[])df.getValueAt(df.getRowKey(j), column);
            if (bytes == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, bytes);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> void writeURLField(DataFrame<R, C, V> df, C column, FieldVector fieldVector, int from, int count) throws UnsupportedEncodingException {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        VarCharVector vector = (VarCharVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            URL x = (URL)df.getValueAt(df.getRowKey(j), column);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toExternalForm().getBytes("UTF-8"));
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private static <R, C, V> Schema toArrowSchema(DataFrame<R, C, V> schema) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Object field : schema.columns()) {
            fields.add(ArrowDataFrameExporter.toArrowField(schema, field));
        }
        return new Schema(fields, null);
    }

    private static <R, C, V> Field toArrowField(DataFrame<R, C, V> schema, C field) {
        Class columnClass = schema.getColumnClass(field);
        if (Integer.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null);
        }
        if (Long.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null);
        }
        if (Double.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null), null);
        }
        if (Float.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null), null);
        }
        if (Boolean.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null);
        }
        if (Byte.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Int(8, true), null), null);
        }
        if (Short.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Int(16, true), null), null);
        }
        if (Character.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), new FieldType(false, (ArrowType)new ArrowType.Int(16, false), null), null);
        }
        if (BigDecimal.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Decimal(28, 10)), null);
        }
        if (String.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Utf8()), null);
        }
        if (Date.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Date(DateUnit.DAY)), null);
        }
        if (Time.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)), null);
        }
        if (URL.class.equals((Object)columnClass)) {
            return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Utf8()), null);
        }
        if (Object.class.equals((Object)columnClass)) {
            Class clazz = schema.getColumnClass(field);
            if (clazz == Integer.class) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null);
            }
            if (clazz == Long.class) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), null);
            }
            if (clazz == Double.class) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), null);
            }
            if (clazz == Float.class) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), null);
            }
            if (clazz == Boolean.class) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Bool()), null);
            }
            if (clazz == Byte.class) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Int(8, true)), null);
            }
            if (clazz == Short.class) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Int(16, true)), null);
            }
            if (clazz == Character.class) {
                return new Field(schema.getColumnName(field), FieldType.nullable((ArrowType)new ArrowType.Int(16, false)), null);
            }
        }
        throw new UnsupportedOperationException("Unsupported smile to arrow type conversion: " + String.valueOf(columnClass));
    }

    static {
        batch = 1000000;
    }
}

