/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.parquet;

import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.parquet.DataFrameSchemaConverter;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.Preconditions;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class DataFrameWriteSupport<T>
extends WriteSupport<T> {
    private static final String MAP_REPEATED_NAME = "key_value";
    private static final String MAP_KEY_NAME = "key";
    private static final String MAP_VALUE_NAME = "value";
    private static final String LIST_REPEATED_NAME = "list";
    private static final String OLD_LIST_REPEATED_NAME = "array";
    static final String LIST_ELEMENT_NAME = "element";
    private RecordConsumer recordConsumer;
    private MessageType rootSchema;
    private DataFrame rootdataFrame;

    public DataFrameWriteSupport() {
    }

    @Deprecated
    public DataFrameWriteSupport(MessageType schema, DataFrame dataFrame) {
        this.rootSchema = schema;
        this.rootdataFrame = dataFrame;
    }

    public String getName() {
        return "avro";
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.rootdataFrame == null) {
            this.rootSchema = new DataFrameSchemaConverter().convert(this.rootdataFrame);
        }
        HashMap extraMetaData = new HashMap();
        return new WriteSupport.WriteContext(this.rootSchema, extraMetaData);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(T record) {
        this.recordConsumer.startMessage();
        this.writeRecordFields((GroupType)this.rootSchema, this.rootdataFrame, record);
        this.recordConsumer.endMessage();
    }

    private void writeRecord(GroupType schema, DataFrame dataFrame, Object record) {
        this.recordConsumer.startGroup();
        this.writeRecordFields(schema, dataFrame, record);
        this.recordConsumer.endGroup();
    }

    private <R, C, V> void writeRecordFields(GroupType schema, DataFrame<R, C, V> dataFrame, R record) {
        List fields = schema.getFields();
        int index = 0;
        for (Object column : dataFrame.columns()) {
            Type fieldType = (Type)fields.get(index);
            Object value = dataFrame.getValueAt(record, column);
            if (value != null) {
                this.recordConsumer.startField(dataFrame.getColumnName(column), index);
                this.writeValue(null, dataFrame, column, value);
                this.recordConsumer.endField(dataFrame.getColumnName(column), index);
            } else if (fieldType.isRepetition(Type.Repetition.REQUIRED)) {
                throw new RuntimeException("Null-value for required field: " + String.valueOf(column));
            }
            ++index;
        }
    }

    private <R, C, V> void writeValue(Type type, DataFrame dataFrame, C column, Object value) {
        this.writeValueWithoutConversion(type, dataFrame, column, value);
    }

    private <R, C, V> void writeValueWithoutConversion(Type type, DataFrame<R, C, V> dataFrame, C column, Object value) {
        Class columnClass = dataFrame.getColumnClass(column);
        if (Boolean.class.equals((Object)columnClass)) {
            this.recordConsumer.addBoolean(((Boolean)value).booleanValue());
        } else if (Integer.class.equals((Object)columnClass)) {
            this.recordConsumer.addInteger(((Number)value).intValue());
        } else if (value instanceof Character) {
            this.recordConsumer.addInteger((int)((Character)value).charValue());
        } else if (Long.class.equals((Object)columnClass)) {
            this.recordConsumer.addLong(((Number)value).longValue());
        } else if (Float.class.equals((Object)columnClass)) {
            this.recordConsumer.addFloat(((Number)value).floatValue());
        } else if (Double.class.equals((Object)columnClass)) {
            this.recordConsumer.addDouble(((Number)value).doubleValue());
        } else if (byte[].class.equals((Object)columnClass)) {
            if (value instanceof byte[]) {
                this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])((byte[])value)));
            } else {
                this.recordConsumer.addBinary(Binary.fromReusedByteBuffer((ByteBuffer)((ByteBuffer)value)));
            }
        } else if (String.class.equals((Object)columnClass)) {
            this.recordConsumer.addBinary(this.fromString(value));
        } else if (Enum.class.equals((Object)columnClass)) {
            this.recordConsumer.addBinary(Binary.fromString((String)value.toString()));
        } else if (URL.class.equals((Object)columnClass)) {
            this.recordConsumer.addBinary(this.fromURL(value));
        }
    }

    private Binary fromString(Object value) {
        if (value instanceof CharSequence) {
            return Binary.fromCharSequence((CharSequence)((CharSequence)value));
        }
        return Binary.fromCharSequence((CharSequence)value.toString());
    }

    private Binary fromURL(Object value) {
        if (value instanceof URL) {
            return Binary.fromCharSequence((CharSequence)((URL)value).toExternalForm());
        }
        return null;
    }

    private abstract class ListWriter {
        private ListWriter() {
        }

        protected abstract void writeCollection(GroupType var1, DataFrame var2, Collection<?> var3);

        protected abstract void writeObjectArray(GroupType var1, DataFrame var2, Object[] var3);

        protected abstract void startArray();

        protected abstract void endArray();

        public void writeList(GroupType schema, DataFrame dataFrame, Object value) {
            DataFrameWriteSupport.this.recordConsumer.startGroup();
            if (value instanceof Collection) {
                this.writeCollection(schema, dataFrame, (Collection)value);
            } else {
                Class<?> arrayClass = value.getClass();
                Preconditions.checkArgument((boolean)arrayClass.isArray(), (String)("Cannot write unless collection or array: " + arrayClass.getName()));
                this.writeJavaArray(schema, dataFrame, arrayClass, value);
            }
            DataFrameWriteSupport.this.recordConsumer.endGroup();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void writeJavaArray(GroupType schema, DataFrame dataFrame, Class<?> arrayClass, Object value) {
            Class<?> elementClass = arrayClass.getComponentType();
            if (!elementClass.isPrimitive()) {
                this.writeObjectArray(schema, dataFrame, (Object[])value);
                return;
            }
            Class columnClass = dataFrame.getColumnClass(null);
            if (Boolean.class.equals((Object)columnClass)) {
                Preconditions.checkArgument((elementClass == Boolean.TYPE ? 1 : 0) != 0, (String)("Cannot write as boolean array: " + arrayClass.getName()));
                this.writeBooleanArray((boolean[])value);
                return;
            } else if (Integer.class.equals((Object)columnClass)) {
                if (elementClass == Byte.TYPE) {
                    this.writeByteArray((byte[])value);
                    return;
                } else if (elementClass == Character.TYPE) {
                    this.writeCharArray((char[])value);
                    return;
                } else if (elementClass == Short.TYPE) {
                    this.writeShortArray((short[])value);
                    return;
                } else {
                    if (elementClass != Integer.TYPE) throw new IllegalArgumentException("Cannot write as an int array: " + arrayClass.getName());
                    this.writeIntArray((int[])value);
                }
                return;
            } else if (Long.class.equals((Object)columnClass)) {
                Preconditions.checkArgument((elementClass == Long.TYPE ? 1 : 0) != 0, (String)("Cannot write as long array: " + arrayClass.getName()));
                this.writeLongArray((long[])value);
                return;
            } else if (Float.class.equals((Object)columnClass)) {
                Preconditions.checkArgument((elementClass == Float.TYPE ? 1 : 0) != 0, (String)("Cannot write as float array: " + arrayClass.getName()));
                this.writeFloatArray((float[])value);
                return;
            } else {
                if (!Double.class.equals((Object)columnClass)) throw new IllegalArgumentException("Cannot write " + String.valueOf(dataFrame.getColumnClass(null)) + " array: " + arrayClass.getName());
                Preconditions.checkArgument((elementClass == Double.TYPE ? 1 : 0) != 0, (String)("Cannot write as double array: " + arrayClass.getName()));
                this.writeDoubleArray((double[])value);
            }
        }

        protected void writeBooleanArray(boolean[] array) {
            if (array.length > 0) {
                this.startArray();
                for (boolean element : array) {
                    DataFrameWriteSupport.this.recordConsumer.addBoolean(element);
                }
                this.endArray();
            }
        }

        protected void writeByteArray(byte[] array) {
            if (array.length > 0) {
                this.startArray();
                for (byte element : array) {
                    DataFrameWriteSupport.this.recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected void writeShortArray(short[] array) {
            if (array.length > 0) {
                this.startArray();
                for (short element : array) {
                    DataFrameWriteSupport.this.recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected void writeCharArray(char[] array) {
            if (array.length > 0) {
                this.startArray();
                for (char element : array) {
                    DataFrameWriteSupport.this.recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected void writeIntArray(int[] array) {
            if (array.length > 0) {
                this.startArray();
                for (int element : array) {
                    DataFrameWriteSupport.this.recordConsumer.addInteger(element);
                }
                this.endArray();
            }
        }

        protected void writeLongArray(long[] array) {
            if (array.length > 0) {
                this.startArray();
                for (long element : array) {
                    DataFrameWriteSupport.this.recordConsumer.addLong(element);
                }
                this.endArray();
            }
        }

        protected void writeFloatArray(float[] array) {
            if (array.length > 0) {
                this.startArray();
                for (float element : array) {
                    DataFrameWriteSupport.this.recordConsumer.addFloat(element);
                }
                this.endArray();
            }
        }

        protected void writeDoubleArray(double[] array) {
            if (array.length > 0) {
                this.startArray();
                for (double element : array) {
                    DataFrameWriteSupport.this.recordConsumer.addDouble(element);
                }
                this.endArray();
            }
        }
    }
}

