/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import org.lbzip2.Status;

class BitStream {
    long buff;
    int live;
    byte[] ptr;
    int off;
    int len;
    boolean eof;

    BitStream() {
    }

    Status need(int n) {
        while (this.live < n && this.off < this.len) {
            this.live += 8;
            this.buff += ((long)this.ptr[this.off++] & 0xFFL) << 64 - this.live;
        }
        if (this.live >= n) {
            return Status.OK;
        }
        if (this.eof) {
            return Status.FINISH;
        }
        return Status.MORE;
    }

    int peek(int n) {
        return (int)(this.buff >>> 64 - n);
    }

    void dump(int n) {
        this.buff <<= n;
        this.live -= n;
    }

    int take(int n) {
        assert (this.live >= n);
        int x = this.peek(n);
        this.dump(n);
        return x;
    }

    void align() {
        this.dump(this.live % 8);
    }

    void consume() {
        this.dump(this.live);
        this.off = this.len;
    }
}

