/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import org.lbzip2.Constants;
import org.lbzip2.Status;
import org.lbzip2.StreamFormatException;

class Decoder {
    boolean rand;
    int bwt_idx;
    int block_size;
    int crc;
    int[] ftab = new int[256];
    int[] tt = new int[900000];
    private int rle_state;
    private int rle_crc;
    private int rle_index;
    private int rle_avail;
    private int rle_char;
    private int rle_prev;

    Decoder() {
    }

    void decode() {
        int i;
        int j = 0;
        int cum = 0;
        for (i = 0; i < 256; ++i) {
            this.ftab[i] = (cum += this.ftab[i]) - this.ftab[i];
        }
        assert (cum == this.block_size);
        for (i = 0; i < this.block_size; ++i) {
            int uc = this.tt[i] & 0xFF;
            int n = this.ftab[uc];
            this.tt[n] = this.tt[n] + (i << 8);
            int n2 = uc;
            this.ftab[n2] = this.ftab[n2] + 1;
        }
        assert (this.ftab[255] == this.block_size);
        if (this.rand) {
            byte[] block = new byte[this.block_size];
            j = this.tt[this.bwt_idx];
            for (i = 0; i < this.block_size; ++i) {
                j = this.tt[j >> 8];
                block[i] = (byte)j;
            }
            i = 0;
            for (j = 617; j < this.block_size; j += Constants.rand_table[i]) {
                int n = j;
                block[n] = (byte)(block[n] ^ 1);
                i = i + 1 & 0x1FF;
            }
            for (i = 0; i < this.block_size; ++i) {
                this.tt[i] = (i + 1 << 8) + block[i];
            }
        }
        this.rle_state = 0;
        this.rle_crc = -1;
        this.rle_index = this.rand ? 0 : this.tt[this.bwt_idx];
        this.rle_avail = this.block_size;
        this.rle_prev = 0;
        this.rle_char = 0;
    }

    Status emit(byte[] buf, int off, int[] buf_sz) throws StreamFormatException {
        int[] t = this.tt;
        int b = off;
        int m = buf_sz[0];
        int s = this.rle_crc;
        int p = this.rle_index;
        int a = this.rle_avail;
        int c = this.rle_char;
        int d = this.rle_prev;
        switch (this.rle_state) {
            default: {
                throw new IllegalStateException();
            }
            case 1: {
                if (m-- == 0) break;
                buf[b++] = (byte)c;
                s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
                if (c != d || a-- == 0) break;
                p = t[p >> 8];
                c = p & 0xFF;
            }
            case 2: {
                if (m-- == 0) {
                    this.rle_state = 2;
                    break;
                }
                buf[b++] = (byte)c;
                s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
                if (c != d || a-- == 0) break;
                p = t[p >> 8];
                c = p & 0xFF;
            }
            case 3: {
                if (m-- == 0) {
                    this.rle_state = 3;
                    break;
                }
                buf[b++] = (byte)c;
                s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
                if (c != d) break;
                if (a-- == 0) {
                    throw new StreamFormatException("ERR_RUNLEN");
                }
                p = t[p >> 8];
                c = p & 0xFF;
            }
            case 4: {
                if (m < c) {
                    c -= m;
                    while (m-- != 0) {
                        buf[b++] = (byte)d;
                        s = s << 8 ^ Constants.crc_table[s >>> 24 ^ d];
                    }
                    this.rle_state = 4;
                    break;
                }
                m -= c;
                while (c-- != 0) {
                    buf[b++] = (byte)d;
                    s = s << 8 ^ Constants.crc_table[s >>> 24 ^ d];
                }
            }
            case 0: {
                if (a-- == 0) break;
                p = t[p >> 8];
                c = p & 0xFF;
            }
            case 5: {
                if (m-- == 0) {
                    this.rle_state = 5;
                    break;
                }
                buf[b++] = (byte)c;
                s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
            }
        }
        if (a != -1 && m != -1) {
            while (a-- != 0) {
                d = c;
                p = t[p >> 8];
                c = p & 0xFF;
                if (m-- == 0) {
                    this.rle_state = 1;
                    break;
                }
                buf[b++] = (byte)c;
                s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
                if (c != d) {
                    if (a-- == 0) break;
                    d = c;
                    p = t[p >> 8];
                    c = p & 0xFF;
                    if (m-- == 0) {
                        this.rle_state = 1;
                        break;
                    }
                    buf[b++] = (byte)c;
                    s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
                    if (c != d) {
                        if (a-- == 0) break;
                        d = c;
                        p = t[p >> 8];
                        c = p & 0xFF;
                        if (m-- == 0) {
                            this.rle_state = 1;
                            break;
                        }
                        buf[b++] = (byte)c;
                        s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
                        if (c != d) {
                            if (a-- == 0) break;
                            d = c;
                            p = t[p >> 8];
                            c = p & 0xFF;
                            if (m-- == 0) {
                                this.rle_state = 1;
                                break;
                            }
                            buf[b++] = (byte)c;
                            s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
                            if (c != d) continue;
                        }
                    }
                }
                if (a-- == 0) break;
                p = t[p >> 8];
                c = p & 0xFF;
                if (m-- == 0) {
                    this.rle_state = 2;
                    break;
                }
                buf[b++] = (byte)c;
                s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
                if (c != d) continue;
                if (a-- == 0) break;
                p = t[p >> 8];
                c = p & 0xFF;
                if (m-- == 0) {
                    this.rle_state = 3;
                    break;
                }
                buf[b++] = (byte)c;
                s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
                if (c != d) continue;
                if (a-- == 0) {
                    throw new StreamFormatException("ERR_RUNLEN");
                }
                c = (p = t[p >> 8]) & 0xFF;
                if (m < c) {
                    c -= m;
                    while (m-- != 0) {
                        buf[b++] = (byte)d;
                        s = s << 8 ^ Constants.crc_table[s >>> 24 ^ d];
                    }
                    this.rle_state = 4;
                    break;
                }
                m -= c;
                while (c-- != 0) {
                    buf[b++] = (byte)d;
                    s = s << 8 ^ Constants.crc_table[s >>> 24 ^ d];
                }
                if (a-- == 0) break;
                p = t[p >> 8];
                c = p & 0xFF;
                if (m-- == 0) {
                    this.rle_state = 5;
                    break;
                }
                buf[b++] = (byte)c;
                s = s << 8 ^ Constants.crc_table[s >>> 24 ^ c];
            }
        }
        assert (a == -1 != (m == -1));
        this.rle_avail = a;
        if (m == -1) {
            assert (a != -1);
            this.rle_index = p;
            this.rle_char = c;
            this.rle_prev = d;
            this.rle_crc = s;
            buf_sz[0] = 0;
            return Status.MORE;
        }
        assert (a == -1);
        this.crc = ~s;
        buf_sz[0] = m;
        return Status.OK;
    }
}

