/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import org.lbzip2.BitStream;
import org.lbzip2.Header;
import org.lbzip2.Status;
import org.lbzip2.StreamFormatException;

class Parser {
    State state = State.BLOCK_MAGIC_1;
    int bs100k;
    int stored_crc;
    int computed_crc;

    public Parser(int my_bs100k) {
        this.bs100k = my_bs100k;
        this.computed_crc = 0;
    }

    Status parse(Header hd, BitStream bs, int[] garbage) throws StreamFormatException {
        assert (this.state != State.ACCEPT);
        block13: while (Status.OK == bs.need(16)) {
            int word = bs.peek(16);
            bs.dump(16);
            switch (this.state) {
                case STREAM_MAGIC_1: {
                    if (16986 != word) {
                        hd.bs100k = -1;
                        hd.crc = 0;
                        this.state = State.ACCEPT;
                        garbage[0] = 16;
                        return Status.FINISH;
                    }
                    this.state = State.STREAM_MAGIC_2;
                    continue block13;
                }
                case STREAM_MAGIC_2: {
                    if (26681 < word || 26673 > word) {
                        hd.bs100k = -1;
                        hd.crc = 0;
                        this.state = State.ACCEPT;
                        garbage[0] = 32;
                        return Status.FINISH;
                    }
                    this.bs100k = word & 0xF;
                    this.state = State.BLOCK_MAGIC_1;
                    continue block13;
                }
                case BLOCK_MAGIC_1: {
                    if (6002 == word) {
                        this.state = State.EOS_2;
                        continue block13;
                    }
                    if (12609 != word) {
                        throw new StreamFormatException("ERR_HEADER");
                    }
                    this.state = State.BLOCK_MAGIC_2;
                    continue block13;
                }
                case BLOCK_MAGIC_2: {
                    if (22822 != word) {
                        throw new StreamFormatException("ERR_HEADER");
                    }
                    this.state = State.BLOCK_MAGIC_3;
                    continue block13;
                }
                case BLOCK_MAGIC_3: {
                    if (21337 != word) {
                        throw new StreamFormatException("ERR_HEADER");
                    }
                    this.state = State.BLOCK_CRC_1;
                    continue block13;
                }
                case BLOCK_CRC_1: {
                    this.stored_crc = word;
                    this.state = State.BLOCK_CRC_2;
                    continue block13;
                }
                case BLOCK_CRC_2: {
                    hd.crc = this.stored_crc << 16 | word;
                    hd.bs100k = this.bs100k;
                    this.computed_crc = this.computed_crc << 1 ^ this.computed_crc >>> 31 ^ hd.crc;
                    this.state = State.BLOCK_MAGIC_1;
                    return Status.OK;
                }
                case EOS_2: {
                    if (17720 != word) {
                        throw new StreamFormatException("ERR_HEADER");
                    }
                    this.state = State.EOS_3;
                    continue block13;
                }
                case EOS_3: {
                    if (20624 != word) {
                        throw new StreamFormatException("ERR_HEADER");
                    }
                    this.state = State.EOS_CRC_1;
                    continue block13;
                }
                case EOS_CRC_1: {
                    this.stored_crc = word;
                    this.state = State.EOS_CRC_2;
                    continue block13;
                }
                case EOS_CRC_2: {
                    this.stored_crc = this.stored_crc << 16 | word;
                    if (this.stored_crc != this.computed_crc) {
                        throw new StreamFormatException("ERR_STRMCRC");
                    }
                    this.computed_crc = 0;
                    bs.align();
                    this.state = State.STREAM_MAGIC_1;
                    continue block13;
                }
            }
            throw new IllegalStateException();
        }
        if (Status.FINISH != bs.need(16)) {
            return Status.MORE;
        }
        if (this.state == State.STREAM_MAGIC_1) {
            this.state = State.ACCEPT;
            garbage[0] = 0;
            return Status.FINISH;
        }
        if (this.state == State.STREAM_MAGIC_2) {
            this.state = State.ACCEPT;
            garbage[0] = 16;
            return Status.FINISH;
        }
        throw new StreamFormatException("ERR_EOF");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        STREAM_MAGIC_1,
        STREAM_MAGIC_2,
        BLOCK_MAGIC_1,
        BLOCK_MAGIC_2,
        BLOCK_MAGIC_3,
        BLOCK_CRC_1,
        BLOCK_CRC_2,
        EOS_2,
        EOS_3,
        EOS_CRC_1,
        EOS_CRC_2,
        ACCEPT;

    }
}

