/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import org.lbzip2.Constants;

final class Utils {
    static final int ilog2(int n) {
        return (n & 0xFFFF0000) != 0 ? ((n & 0xFF000000) != 0 ? 24 + Constants.lg_table[n >> 24 & 0xFF] : 16 + Constants.lg_table[n >> 16 & 0xFF]) : ((n & 0xFF00) != 0 ? 8 + Constants.lg_table[n >> 8 & 0xFF] : 0 + Constants.lg_table[n >> 0 & 0xFF]);
    }

    static final int ilog2_16(int n) {
        return (n & 0xFF00) != 0 ? 8 + Constants.lg_table[n >> 8 & 0xFF] : 0 + Constants.lg_table[n >> 0 & 0xFF];
    }

    static final int isqrt(int x, int n) {
        int y;
        int e;
        if (x >= n * n) {
            return n;
        }
        int n2 = (x & 0xFFFF0000) != 0 ? ((x & 0xFF000000) != 0 ? 24 + Constants.lg_table[x >> 24 & 0xFF] : 16 + Constants.lg_table[x >> 16 & 0xFF]) : (e = (x & 0xFF00) != 0 ? 8 + Constants.lg_table[x >> 8 & 0xFF] : 0 + Constants.lg_table[x >> 0 & 0xFF]);
        if (e >= 16) {
            y = Constants.sqq_table[x >> e - 6 - (e & 1)] << (e >> 1) - 7;
            if (e >= 24) {
                y = y + 1 + x / y >> 1;
            }
            y = y + 1 + x / y >> 1;
        } else if (e >= 8) {
            y = (Constants.sqq_table[x >> e - 6 - (e & 1)] >> 7 - (e >> 1)) + 1;
        } else {
            return Constants.sqq_table[x] >> 4;
        }
        return x < y * y ? y - 1 : y;
    }

    static void insertion_sort(long[] P, int first, int last) {
        for (int a = first + 1; a < last; ++a) {
            int b1 = a;
            long t = P[b1];
            int b = b1 - 1;
            while (P[b] < t) {
                P[b1] = P[b];
                if ((b1 = b--) == first) break;
            }
            P[b1] = t;
        }
    }

    static int med3(int a, int b, int c) {
        int d = Math.max(a, b);
        int e = Math.min(a, b);
        int f = Math.max(e, c);
        int g = Math.min(d, f);
        return g;
    }

    static long med3(long a, long b, long c) {
        long d = Math.max(a, b);
        long e = Math.min(a, b);
        long f = Math.max(e, c);
        long g = Math.min(d, f);
        return g;
    }

    static int med5(int a, int b, int c, int d, int e) {
        int f = Math.max(a, b);
        int g = Math.min(a, b);
        int h = Math.max(c, d);
        int i = Math.min(c, d);
        int j = Math.max(f, h);
        int k = Math.max(g, e);
        int l = Math.min(f, h);
        int m = Math.min(g, e);
        int n = Math.min(j, k);
        int o = Math.max(l, i);
        int p = Math.min(l, i);
        int q = Math.min(n, o);
        int r = Math.max(p, m);
        int s = Math.max(q, r);
        return s;
    }

    static long med5(long a, long b, long c, long d, long e) {
        long f = Math.max(a, b);
        long g = Math.min(a, b);
        long h = Math.max(c, d);
        long i = Math.min(c, d);
        long j = Math.max(f, h);
        long k = Math.max(g, e);
        long l = Math.min(f, h);
        long m = Math.min(g, e);
        long n = Math.min(j, k);
        long o = Math.max(l, i);
        long p = Math.min(l, i);
        long q = Math.min(n, o);
        long r = Math.max(p, m);
        long s = Math.max(q, r);
        return s;
    }

    private Utils() {
    }
}

