/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonAdapter;
import com.macrofocus.button.ButtonEvent;
import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.ButtonView;
import com.macrofocus.color.ColorModel;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.awt.DrawingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;

public class BubbleStateButtonView
extends ButtonView {
    private boolean _stateActive = false;
    private final int SHIFT = 12;
    private int screenWidth;
    private int screenHeight;
    private final ButtonModel buttonModel;
    private String label;
    private int minimumWidth;
    private int minimumHeight;
    private int maximumWidth;
    private Color backgroundColor;
    private Color markerColor;
    private Color textColor = Color.white;
    private Font font = new Font("Helvetica", 0, 12);
    private final PropertiesModel propertiesModel;
    private JComponent bubble;

    public BubbleStateButtonView(final ButtonModel buttonModel, String label, final PropertiesModel propertiesModel, boolean registerMouseListener) {
        this.buttonModel = buttonModel;
        this.label = label;
        this.propertiesModel = propertiesModel;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                BubbleStateButtonView.this.updateProperties(propertiesModel);
                BubbleStateButtonView.this.repaint();
            }
        });
        this.setOpaque(true);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
        this.minimumWidth = fontMetrics.stringWidth(label.substring(0, 1));
        this.maximumWidth = fontMetrics.stringWidth(label) + 12;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BubbleStateButtonView.this.updateScreenValues();
                BubbleStateButtonView.this.repaint();
            }
        });
        if (registerMouseListener) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    buttonModel.setSelected(this);
                }
            });
        }
        buttonModel.addButtonListener(new ButtonAdapter(){

            @Override
            public void buttonSelected(ButtonEvent e) {
                BubbleStateButtonView.this.repaint();
            }

            @Override
            public void buttonStateChanged(ButtonEvent event) {
                BubbleStateButtonView.this.repaint();
            }
        });
        if (registerMouseListener) {
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (BubbleStateButtonView.this.isEnabled()) {
                        BubbleStateButtonView.this.enableBubble(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    BubbleStateButtonView.this.enableBubble(false);
                }
            };
            this.addMouseListener(mouseListener);
        }
    }

    public void setLabel(String label) {
        if (!this.label.equals(label)) {
            this.label = label;
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
            this.minimumWidth = fontMetrics.stringWidth(label.substring(0, 1));
            this.maximumWidth = fontMetrics.stringWidth(label) + 12;
            if (this.bubble != null) {
                if (this.bubble.isVisible()) {
                    this.bubble.setVisible(false);
                }
                this.bubble = null;
            }
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void enableBubble(boolean isEnabled) {
        if (isEnabled && this.isShowing()) {
            this.setBackground(this.backgroundColor.brighter());
            Point scrnLoc = this.getLocationOnScreen();
            Dimension size = this.getSize();
            if (size.width < this.maximumWidth) {
                if (this.bubble == null) {
                    this.bubble = new BubbleStateButtonView(this.buttonModel, this.label, this.propertiesModel, false);
                    this.bubble.setBackground(this.getBackground());
                    JLayeredPane layeredPane = SwingHelper.getTopLayeredPane((Component)this);
                    layeredPane.add(this.bubble, JLayeredPane.POPUP_LAYER, 0);
                }
                Container parent = this.bubble.getParent();
                Point p = SwingHelper.convertScreenLocationToParent((Container)parent, (int)scrnLoc.x, (int)scrnLoc.y);
                Dimension d = this.bubble.getPreferredSize();
                if (p.x + d.width > parent.getWidth()) {
                    p.x = parent.getWidth() - d.width;
                }
                this.bubble.setLocation(p);
                this.bubble.setSize(d);
                this.bubble.setVisible(true);
            }
        } else {
            this.setBackground(this.backgroundColor);
            if (this.bubble != null && this.bubble.isVisible()) {
                this.bubble.setVisible(false);
                JLayeredPane layeredPane = SwingHelper.getTopLayeredPane((Component)this);
                layeredPane.remove(this.bubble);
                this.bubble = null;
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.buttonModel.isStateOn()) {
            g.setColor(this.backgroundColor);
            DrawingTools.drawThin3DRect(2, 2, 6, this.screenHeight - 4, false, g, this.backgroundColor);
        } else {
            g.setColor(this.backgroundColor);
            DrawingTools.drawThin3DRect(2, 2, 6, this.screenHeight - 4, true, g, this.backgroundColor);
            g.setColor(this.markerColor);
            g.fillRect(4, 4, 2, this.screenHeight - 8);
        }
        g.setFont(this.font);
        FontMetrics fontMetrics = g.getFontMetrics();
        g.setColor(this.textColor);
        int x = this.screenWidth < this.maximumWidth ? 0 : 0;
        g.drawString(this.label, x + 12, fontMetrics.getMaxAscent());
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.maximumWidth, this.minimumHeight);
    }

    protected void updateScreenValues() {
        Dimension size = this.getSize();
        this.screenWidth = size.width;
        this.screenHeight = size.height;
    }

    public void setBackgroundColor(Color background_color) {
        this.backgroundColor = background_color;
        this.setBackground(this.backgroundColor);
        this.repaint();
    }

    public void setTextColor(Color text_color) {
        this.textColor = text_color;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "backgroundColor")).getColor();
        this.setBackground(this.backgroundColor);
        this.textColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "textColor")).getColor();
        this.markerColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "markerColor")).getColor();
        this.font = UIManager.getFont("TableHeader.font");
    }

    protected int getMaximumWidth() {
        return this.maximumWidth;
    }

    protected Color getBackgroundColor() {
        return this.backgroundColor;
    }
}

