/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.swing;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.combobox.ColorExComboBox;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellEditorFactory;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.ColorCellEditor;
import com.jidesoft.grid.ColorCellRenderer;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormap.editor.AbstractCustomColorMapEditor;
import com.macrofocus.colormap.swing.ColormapView;
import com.macrofocus.colormap.swing.ComboBoxCellEditor;
import com.macrofocus.colormap.swing.ExportColormapView;
import com.macrofocus.combobox.MColorComboBox;
import com.macrofocus.combobox.MJYComboBox;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.format.CPFormat;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.palette.CustomPalette;
import com.macrofocus.palette.InterpolatedPalette;
import com.macrofocus.palette.PaletteEvent;
import com.macrofocus.palette.PaletteListener;
import com.macrofocus.util.swing.spinner.EnhancedSlider;
import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.ColorComboBoxEditor;
import de.javasoft.combobox.controls.ColorComboBoxRenderer;
import de.javasoft.combobox.controls.ColorPopupPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.OverlayLayout;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class SwingCustomColorMapEditor
extends AbstractCustomColorMapEditor<JComponent, Color> {
    private EditorContext editorContext = new EditorContext("CustomColorMapEditor");
    private JPanel mainPanel;
    private JButton generateColorsButton;
    private JRadioButton bandsRadioButton;
    private JRadioButton rampsRadioButton;
    private MColorComboBox underflowColor;
    private MColorComboBox overflowColor;
    private MColorComboBox missingValueColor;
    private JTable table;
    private JPanel colorMapPreviewContainer;
    private EnhancedSlider brightnessSlider;
    private EnhancedSlider saturationSlider;
    private JCheckBox overColorCheckBox;
    private JCheckBox underColorCheckBox;
    private final ColormapView colormapView;
    final ItemListener underItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (SwingCustomColorMapEditor.this.underflowColor.getSelectedColor() != null) {
                SwingCustomColorMapEditor.this.colorMap.setUnderColor((CPColor)new SwingColor(SwingCustomColorMapEditor.this.underflowColor.getSelectedColor()));
            } else {
                SwingCustomColorMapEditor.this.colorMap.setUnderColor(null);
            }
        }
    };
    final ItemListener overItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (SwingCustomColorMapEditor.this.overflowColor.getSelectedColor() != null) {
                SwingCustomColorMapEditor.this.colorMap.setOverColor((CPColor)new SwingColor(SwingCustomColorMapEditor.this.overflowColor.getSelectedColor()));
            } else {
                SwingCustomColorMapEditor.this.colorMap.setOverColor(null);
            }
        }
    };
    final ItemListener nullItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (SwingCustomColorMapEditor.this.missingValueColor.getSelectedColor() != null) {
                SwingCustomColorMapEditor.this.colorMap.setNullColor((CPColor)new SwingColor(SwingCustomColorMapEditor.this.missingValueColor.getSelectedColor()));
            } else {
                SwingCustomColorMapEditor.this.colorMap.setNullColor(null);
            }
        }
    };
    final PaletteListener paletteListener = new PaletteListener(){

        public void paletteChanged(PaletteEvent event) {
            SwingCustomColorMapEditor.this.updateUnderOverEnabled();
        }
    };

    public SwingCustomColorMapEditor(boolean includeLedend, boolean expertMode) {
        this.$$$setupUI$$$();
        this.underflowColor.addItemListener(this.underItemListener);
        this.overflowColor.addItemListener(this.overItemListener);
        this.missingValueColor.addItemListener(this.nullItemListener);
        this.underColorCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!SwingCustomColorMapEditor.this.underColorCheckBox.isSelected()) {
                    SwingCustomColorMapEditor.this.colorMap.setUnderColor(null);
                }
            }
        });
        this.overColorCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!SwingCustomColorMapEditor.this.overColorCheckBox.isSelected()) {
                    SwingCustomColorMapEditor.this.colorMap.setOverColor(null);
                }
            }
        });
        this.bandsRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((CustomPalette)SwingCustomColorMapEditor.this.colorMap.getPalette()).setMode(CustomPalette.Mode.Bands);
            }
        });
        this.rampsRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((CustomPalette)SwingCustomColorMapEditor.this.colorMap.getPalette()).setMode(CustomPalette.Mode.Ramps);
            }
        });
        this.brightnessSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingCustomColorMapEditor.this.colorMap.setBrightness(SwingCustomColorMapEditor.this.brightnessSlider.getValue());
            }
        });
        this.saturationSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingCustomColorMapEditor.this.colorMap.setSaturation(SwingCustomColorMapEditor.this.saturationSlider.getValue());
            }
        });
        this.colorMapPreviewContainer.setLayout(new OverlayLayout(this.colorMapPreviewContainer));
        this.colormapView = new ExportColormapView(expertMode);
        if (includeLedend) {
            this.colorMapPreviewContainer.add((Component)this.colormapView);
        }
    }

    public JPanel getNativeComponent() {
        return this.mainPanel;
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public void setColorMap(MutableColorMap<Color> colorMap, Class valueType, Number min, Number max, CPFormat format) {
        if (this.colorMap != null) {
            this.colorMap.getPalette().removePaletteListener(this.paletteListener);
        }
        this.colorMap = colorMap;
        this.min = min;
        this.max = max;
        if (valueType != null && Number.class.isAssignableFrom(valueType)) {
            valueType = Double.class;
        }
        if (this.colorMap != null) {
            this.colorMap.getPalette().addPaletteListener(this.paletteListener);
            this.updateUnderOverEnabled();
            this.underColorCheckBox.setSelected(colorMap.isUnderflowColorSet());
            this.overColorCheckBox.setSelected(colorMap.isOverflowColorSet());
            this.underflowColor.setSelectedColor(colorMap.getUnderflowColor() != null ? (Color)colorMap.getUnderflowColor().getNativeColor() : null);
            this.overflowColor.setSelectedColor(colorMap.getOverflowColor() != null ? (Color)colorMap.getOverflowColor().getNativeColor() : null);
            this.underflowColor.setEnabled(colorMap.isUnderflowColorSet());
            this.overflowColor.setEnabled(colorMap.isOverflowColorSet());
            this.missingValueColor.setSelectedColor(colorMap.getNullColor() != null ? (Color)colorMap.getNullColor().getNativeColor() : null);
            this.bandsRadioButton.setSelected(((CustomPalette)colorMap.getPalette()).getMode() == CustomPalette.Mode.Bands);
            this.rampsRadioButton.setSelected(((CustomPalette)colorMap.getPalette()).getMode() == CustomPalette.Mode.Ramps);
            this.brightnessSlider.setValue(colorMap.getBrightness());
            this.saturationSlider.setValue(colorMap.getSaturation());
            this.table.setModel(new ColorsTableModel((CustomPalette<Color>)((CustomPalette)colorMap.getPalette()), valueType, min, max));
            if (this.table instanceof SortableTable) {
                ((SortableTableModel)this.table.getModel()).setAutoResort(true);
                ((SortableTableModel)this.table.getModel()).setMultiColumnSortable(false);
                ((SortableTableModel)this.table.getModel()).sortColumn(0, true, false);
            } else {
                TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
                this.table.setRowSorter(sorter);
                ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(1);
                sortKeys.add(new RowSorter.SortKey(0, SortOrder.DESCENDING));
                sorter.setSortKeys(sortKeys);
            }
            this.colormapView.setColorMap(colorMap, min, max, format);
        }
    }

    private void createUIComponents() {
        this.table = new JTable();
        ColorCellRenderer colorCellRenderer = new ColorCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value != null) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (component instanceof ColorExComboBox) {
                        ((ColorExComboBox)component).setColorValueVisible(false);
                    }
                    return component;
                }
                return null;
            }
        };
        colorCellRenderer.setColorValueVisible(false);
        if (this.table instanceof SortableTable) {
            CellRendererManager.registerRenderer(Color.class, (TableCellRenderer)colorCellRenderer, (EditorContext)this.editorContext);
        } else {
            this.table.setDefaultRenderer(Color.class, (TableCellRenderer)colorCellRenderer);
        }
        if (this.table instanceof SortableTable) {
            CellEditorManager.registerEditor(Color.class, (CellEditorFactory)new CellEditorFactory(){

                public CellEditor create() {
                    ColorCellEditor editor = new ColorCellEditor(){

                        protected void customizeExComboBox() {
                            super.customizeExComboBox();
                            this.getComboBox().setEditable(false);
                            ((ColorExComboBox)this.getComboBox()).setColorIconVisible(true);
                            ((ColorExComboBox)this.getComboBox()).setColorValueVisible(false);
                        }
                    };
                    return editor;
                }
            }, (EditorContext)this.editorContext);
        } else {
            final MJYComboBox jyComboBox = new MJYComboBox();
            ColorPopupPanel colorPopup = new ColorPopupPanel((JYComboBox)jyComboBox);
            colorPopup.setNonColorButtonVisible(false);
            jyComboBox.setPopupComponent((JComponent)colorPopup);
            ColorComboBoxRenderer renderer = new ColorComboBoxRenderer(jyComboBox.getRenderer());
            jyComboBox.setRenderer((ListCellRenderer)renderer);
            jyComboBox.setEditor((ComboBoxEditor)new ColorComboBoxEditor(jyComboBox.getEditor(), null, true, false));
            this.table.setDefaultEditor(Color.class, (TableCellEditor)new ComboBoxCellEditor((JComboBox)((Object)jyComboBox)){

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    jyComboBox.setEditable(true);
                    Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    jyComboBox.setEditable(false);
                    return component;
                }
            });
        }
        this.brightnessSlider = new EnhancedSlider();
        this.brightnessSlider.setMinimum(-150);
        this.brightnessSlider.setMaximum(150);
        this.saturationSlider = new EnhancedSlider();
        this.saturationSlider.setMinimum(-150);
        this.saturationSlider.setMaximum(150);
    }

    private void updateUnderOverEnabled() {
        TreeSet entries = (TreeSet)((CustomPalette)this.colorMap.getPalette()).getEntries();
        this.underColorCheckBox.setEnabled(this.min != null && (entries.isEmpty() || ((CustomPalette.Entry)entries.first()).getFraction() > 0.0));
        this.overColorCheckBox.setEnabled(this.max != null && (entries.isEmpty() || ((CustomPalette.Entry)entries.last()).getFraction() < 1.0));
        this.underflowColor.setEnabled(this.underColorCheckBox.isEnabled());
        this.overflowColor.setEnabled(this.overColorCheckBox.isEnabled());
        this.underflowColor.setSelectedColor(this.colorMap.getUnderflowColor() != null ? (Color)this.colorMap.getUnderflowColor().getNativeColor() : null);
        this.overflowColor.setSelectedColor(this.colorMap.getOverflowColor() != null ? (Color)this.colorMap.getOverflowColor().getNativeColor() : null);
    }

    public ColormapView getLegend() {
        return this.colormapView;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.setOpaque(false);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.setOpaque(false);
        panel1.setVisible(false);
        this.mainPanel.add((Component)panel1, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, false));
        this.generateColorsButton = new JButton();
        this.generateColorsButton.setEnabled(false);
        this.generateColorsButton.setText("Generate Colors...");
        this.generateColorsButton.setVisible(false);
        panel1.add((Component)this.generateColorsButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        this.mainPanel.add((Component)scrollPane1, new GridConstraints(1, 0, 1, 2, 0, 3, 5, 3, new Dimension(0, -1), null, null, 0, false));
        this.table.setPreferredScrollableViewportSize(new Dimension(450, 150));
        scrollPane1.setViewportView(this.table);
        this.underColorCheckBox = new JCheckBox();
        this.underColorCheckBox.setText("Underflow Color:");
        this.mainPanel.add((Component)this.underColorCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.underflowColor = new MColorComboBox();
        this.mainPanel.add((Component)this.underflowColor, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Missing Value Color: ");
        this.mainPanel.add((Component)label1, new GridConstraints(7, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.missingValueColor = new MColorComboBox();
        this.mainPanel.add((Component)this.missingValueColor, new GridConstraints(7, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), null, null, 0, false));
        this.overColorCheckBox = new JCheckBox();
        this.overColorCheckBox.setText("Overflow Color: ");
        this.mainPanel.add((Component)this.overColorCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.overflowColor = new MColorComboBox();
        this.mainPanel.add((Component)this.overflowColor, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        panel2.setOpaque(false);
        this.mainPanel.add((Component)panel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 0, null, null, null, 1, false));
        Spacer spacer2 = new Spacer();
        panel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 5, 1, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel3.setOpaque(false);
        panel2.add((Component)panel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, new Dimension(0, -1), null, null, 0, false));
        this.bandsRadioButton = new JRadioButton();
        this.bandsRadioButton.setText("Steps");
        panel3.add((Component)this.bandsRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.rampsRadioButton = new JRadioButton();
        this.rampsRadioButton.setText("Ramps");
        panel3.add((Component)this.rampsRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Brightness:");
        this.mainPanel.add((Component)label2, new GridConstraints(3, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.mainPanel.add((Component)this.brightnessSlider, new GridConstraints(3, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Saturation:");
        this.mainPanel.add((Component)label3, new GridConstraints(4, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.saturationSlider.setMaximum(150);
        this.saturationSlider.setMinimum(-150);
        this.saturationSlider.setValue(0);
        this.mainPanel.add((Component)this.saturationSlider, new GridConstraints(4, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.mainPanel.add((Component)spacer3, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.colorMapPreviewContainer = new JPanel();
        this.colorMapPreviewContainer.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(2, 5, 3, 5), -1, -1));
        this.colorMapPreviewContainer.setOpaque(false);
        this.mainPanel.add((Component)this.colorMapPreviewContainer, new GridConstraints(9, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.bandsRadioButton);
        buttonGroup.add(this.rampsRadioButton);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private class ColorsTableModel
    extends AbstractTableModel
    implements ContextSensitiveTableModel {
        private final CustomPalette<Color> palette;
        private final Class valueType;
        private Number min;
        private Number max;

        private ColorsTableModel(CustomPalette<Color> palette, Class valueType, Number min, Number max) {
            this.palette = palette;
            this.valueType = valueType;
            this.min = min;
            this.max = max;
            palette.addPaletteListener(new PaletteListener(){

                public void paletteChanged(PaletteEvent event) {
                    ColorsTableModel.this.fireTableDataChanged();
                }
            });
        }

        @Override
        public int getRowCount() {
            return this.getCustomPalette().getEntries().size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Threshold";
                }
                case 1: {
                    return "Color";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.valueType;
                }
                case 1: {
                    return Color.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1 && this.getCustomPalette().getMode() == CustomPalette.Mode.Bands && rowIndex == this.getCustomPalette().getEntries().size() - 1) {
                return false;
            }
            return rowIndex < this.getCustomPalette().getEntries().size() || columnIndex == 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    double fraction = this.getEntry(rowIndex).getFraction();
                    if (!Double.isNaN(fraction)) {
                        return this.getAbsolute(fraction);
                    }
                    return null;
                }
                case 1: {
                    if (this.getCustomPalette().getMode() == CustomPalette.Mode.Bands && rowIndex == this.getCustomPalette().getEntries().size() - 1) {
                        return new InterpolatedPalette.Entry(Double.NaN, SwingFactory.getInstance().createRGBAColor(255, 255, 255, 0));
                    }
                    return this.getEntry(rowIndex).getColor().getNativeColor();
                }
            }
            return null;
        }

        private double getAbsolute(double fraction) {
            if (this.min != null && this.max != null) {
                return this.min.doubleValue() + fraction * (this.max.doubleValue() - this.min.doubleValue());
            }
            return fraction;
        }

        private CustomPalette.Entry<Color> getEntry(int rowIndex) {
            if (rowIndex < this.getCustomPalette().getEntries().size()) {
                return (CustomPalette.Entry)this.getCustomPalette().getEntries().toArray()[rowIndex];
            }
            return new CustomPalette.Entry(Double.NaN, SwingFactory.getInstance().createRGBAColor(255, 255, 255, 0));
        }

        private CustomPalette<Color> getCustomPalette() {
            return this.palette;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    CustomPalette.Entry<Color> entry = this.getEntry(rowIndex);
                    this.getCustomPalette().setColor(entry.getFraction(), null);
                    if (aValue == null || !(aValue instanceof Number) && !(aValue instanceof Date)) break;
                    double value = aValue instanceof Date ? (double)((Date)aValue).getTime() : ((Number)aValue).doubleValue();
                    double fraction = (value - this.min.doubleValue()) / (this.max.doubleValue() - this.min.doubleValue());
                    if (!Double.isNaN(entry.getFraction())) {
                        this.getCustomPalette().setColor(fraction, entry.getColor());
                        break;
                    }
                    CPColor newColor = this.getCustomPalette().getColor(value);
                    if (newColor != null) {
                        this.getCustomPalette().setColor(fraction, newColor);
                        break;
                    }
                    this.getCustomPalette().setColor(fraction, entry.getColor());
                    break;
                }
                case 1: {
                    this.getCustomPalette().setColor(this.getEntry(rowIndex).getFraction(), (CPColor)new SwingColor((Color)aValue));
                }
            }
        }

        public ConverterContext getConverterContextAt(int i, int i1) {
            return null;
        }

        public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
            return SwingCustomColorMapEditor.this.editorContext;
        }

        public Class<?> getCellClassAt(int rowIndex, int columnIndex) {
            return this.getColumnClass(columnIndex);
        }
    }
}

