/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.swing;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.colormap.ColorMap;
import com.macrofocus.colormap.ColorMapEvent;
import com.macrofocus.colormap.ColorMapListener;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormap.editor.AbstractPredefinedColorMapEditor;
import com.macrofocus.colormap.swing.ColormapView;
import com.macrofocus.colormap.swing.ExportColormapView;
import com.macrofocus.colormap.swing.SwingPaletteView;
import com.macrofocus.combobox.MColorComboBox;
import com.macrofocus.combobox.MainJYComboBox;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.swing.MJSpinner;
import com.macrofocus.format.CPFormat;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.palette.FixedPalette;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.Palette;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.macrofocus.util.swing.spinner.EnhancedSlider;
import de.javasoft.syntheticaaddons.DropDownButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.OverlayLayout;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class SwingPredefinedColorMapEditor
extends AbstractPredefinedColorMapEditor<JComponent, Color> {
    private JPanel mainPanel;
    private DropDownButton setToFullRangeButton;
    private JSpinner maximumSpinner;
    private JSpinner minimumSpinner;
    private MColorComboBox underflowColor;
    private MColorComboBox missingValueColor;
    private MColorComboBox overflowColor;
    private MainJYComboBox paletteComboBox;
    private JPanel colorMapPreviewContainer;
    private JCheckBox numberOfStepsCheckBox;
    private JCheckBox invertedCheckBox;
    private JSpinner numberOfStepsSpinner;
    private JCheckBox underColorCheckBox;
    private JCheckBox overColorCheckBox;
    private EnhancedSlider brightnessSlider;
    private EnhancedSlider saturationSlider;
    private JPanel minMaxPanel;
    private JPanel optionsPanel;
    private JScrollPane optionsScrollPane;
    private final ColormapView colormapView;
    private final WeakActionListeners actionListeners = new WeakActionListeners();
    final ItemListener underItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            SwingPredefinedColorMapEditor.this.colorMap.setUnderColor((CPColor)(SwingPredefinedColorMapEditor.this.underflowColor.getSelectedColor() != null ? new SwingColor(SwingPredefinedColorMapEditor.this.underflowColor.getSelectedColor()) : null));
        }
    };
    final ItemListener overItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            SwingPredefinedColorMapEditor.this.colorMap.setOverColor((CPColor)(SwingPredefinedColorMapEditor.this.overflowColor.getSelectedColor() != null ? new SwingColor(SwingPredefinedColorMapEditor.this.overflowColor.getSelectedColor()) : null));
        }
    };
    final ItemListener nullItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            SwingPredefinedColorMapEditor.this.colorMap.setNullColor((CPColor)(SwingPredefinedColorMapEditor.this.missingValueColor.getSelectedColor() != null ? new SwingColor(SwingPredefinedColorMapEditor.this.missingValueColor.getSelectedColor()) : null));
        }
    };
    final IntervalListener intervalListener = new IntervalListener(){

        public void intervalChanged(IntervalEvent event) {
            SwingPredefinedColorMapEditor.this.updateUnderOverEnabled();
        }
    };
    private final ColorMapListener colorMapListener = new ColorMapListener(){

        public void colorMapChanged(ColorMapEvent event) {
            SwingPredefinedColorMapEditor.this.updateView();
        }
    };
    private static Method $$$cachedGetBundleMethod$$$ = null;

    public JPanel getNativeComponent() {
        return this.mainPanel;
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public SwingPredefinedColorMapEditor(boolean includeLedend, boolean expertMode) {
        this.$$$setupUI$$$();
        PaletteListCellRenderer colormapListCellRenderer = new PaletteListCellRenderer();
        this.paletteComboBox.setRenderer(colormapListCellRenderer);
        this.paletteComboBox.setEditable(false);
        this.paletteComboBox.setStretchToFit(true);
        ArrayList<FixedPalette> palettes = new ArrayList<FixedPalette>();
        for (PaletteFactory.Entry entry : SwingPaletteFactory.getInstance().getEntries()) {
            if (entry.getType() == PaletteFactory.Type.QUALITATIVE) continue;
            palettes.add(entry.getPalette());
        }
        SimpleSingleSelection paletteSelection = new SimpleSingleSelection();
        this.paletteComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel((MutableSingleSelection)paletteSelection, palettes));
        paletteSelection.addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<MutablePalette>(){

            public void selectionChanged(SingleSelectionEvent<MutablePalette> paletteSingleSelectionEvent) {
                SwingPredefinedColorMapEditor.this.colorMap.setPalette((MutablePalette)paletteSingleSelectionEvent.getCurrentSelection());
            }
        });
        this.underflowColor.addItemListener(this.underItemListener);
        this.overflowColor.addItemListener(this.overItemListener);
        this.missingValueColor.addItemListener(this.nullItemListener);
        this.underColorCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!SwingPredefinedColorMapEditor.this.underColorCheckBox.isSelected()) {
                    SwingPredefinedColorMapEditor.this.colorMap.setUnderColor(null);
                }
            }
        });
        this.overColorCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!SwingPredefinedColorMapEditor.this.overColorCheckBox.isSelected()) {
                    SwingPredefinedColorMapEditor.this.colorMap.setOverColor(null);
                }
            }
        });
        this.minimumSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object value = SwingPredefinedColorMapEditor.this.minimumSpinner.getValue();
                if (value instanceof Date) {
                    SwingPredefinedColorMapEditor.this.colorMap.getInterval().setStart((double)((Date)value).getTime());
                } else {
                    SwingPredefinedColorMapEditor.this.colorMap.getInterval().setStart(((Number)value).doubleValue());
                }
            }
        });
        this.maximumSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object value = SwingPredefinedColorMapEditor.this.maximumSpinner.getValue();
                if (value instanceof Date) {
                    SwingPredefinedColorMapEditor.this.colorMap.getInterval().setEnd((double)((Date)value).getTime());
                } else {
                    SwingPredefinedColorMapEditor.this.colorMap.getInterval().setEnd(((Number)value).doubleValue());
                }
            }
        });
        this.setToFullRangeButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingPredefinedColorMapEditor.this.minimumSpinner.setValue(SwingPredefinedColorMapEditor.this.min);
                SwingPredefinedColorMapEditor.this.maximumSpinner.setValue(SwingPredefinedColorMapEditor.this.max);
            }
        }, (Object)this.setToFullRangeButton));
        this.numberOfStepsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingPredefinedColorMapEditor.this.numberOfStepsSpinner.setEnabled(SwingPredefinedColorMapEditor.this.numberOfStepsCheckBox.isSelected());
                if (SwingPredefinedColorMapEditor.this.numberOfStepsCheckBox.isSelected()) {
                    SwingPredefinedColorMapEditor.this.colorMap.setColorCount(((Number)SwingPredefinedColorMapEditor.this.numberOfStepsSpinner.getValue()).intValue());
                } else {
                    SwingPredefinedColorMapEditor.this.colorMap.setColorCount(256);
                }
            }
        });
        this.numberOfStepsSpinner.setValue(3);
        this.numberOfStepsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingPredefinedColorMapEditor.this.colorMap.setColorCount(((Number)SwingPredefinedColorMapEditor.this.numberOfStepsSpinner.getValue()).intValue());
            }
        });
        this.invertedCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingPredefinedColorMapEditor.this.colorMap.setInverted(SwingPredefinedColorMapEditor.this.invertedCheckBox.isSelected());
            }
        });
        this.brightnessSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingPredefinedColorMapEditor.this.colorMap.setBrightness(SwingPredefinedColorMapEditor.this.brightnessSlider.getValue());
            }
        });
        this.saturationSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingPredefinedColorMapEditor.this.colorMap.setSaturation(SwingPredefinedColorMapEditor.this.saturationSlider.getValue());
            }
        });
        this.colorMapPreviewContainer.setLayout(new OverlayLayout(this.colorMapPreviewContainer));
        this.colormapView = new ExportColormapView(expertMode);
        if (includeLedend) {
            this.colorMapPreviewContainer.add((Component)this.colormapView);
        }
        this.minMaxPanel.setBorder(new TitledBorder((Border)null));
        this.optionsPanel.setBorder(new TitledBorder((Border)null));
        this.optionsScrollPane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.optionsScrollPane.getViewport().setOpaque(false);
        this.mainPanel.revalidate();
    }

    public void setColorMap(MutableColorMap colorMap, Number min, Number max, CPFormat format) {
        if (this.colorMap != colorMap) {
            if (this.colorMap != null) {
                this.colorMap.getInterval().removeIntervalListener(this.intervalListener);
                this.colorMap.removeColorMapListener(this.colorMapListener);
            }
            this.colorMap = colorMap;
            this.min = min;
            this.max = max;
            this.format = format;
            if (colorMap != null) {
                this.colorMap.getInterval().addIntervalListener(this.intervalListener);
                this.colorMap.addColorMapListener(this.colorMapListener);
                this.updateUnderOverEnabled();
                this.updateView();
                boolean numberOfSteps = colorMap.getPalette().getColorCount() < 256;
                this.numberOfStepsCheckBox.setSelected(numberOfSteps);
                if (numberOfSteps) {
                    this.numberOfStepsSpinner.setValue(colorMap.getPalette().getColorCount());
                } else {
                    this.numberOfStepsSpinner.setValue(3);
                }
                if (format instanceof DateFormat) {
                    this.minimumSpinner.setModel(new SpinnerDateModel(new Date((long)colorMap.getInterval().getStart()), null, null, 5));
                    this.maximumSpinner.setModel(new SpinnerDateModel(new Date((long)colorMap.getInterval().getEnd()), null, null, 5));
                } else {
                    this.minimumSpinner.setModel(new SpinnerNumberModel((Number)colorMap.getInterval().getStart(), null, null, (Number)1));
                    this.maximumSpinner.setModel(new SpinnerNumberModel((Number)colorMap.getInterval().getEnd(), null, null, (Number)1));
                }
                if (format instanceof DateFormat) {
                    DateFormatter formatter = new DateFormatter(format instanceof DateFormat ? (DateFormat)format : DateFormat.getInstance());
                    DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter, formatter, formatter);
                    ((JSpinner.DateEditor)this.minimumSpinner.getEditor()).getTextField().setFormatterFactory(factory);
                    ((JSpinner.DateEditor)this.maximumSpinner.getEditor()).getTextField().setFormatterFactory(factory);
                } else {
                    NumberFormatter formatter = new NumberFormatter(format instanceof NumberFormat ? (NumberFormat)format : NumberFormat.getInstance());
                    DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter, formatter, formatter);
                    ((JSpinner.NumberEditor)this.minimumSpinner.getEditor()).getTextField().setFormatterFactory(factory);
                    ((JSpinner.NumberEditor)this.maximumSpinner.getEditor()).getTextField().setFormatterFactory(factory);
                }
                this.colormapView.setColorMap((ColorMap)colorMap, min, max, format);
            }
        }
    }

    private void updateView() {
        this.paletteComboBox.setSelectedItem(this.colorMap.getPalette());
        this.underColorCheckBox.setSelected(this.colorMap.isUnderflowColorSet());
        this.overColorCheckBox.setSelected(this.colorMap.isOverflowColorSet());
        this.underflowColor.setSelectedColor(this.colorMap.getUnderflowColor() != null ? (Color)this.colorMap.getUnderflowColor().getNativeColor() : null);
        this.overflowColor.setSelectedColor(this.colorMap.getOverflowColor() != null ? (Color)this.colorMap.getOverflowColor().getNativeColor() : null);
        this.underflowColor.setEnabled(this.colorMap.isUnderflowColorSet());
        this.overflowColor.setEnabled(this.colorMap.isOverflowColorSet());
        this.missingValueColor.setSelectedColor(this.colorMap.getNullColor() != null ? (Color)this.colorMap.getNullColor().getNativeColor() : null);
        this.invertedCheckBox.setSelected(this.colorMap.isInverted());
        this.brightnessSlider.setValue(this.colorMap.getBrightness());
        this.saturationSlider.setValue(this.colorMap.getSaturation());
    }

    private void createUIComponents() {
        this.paletteComboBox = new MainJYComboBox();
        this.numberOfStepsSpinner = new MJSpinner();
        this.minimumSpinner = new MJSpinner();
        this.maximumSpinner = new MJSpinner();
        ResetAction resetAction = new ResetAction();
        this.setToFullRangeButton = new DropDownButton((Action)resetAction);
        String label = (String)resetAction.getValue("Name");
        this.setToFullRangeButton.setText("");
        this.setToFullRangeButton.setText(label);
        this.setToFullRangeButton.getPopupMenu().add(resetAction);
        this.setToFullRangeButton.getPopupMenu().add(new SymetricalResetAction());
        this.setToFullRangeButton.getPopupMenu().add(new RoundedResetAction());
        this.brightnessSlider = new EnhancedSlider();
        this.brightnessSlider.setMinimum(-150);
        this.brightnessSlider.setMaximum(150);
        this.saturationSlider = new EnhancedSlider();
        this.saturationSlider.setMinimum(-150);
        this.saturationSlider.setMaximum(150);
    }

    private void updateUnderOverEnabled() {
        this.underColorCheckBox.setEnabled(this.min != null && this.min.doubleValue() < this.colorMap.getInterval().getStart());
        this.overColorCheckBox.setEnabled(this.max != null && this.max.doubleValue() > this.colorMap.getInterval().getEnd());
        this.underflowColor.setEnabled(this.underColorCheckBox.isEnabled());
        this.overflowColor.setEnabled(this.overColorCheckBox.isEnabled());
    }

    public ColormapView getLegend() {
        return this.colormapView;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.setOpaque(false);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.setOpaque(false);
        panel1.setVisible(true);
        this.mainPanel.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 0), null, null, 0, false));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "palette"));
        panel1.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        panel1.add((Component)((Object)this.paletteComboBox), new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.optionsScrollPane = new JScrollPane();
        this.optionsScrollPane.setHorizontalScrollBarPolicy(31);
        this.optionsScrollPane.setOpaque(false);
        panel1.add((Component)this.optionsScrollPane, new GridConstraints(2, 0, 1, 2, 0, 3, 5, 5, new Dimension(0, -1), null, null, 0, false));
        this.optionsPanel = new JPanel();
        this.optionsPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.optionsPanel.setMinimumSize(new Dimension(0, 210));
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setPreferredSize(new Dimension(0, 216));
        this.optionsScrollPane.setViewportView(this.optionsPanel);
        this.numberOfStepsSpinner.setEnabled(false);
        this.optionsPanel.add((Component)this.numberOfStepsSpinner, new GridConstraints(0, 1, 1, 1, 0, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
        this.numberOfStepsCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.numberOfStepsCheckBox, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "number.of.steps"));
        this.optionsPanel.add((Component)this.numberOfStepsCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.invertedCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.invertedCheckBox, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "inverted"));
        this.optionsPanel.add((Component)this.invertedCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "brightness"));
        this.optionsPanel.add((Component)label2, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.brightnessSlider.setMaximum(150);
        this.brightnessSlider.setMinimum(-150);
        this.brightnessSlider.setValue(0);
        this.optionsPanel.add((Component)this.brightnessSlider, new GridConstraints(2, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label3 = new JLabel();
        this.$$$loadLabelText$$$(label3, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "saturation"));
        this.optionsPanel.add((Component)label3, new GridConstraints(3, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.saturationSlider.setMaximum(150);
        this.saturationSlider.setMinimum(-150);
        this.saturationSlider.setValue(0);
        this.optionsPanel.add((Component)this.saturationSlider, new GridConstraints(3, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
        this.overColorCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.overColorCheckBox, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "overflow.color"));
        this.optionsPanel.add((Component)this.overColorCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.overflowColor = new MColorComboBox();
        this.optionsPanel.add((Component)this.overflowColor, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), null, null, 0, false));
        this.underColorCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.underColorCheckBox, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "underflow.color"));
        this.optionsPanel.add((Component)this.underColorCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.underflowColor = new MColorComboBox();
        this.optionsPanel.add((Component)this.underflowColor, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), null, null, 0, false));
        JLabel label4 = new JLabel();
        this.$$$loadLabelText$$$(label4, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "missing.values.color"));
        this.optionsPanel.add((Component)label4, new GridConstraints(6, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.missingValueColor = new MColorComboBox();
        this.optionsPanel.add((Component)this.missingValueColor, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), null, null, 0, false));
        this.minMaxPanel = new JPanel();
        this.minMaxPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.minMaxPanel.setOpaque(false);
        panel1.add((Component)this.minMaxPanel, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        this.$$$loadLabelText$$$(label5, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "minimum"));
        this.minMaxPanel.add((Component)label5, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.minMaxPanel.add((Component)this.minimumSpinner, new GridConstraints(1, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JLabel label6 = new JLabel();
        this.$$$loadLabelText$$$(label6, this.$$$getMessageFromBundle$$$("com/macrofocus/util/swing/colormap/ColorMapEditor", "maximum"));
        this.minMaxPanel.add((Component)label6, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.minMaxPanel.add((Component)this.maximumSpinner, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.minMaxPanel.add((Component)panel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.setToFullRangeButton.setEnabled(true);
        panel2.add((Component)this.setToFullRangeButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, new Dimension(0, -1), null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel2.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.colorMapPreviewContainer = new JPanel();
        this.colorMapPreviewContainer.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(2, 5, 3, 5), -1, -1));
        this.colorMapPreviewContainer.setOpaque(false);
        this.mainPanel.add((Component)this.colorMapPreviewContainer, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.mainPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
    }

    private String $$$getMessageFromBundle$$$(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = ((Object)((Object)this)).getClass();
            if ($$$cachedGetBundleMethod$$$ == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                $$$cachedGetBundleMethod$$$ = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)$$$cachedGetBundleMethod$$$.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static class PaletteListCellRenderer
    extends SwingPaletteView
    implements ListCellRenderer {
        private PaletteListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Palette palette = (Palette)value;
            this.setPalette(palette);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setOpaque(true);
            Border border = null;
            if (cellHasFocus) {
                if (isSelected) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = this.defaultBorder;
            }
            this.setBorder(border);
            return this;
        }

        public Dimension getPreferredSize() {
            return new Dimension(20, 20);
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, 16);
        }

        public void validate() {
        }

        public void invalidate() {
        }

        public void repaint() {
        }

        public void revalidate() {
        }

        public void repaint(long tm, int x, int y, int width, int height) {
        }

        public void repaint(Rectangle r) {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            super("Set to Data Range");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingPredefinedColorMapEditor.this.minimumSpinner.setValue(SwingPredefinedColorMapEditor.this.min);
            SwingPredefinedColorMapEditor.this.maximumSpinner.setValue(SwingPredefinedColorMapEditor.this.max);
        }
    }

    private class SymetricalResetAction
    extends AbstractAction {
        public SymetricalResetAction() {
            super("Set to Symmetrical Range around 0");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SwingPredefinedColorMapEditor.this.min.doubleValue() < 0.0 && SwingPredefinedColorMapEditor.this.min.doubleValue() > 0.0) {
                double diffMin = 0.0 - SwingPredefinedColorMapEditor.this.min.doubleValue();
                double diffMax = SwingPredefinedColorMapEditor.this.max.doubleValue();
                double maxDiff = Math.max(diffMin, diffMax);
                SwingPredefinedColorMapEditor.this.minimumSpinner.setValue(0.0 - maxDiff);
                SwingPredefinedColorMapEditor.this.maximumSpinner.setValue(maxDiff);
            } else {
                SwingPredefinedColorMapEditor.this.minimumSpinner.setValue(-SwingPredefinedColorMapEditor.this.max.doubleValue());
                SwingPredefinedColorMapEditor.this.maximumSpinner.setValue(SwingPredefinedColorMapEditor.this.max);
            }
        }
    }

    private class RoundedResetAction
    extends AbstractAction {
        public RoundedResetAction() {
            super("Set to Rounded Range");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            double s = Math.signum(SwingPredefinedColorMapEditor.this.min.doubleValue()) * Math.pow(10.0, Math.floor(Math.log10(Math.abs(SwingPredefinedColorMapEditor.this.min.doubleValue()))));
            SwingPredefinedColorMapEditor.this.minimumSpinner.setValue(s);
            double e = Math.signum(SwingPredefinedColorMapEditor.this.max.doubleValue()) * Math.pow(10.0, Math.ceil(Math.log10(Math.abs(SwingPredefinedColorMapEditor.this.max.doubleValue()))));
            SwingPredefinedColorMapEditor.this.maximumSpinner.setValue(e);
        }
    }
}

