/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.drawing;

import com.macrofocus.drawing.DrawingModel;
import com.macrofocus.drawing.DrawingObjectModel;
import com.macrofocus.drawing.coordinate.CoordinateSystemModel;
import com.macrofocus.drawing.zoom.ZoomStrategy;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractDrawingModel
implements DrawingModel {
    private List drawingObjects;
    private CoordinateSystemModel coordinateSystem;

    public AbstractDrawingModel() {
        this(null);
    }

    public AbstractDrawingModel(CoordinateSystemModel coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
        this.drawingObjects = new LinkedList();
    }

    @Override
    public void setCoordinateSystem(CoordinateSystemModel coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
    }

    @Override
    public void setZoomStrategy(ZoomStrategy zoomStrategy) {
        this.coordinateSystem.setZoomStrategy(zoomStrategy);
    }

    @Override
    public void addDrawingObject(DrawingObjectModel drawingObject) {
        this.drawingObjects.add(drawingObject);
    }

    @Override
    public void draw(Graphics g) {
        if (this.coordinateSystem != null) {
            for (DrawingObjectModel drawingObjectModel : this.drawingObjects) {
                drawingObjectModel.draw(g, this.coordinateSystem);
            }
        }
    }

    @Override
    public void clear() {
        this.drawingObjects.clear();
    }

    public String toString() {
        return this.getClass().getName() + "[drawObjectsCount=" + this.drawingObjects.size() + ",coordinateSystem=" + String.valueOf(this.coordinateSystem) + "]";
    }
}

