/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.export.format;

import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.PdfFileFilter;
import com.macrofocus.util.swing.export.format.AbstractGraphicsExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;

public class XMLGraphicsPDFExportFormat
extends AbstractGraphicsExportFormat {
    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public AbstractFileFilter getFileFilter() {
        return new PdfFileFilter();
    }

    @Override
    public Component getSettingsPanel() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ContentProvider<Component> contentProvider, File file) throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                PDFDocumentGraphics2D g = new PDFDocumentGraphics2D(true);
                g.setDeviceDPI(72.0f);
                g.setGraphicContext(new GraphicContext());
                g.setupDocument((OutputStream)fos, this.getExportWidth(contentProvider.getContent()), this.getExportHeight(contentProvider.getContent()));
                this.print(contentProvider.getContent(), (Graphics)g);
                g.finish();
                g.dispose();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                try {
                    fos.flush();
                    fos.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public String toString() {
        return this.getFileFilter().getName();
    }
}

