/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf.action;

import com.macrofocus.util.swing.plaf.MacrofocusDarkOceanMetalTheme;
import com.macrofocus.util.swing.plaf.MacrofocusLookAndFeel;
import com.macrofocus.util.swing.plaf.action.LookAndFeelAction;
import de.javasoft.docking.ui.BasicDockingPainter;
import de.javasoft.plaf.synthetica.SyntheticaState;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.PainterUIResource;

public class MacrofocusDarkOceanLookAndFeelAction
extends LookAndFeelAction {
    public MacrofocusDarkOceanLookAndFeelAction(Supplier<Iterable<Component>> rootComponents) {
        super("macrofocus-dark-ocean", "Macrofocus Ocean");
        this.setRootComponents(rootComponents);
        this.putValue("ShortDescription", "Macrofocus Ocean Look and Feel");
    }

    public MacrofocusDarkOceanLookAndFeelAction(Component ... rootComponents) {
        super("macrofocus-dark-ocean", "Macrofocus Ocean");
        this.setRootComponents(rootComponents);
        this.putValue("ShortDescription", "Macrofocus Ocean Look and Feel");
    }

    public MacrofocusDarkOceanLookAndFeelAction(Iterable<Component> rootComponents) {
        super("macrofocus-dark-ocean", "Macrofocus Ocean");
        this.setRootComponents(rootComponents);
        this.putValue("ShortDescription", "Macrofocus Ocean Look and Feel");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.isApplet()) {
            MacrofocusLookAndFeel.initLookAndFeel(true, true);
        }
        try {
            UIManager.put("ScrollBar.width", 13);
            Color thumbColor = new Color(66, 106, 178);
            UIManager.put("ScrollBar.thumb", thumbColor);
            UIManager.put("ScrollBar.thumbHighlight", thumbColor.brighter());
            UIManager.put("ScrollBar.thumbShadow", thumbColor.darker());
            UIManager.put("Tree.textBackground", new Color(119, 158, 209));
            UIManager.put("Tree.foreground", new Color(0, 0, 0));
            UIManager.put("Tree.selectionForeground", new Color(255, 255, 255));
            UIManager.put("Tree.selectionBackground", new Color(194, 91, 91));
            UIManager.put("Table.background", new Color(119, 158, 209));
            UIManager.put("Table.foreground", new Color(0, 0, 0));
            UIManager.put("Table.selectionForeground", new Color(255, 255, 255));
            UIManager.put("Table.selectionBackground", new Color(194, 91, 91));
            UIManager.put("Table.gridColor", new Color(165, 183, 207));
            UIManager.put("TableHeader.background", new Color(0, 128, 178));
            UIManager.put("TableHeader.foreground", new Color(255, 255, 255));
            MacrofocusDarkOceanMetalTheme theme = new MacrofocusDarkOceanMetalTheme();
            UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
            UIManager.put("TabbedPane.selected", ((MetalTheme)theme).getControlHighlight());
            UIManager.put("TabbedPane.unselectedBackground", theme.getControl());
            UIManager.put("ToolBar.borderColor", new Color(135, 150, 172));
            UIManager.put("ToolBar.background", new Color(194, 205, 225));
            UIManager.put("JXTitledPanel.titlePainter", new PainterUIResource((Painter)new MattePainter((Paint)new GradientPaint(0.0f, 0.0f, new Color(106, 177, 205), 0.0f, 1.0f, new Color(65, 139, 177)))));
            UIManager.put("JYDocking.titlebar.background", new Color(194, 205, 225));
            UIManager.put("JYDocking.titlebar.active.background", new Color(194, 205, 225));
            UIManager.put("JYDocking.titlebar.active.foreground", new Color(255, 255, 255));
            UIManager.put("JYDocking.titlebar.foreground", new Color(255, 255, 255));
            UIManager.put("JYDocking.titlebar.insets", new Insets(3, 4, 3, 4));
            UIManager.put("Panel.font", theme.getControlTextFont());
            UIManager.put("JYDocking.titlebar.font.style", "BOLD");
            try {
                UIManager.put("Synthetica.DockingPainter", new BasicDockingPainter(){

                    public void paintDockingTitleBarBackground(JComponent jComponent, SyntheticaState syntheticaState, Graphics graphics, int x, int y, int width, int height) {
                        PainterUIResource painter = (PainterUIResource)UIManager.get("JXTitledPanel.titlePainter");
                        painter.paint((Graphics2D)graphics, jComponent, width, height);
                    }
                });
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            MetalLookAndFeel.setCurrentTheme(theme);
            MetalLookAndFeel newLookAndFeel = new MetalLookAndFeel();
            UIManager.setLookAndFeel(newLookAndFeel);
            if (this.rootComponents != null) {
                for (Component rootComponent : (Iterable)this.rootComponents.get()) {
                    SwingUtilities.updateComponentTreeUI(rootComponent);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't load Macrofocus Ocean L&F " + String.valueOf(e));
            e.printStackTrace();
        }
    }

    @Override
    public boolean exist() {
        return true;
    }
}

