/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.print;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.GifFileFilter;
import com.macrofocus.util.file.filter.JpegFileFilter;
import com.macrofocus.util.file.filter.PdfFileFilter;
import com.macrofocus.util.file.filter.PngFileFilter;
import com.macrofocus.util.file.filter.SvgFileFilter;
import com.macrofocus.util.swing.FileChooserFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ExportComponentAction
extends AbstractAction {
    private JComponent component;
    private final boolean expertMode;
    private static final AbstractFileFilter pngFileFilter = new PngFileFilter();
    private static final AbstractFileFilter jpgFileFilter = new JpegFileFilter();
    private static final AbstractFileFilter gifFileFilter = new GifFileFilter();
    private static final AbstractFileFilter svgFileFilter = new SvgFileFilter();
    private static final AbstractFileFilter pdfFileFilter = new PdfFileFilter();
    private FileChooserFactory fileChooserFactory = new FileChooserFactory(){

        @Override
        public JFileChooser getFileChooser() {
            JFileChooser fileChooser = super.getFileChooser();
            if (fileChooser.getSelectedFile() == null) {
                File file = new File("colormap");
                FileFilter fileFilter = fileChooser.getFileFilter();
                if (fileFilter instanceof AbstractFileFilter) {
                    file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension());
                }
                fileChooser.setSelectedFile(file);
            }
            return fileChooser;
        }

        @Override
        protected JFileChooser createFileChooser() {
            JFileChooser fileChooser = super.createFileChooser();
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setAcceptAllFileFilterUsed(false);
            if (ExportComponentAction.this.expertMode) {
                fileChooser.addChoosableFileFilter((FileFilter)pdfFileFilter);
            }
            fileChooser.addChoosableFileFilter((FileFilter)svgFileFilter);
            fileChooser.addChoosableFileFilter((FileFilter)pngFileFilter);
            fileChooser.addChoosableFileFilter((FileFilter)jpgFileFilter);
            fileChooser.addChoosableFileFilter((FileFilter)gifFileFilter);
            if (ExportComponentAction.this.expertMode) {
                fileChooser.setFileFilter((FileFilter)pdfFileFilter);
            } else {
                fileChooser.setFileFilter((FileFilter)svgFileFilter);
            }
            return fileChooser;
        }
    };

    public ExportComponentAction(String name, JComponent component, boolean expertMode) {
        super(name);
        this.expertMode = expertMode;
        this.setComponent(component);
    }

    public void setComponent(JComponent component) {
        this.component = component;
        this.setEnabled(component != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = this.fileChooserFactory.getFileChooser();
        fileChooser.rescanCurrentDirectory();
        int returnVal = fileChooser.showSaveDialog(this.component);
        File file = fileChooser.getSelectedFile();
        FileFilter fileFilter = fileChooser.getFileFilter();
        if (returnVal == 0) {
            int input;
            if (!fileFilter.accept(file) && fileFilter instanceof AbstractFileFilter) {
                file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension());
            }
            if (file.exists() && (input = JOptionPane.showConfirmDialog(this.component, "File " + file.getName() + " already exist! Overwrite?", "File already exist", 0, 2)) == 1) {
                return;
            }
            if (fileFilter.equals(pngFileFilter) || fileFilter.equals(jpgFileFilter) || fileFilter.equals(gifFileFilter)) {
                BufferedImage bufferedImage = new BufferedImage(this.component.getWidth(), this.component.getHeight(), 2);
                Graphics2D g = bufferedImage.createGraphics();
                this.component.print(g);
                try {
                    ImageIO.write((RenderedImage)bufferedImage, ((AbstractFileFilter)fileFilter).getDefaultExtension(), file);
                }
                catch (IOException e1) {
                    Logging.getInstance().process((Throwable)e1);
                }
                g.dispose();
            } else if (fileFilter.equals(svgFileFilter)) {
                DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                String svgNS = "http://www.w3.org/2000/svg";
                Document document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
                SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                Object antialias = UIManager.get("Synthetica.text.antialias");
                UIManager.put("Synthetica.text.antialias", false);
                this.component.print((Graphics)svgGenerator);
                UIManager.put("Synthetica.text.antialias", antialias);
                boolean useCSS = true;
                try {
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
                    svgGenerator.stream((Writer)out, true);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (SVGGraphics2DIOException e1) {
                    e1.printStackTrace();
                }
            } else if (fileFilter.equals(pdfFileFilter)) {
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        ((UserProperties)PDFGraphics2D.getDefaultProperties()).setProperty(PDFGraphics2D.TEXT_AS_SHAPES, false);
                        PDFGraphics2D g = new PDFGraphics2D((OutputStream)fos, this.component.getSize());
                        g.startExport();
                        this.component.print((Graphics)g);
                        g.endExport();
                        g.dispose();
                    }
                    catch (RuntimeException e1) {
                        e1.printStackTrace();
                    }
                    finally {
                        try {
                            fos.flush();
                            fos.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

