/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.spinner;

import com.macrofocus.utils.PropertyChange;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractSpinnerModel;

public class BeanSpinnerModel<E>
extends AbstractSpinnerModel {
    private PropertyDescriptor pd;
    private Object o;

    public BeanSpinnerModel(Object o, String name) {
        this.o = o;
        if (o instanceof PropertyChange) {
            PropertyChange changeSupport = (PropertyChange)o;
            changeSupport.addPropertyChangeListener(name, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BeanSpinnerModel.this.fireStateChanged();
                }
            });
        }
        try {
            PropertyDescriptor[] pds;
            BeanInfo info = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                if (!pd.getName().equals(name)) continue;
                this.pd = pd;
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public E getValue() {
        if (this.pd != null) {
            try {
                return (E)this.pd.getReadMethod().invoke(this.o, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        if (this.getValue() != value) {
            try {
                this.pd.getWriteMethod().invoke(this.o, value);
                this.fireStateChanged();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object getNextValue() {
        if (this.getValue() instanceof Integer) {
            return (Integer)this.getValue() + 1;
        }
        return null;
    }

    @Override
    public Object getPreviousValue() {
        if (this.getValue() instanceof Integer) {
            return (Integer)this.getValue() - 1;
        }
        return null;
    }
}

