/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAssociationAction
extends SystemAutoUninstallInstallAction {
    private static final Map<File, UnixAssociationInfo> executableToUnixAssociationInfo = new HashMap<File, UnixAssociationInfo>();
    protected static final String PROP_EXECUTABLE = "executable";
    private String launcherId = "";

    public String getLauncherId() {
        return AbstractAssociationAction.replaceVariables(this.launcherId);
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    @Override
    public void rollback(InstallerContext context) {
        super.rollback(context);
        if (InstallerUtil.isWindows()) {
            Registry.changeNotifyAssociations();
        }
    }

    protected File getExecutableFile(Context context) {
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        LauncherConfig launcher = config.getLauncherConfigById(this.getLauncherId());
        if (launcher == null) {
            return null;
        }
        return context.getDestinationFile(launcher.getFile());
    }

    protected static boolean addMimeTypeToDesktopFile(File desktopFile, String mimeType) throws IOException {
        String[] lines = FileUtil.readTextFile(desktopFile, "UTF-8").split("\\r?\\n");
        boolean found = false;
        int execLine = -1;
        for (int i = 0; i < lines.length && !found; ++i) {
            if (lines[i].startsWith("MimeType=")) {
                if (lines[i].contains(mimeType)) continue;
                if (!lines[i].endsWith(";")) {
                    int n = i;
                    lines[n] = lines[n] + ";";
                }
                int n = i;
                lines[n] = lines[n] + mimeType + ";";
                found = true;
                continue;
            }
            if (execLine != -1 || !lines[i].startsWith("Exec=")) continue;
            execLine = i;
        }
        if (!found) {
            if (execLine == -1) {
                Logger.getInstance().error(null, "did not find Exec entry in " + desktopFile);
                return false;
            }
            ArrayList<String> newLines = new ArrayList<String>(Arrays.asList(lines));
            newLines.add(execLine + 1, "MimeType=" + mimeType + ";");
            lines = newLines.toArray(new String[0]);
        }
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(desktopFile), StandardCharsets.UTF_8));){
            for (String line : lines) {
                pw.println(line);
            }
        }
        MenuHelper.installDesktopFile(desktopFile);
        MenuHelper.execute("xdg-mime", "default", desktopFile.getName(), mimeType);
        return true;
    }

    public static void registerDesktopFile(File executableFile, File desktopFile) throws IOException, UserCanceledException {
        AbstractAssociationAction.getUnixAssociationInfo(executableFile).registerDesktopFile(desktopFile);
    }

    protected static UnixAssociationInfo getUnixAssociationInfo(File executableFile) {
        UnixAssociationInfo ret = executableToUnixAssociationInfo.get(executableFile = FileUtil.getCanonicalFile(executableFile));
        if (ret == null) {
            ret = new UnixAssociationInfo();
            executableToUnixAssociationInfo.put(executableFile, ret);
        }
        return ret;
    }

    public static void logUnhandledUnixAssociations() {
        for (Map.Entry<File, UnixAssociationInfo> entry : executableToUnixAssociationInfo.entrySet()) {
            for (HandlerState handlerState : entry.getValue().actions.values()) {
                if (handlerState.executedAtLeastOnce) continue;
                Logger.getInstance().error(null, "A file association or url handler for " + entry.getKey() + " was not registered because no desktop file was created with a 'Create default start menu entries' or 'Create start menu entry' action.");
            }
        }
    }

    protected static class UnixAssociationInfo {
        private final Set<File> desktopFiles = new HashSet<File>();
        private final Map<AbstractAssociationAction, HandlerState> actions = new IdentityHashMap<AbstractAssociationAction, HandlerState>();

        protected UnixAssociationInfo() {
        }

        public void registerDesktopFile(File desktopFile) throws IOException, UserCanceledException {
            for (HandlerState handlerState : this.actions.values()) {
                handlerState.executedAtLeastOnce = true;
                handlerState.handler.handle(desktopFile);
            }
            this.desktopFiles.add(desktopFile);
        }

        public void addAction(AbstractAssociationAction associationAction, boolean executedAtLeastOnce, DesktopFileHandler desktopFileHandler) {
            this.actions.put(associationAction, new HandlerState(desktopFileHandler, executedAtLeastOnce));
        }

        public Set<File> getDesktopFiles() {
            return this.desktopFiles;
        }
    }

    private static class HandlerState {
        private final DesktopFileHandler handler;
        private volatile boolean executedAtLeastOnce;

        public HandlerState(DesktopFileHandler handler, boolean executedAtLeastOnce) {
            this.handler = handler;
            this.executedAtLeastOnce = executedAtLeastOnce;
        }
    }

    protected static interface DesktopFileHandler {
        public void handle(File var1) throws IOException, UserCanceledException;
    }
}

