/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.ejt.internal.util.JavaVersionUtil;
import com.install4j.api.UiUtil;
import com.install4j.api.Util;
import com.install4j.api.laf.LookAndFeelHandler;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.InstallerLookAndFeelConfig;
import com.install4j.runtime.installer.config.laf.LookAndFeelType;
import com.install4j.runtime.installer.frontend.ExternalFlatLafLookAndFeelHandler;
import com.install4j.runtime.installer.frontend.IntelliJLookAndFeelHandler;
import com.install4j.runtime.installer.frontend.NativeLookAndFeelHandler;
import com.install4j.runtime.installer.frontend.NoLookAndFeelHandler;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.platform.macos.MacosUiHelper;
import com.install4j.runtime.installer.platform.win32.WinDarkModeDetector;
import com.install4j.runtime.util.CustomDialog;
import com.install4j.runtime.wizard.CustomFrame;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class LookAndFeelHelper {
    private static boolean lookAndFeelSet = false;
    private static LookAndFeelHandler lookAndFeelHandler;
    private static boolean otherDarkDesktop;

    @NotNull
    public static LookAndFeelHandler getLookAndFeelHandler() {
        if (lookAndFeelHandler == null) {
            lookAndFeelHandler = LookAndFeelHelper.detectLookAndFeelHandler();
        }
        return lookAndFeelHandler;
    }

    @NotNull
    private static LookAndFeelHandler detectLookAndFeelHandler() {
        if (!InstallerUtil.isConsole() && !InstallerUtil.isUnattended()) {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            String id = lookAndFeel.getID();
            if (lookAndFeel.getClass().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
                return new NativeLookAndFeelHandler();
            }
            if (id.equals("IntelliJ")) {
                return new IntelliJLookAndFeelHandler(false);
            }
            if (id.equals("Darcula")) {
                return new IntelliJLookAndFeelHandler(true);
            }
            if (id.contains("FlatLaf")) {
                return new ExternalFlatLafLookAndFeelHandler();
            }
        }
        return new NoLookAndFeelHandler();
    }

    public static void setLookAndFeel() {
        if (!InstallerUtil.isInProcess() || InstallerUtil.isBlockingLauncherIntegration()) {
            LookAndFeelHelper.setLookAndFeelUnconditional();
        }
    }

    public static void setLookAndFeelUnconditional() {
        HelperCommunication.helperUnsupported();
        if (!lookAndFeelSet) {
            lookAndFeelSet = true;
            if (!Boolean.getBoolean("install4j.nolaf") && !Boolean.getBoolean("java.awt.headless") && System.getProperty("swing.defaultlaf") == null) {
                try {
                    LookAndFeelResetter.previousLookAndFeel = UIManager.getLookAndFeel().getClass().getName();
                    lookAndFeelHandler = LookAndFeelHelper.createLookAndFeelHandler();
                    lookAndFeelHandler.applyLookAndFeel(LookAndFeelHelper.isDarkDesktop());
                    if (lookAndFeelHandler.isDarkModeSwitchingSupported()) {
                        if (Util.isMacOS()) {
                            MacosUiHelper.addThemeChangedListener(LookAndFeelHelper::syncDarkMode);
                        } else if (Util.isAtLeastWindows10() && JavaVersionUtil.JETBRAINS_JRE) {
                            Toolkit.getDefaultToolkit().addPropertyChangeListener("win.lightTheme.on", e -> LookAndFeelHelper.syncDarkMode());
                        }
                    }
                    if (Util.isMacOS() && lookAndFeelHandler.isDark()) {
                        MacosUiHelper.setDarkMode(true);
                    }
                }
                catch (Exception ex) {
                    Util.logError(null, "Error setting the look and feel");
                    Util.log(ex);
                }
            }
        }
    }

    private static void syncDarkMode() {
        EventQueue.invokeLater(() -> UiUtil.setDarkUi(UiUtil.isDarkDesktop()));
    }

    @NotNull
    private static LookAndFeelHandler createLookAndFeelHandler() throws Exception {
        InstallerConfig config;
        if (!Util.isWindows() && !Util.isMacOS()) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                otherDarkDesktop = NativeLookAndFeelHandler.isDarkMode();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((config = InstallerConfig.getCurrentInstance()) != null) {
            InstallerLookAndFeelConfig lookAndFeelConfig = config.getLookAndFeelConfig();
            LookAndFeelType type = LookAndFeelType.getByName(System.getProperty("install4j.laf"), lookAndFeelConfig.getType());
            switch (type) {
                case CROSS_PLATFORM: {
                    return LookAndFeelHelper.createFlatLafLookAndFeelHandler();
                }
                case NATIVE: {
                    return new NativeLookAndFeelHandler();
                }
                case CUSTOM: {
                    return LookAndFeelHelper.instantiateLookAndFeelHandler(lookAndFeelConfig.getLookAndFeelHandlerClassName());
                }
            }
            throw new IllegalStateException(type.name());
        }
        return LookAndFeelHelper.createFlatLafLookAndFeelHandler();
    }

    @NotNull
    private static LookAndFeelHandler createFlatLafLookAndFeelHandler() throws Exception {
        return LookAndFeelHelper.instantiateLookAndFeelHandler("com.install4j.runtime.flatlaf.FlatLafLookAndFeelHandler");
    }

    @NotNull
    private static LookAndFeelHandler instantiateLookAndFeelHandler(String className) throws Exception {
        Install4jClassLoader classLoader = Install4jClassLoader.getInstance();
        UIManager.put("ClassLoader", classLoader);
        return (LookAndFeelHandler)Class.forName(className, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static boolean isDarkDesktop() {
        if (Util.isMacOS()) {
            return MacosUiHelper.isDarkMode();
        }
        if (Util.isWindows()) {
            return WinDarkModeDetector.isDarkMode();
        }
        return otherDarkDesktop;
    }

    public static void setDarkUi(boolean dark) {
        if (InstallerUtil.isConsole() || InstallerUtil.isUnattended()) {
            return;
        }
        LookAndFeelHandler lookAndFeelHandler = LookAndFeelHelper.getLookAndFeelHandler();
        if (lookAndFeelHandler.isDarkModeSwitchingSupported()) {
            MacosUiHelper.setDarkMode(dark);
            lookAndFeelHandler.setDark(dark);
            for (Window window : Window.getWindows()) {
                try {
                    if (!(window instanceof CustomFrame) && !(window instanceof CustomDialog)) {
                        SwingUtilities.updateComponentTreeUI(window);
                    }
                    if (!(window instanceof RootPaneContainer) || !JavaVersionUtil.JETBRAINS_JRE) continue;
                    JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                    rootPane.putClientProperty("jetbrains.awt.windowDarkAppearance", dark);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class LookAndFeelResetter {
        private static String previousLookAndFeel = null;

        public static void reset() {
            if (previousLookAndFeel != null) {
                try {
                    UIManager.setLookAndFeel(previousLookAndFeel);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

