/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.filters;

import com.macrofocus.ReverseComparator;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SimpleSelection;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.format.CPFormat;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.high_d.filters.CategoricalFilterComponent;
import com.macrofocus.high_d.interaction.InteractionMode;
import com.macrofocus.igraphics.AbstractIDrawing;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.molap.dataframe.SortOrder;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.subset.BinningDimension;
import com.macrofocus.molap.subset.DimensionEvent;
import com.macrofocus.molap.subset.DimensionListener;
import com.macrofocus.molap.subset.Group;
import com.macrofocus.molap.subset.Reducer;
import com.macrofocus.palette.Palette;
import com.macrofocus.rubberband.RubberBand;
import com.macrofocus.rubberband.SimpleRubberBand;
import com.macrofocus.utils.RandomAccessIterable;
import com.macrofocus.utils.RandomAccessIterables;
import com.macrofocus.utils.UniversalComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractCategoricalFilterComponent<Component, Color, Row, C, Value, Bin>
implements CategoricalFilterComponent<Component, Color> {
    protected final MutableProperties<CategoricalFilterComponent.PropertyType> properties = new EnumProperties(CategoricalFilterComponent.PropertyType.class);
    protected final CPColorFactory<Color> factory;
    protected final BinningDimension<Row, Bin> dimension;
    protected final Group<Row, Bin> group;
    protected List<Bin> activeBins;
    protected UniqueIndex<Bin> activeBinsIndex;
    protected String search = null;
    protected CPFormat format;
    private final RubberBand rubberBand;
    private double textHeight = -1.0;
    protected MutableSelection<Bin> probing = new SimpleSelection();
    private final 1 dimensionListener$413329af;
    private final 2 propertiesListener$51d1be6d;

    /*
     * WARNING - void declaration
     */
    public AbstractCategoricalFilterComponent(CPColorFactory<Color> factory, BinningDimension<Row, Bin> dimension, Reducer<Row, Bin> reducer) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.Orientation, (Object)CategoricalFilterComponent.Orientation.Vertical);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.MinItemSize, (Object)18);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.MaxItemSize, (Object)1000);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.GapSize, (Object)2);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.Proportional, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.ShowFiltered, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.Sort, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.Comparator, (Object)new UniversalComparator());
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.SortOrder, (Object)SortOrder.ASCENDING);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.ShowAxis, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.Filterable, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.ShowCumulative, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.ShowDistribution, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.NullLabel, (Object)"(null)");
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.InteractionMode, (Object)InteractionMode.Filter);
        this.dimensionListener$413329af = new DimensionListener(this){
            private /* synthetic */ AbstractCategoricalFilterComponent this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final void dimensionChanged(DimensionEvent event) {
                this.this$0.activeBins = null;
                this.this$0.activeBinsIndex = null;
            }

            public final void selectedCountChanged() {
            }
        };
        this.propertiesListener$51d1be6d = new PropertiesListener(this){
            private /* synthetic */ AbstractCategoricalFilterComponent this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final void propertyChanged(Object name, PropertyEvent event) {
                this.this$0.activeBins = null;
                this.this$0.activeBinsIndex = null;
                this.this$0.populate();
            }
        };
        this.factory = factory;
        this.dimension = dimension;
        this.group = reducer != null ? dimension.getGroup((Reducer)var3_3) : null;
        this.properties.createProperty((Object)CategoricalFilterComponent.PropertyType.ColorTheme, (Object)new LightColorTheme((CPColorFactory)var1_1));
        this.rubberBand = new SimpleRubberBand();
        var2_2.addWeakDimensionListener((DimensionListener)this.dimensionListener$413329af);
        this.properties.addPropertiesListener((PropertiesListener)this.propertiesListener$51d1be6d);
    }

    protected abstract void populate();

    @Override
    public MutableProperty<ColorTheme<Color>> getColorTheme() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.ColorTheme);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColorTheme(MutableProperty<ColorTheme<Color>> colorTheme) {
        void var1_1;
        this.properties.replaceProperty((Object)CategoricalFilterComponent.PropertyType.ColorTheme, (MutableProperty)var1_1);
    }

    @Override
    public BinningDimension<Row, Bin> getDimension() {
        return this.dimension;
    }

    public Group getGroup() {
        return this.group;
    }

    @Override
    public MutableProperty<CategoricalFilterComponent.Orientation> getOrientation() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.Orientation);
    }

    @Override
    public MutableProperty<Integer> getMinItemSize() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.MinItemSize);
    }

    @Override
    public MutableProperty<Integer> getMaxItemSize() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.MaxItemSize);
    }

    @Override
    public MutableProperty<Integer> getGapSize() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.GapSize);
    }

    @Override
    public MutableProperty<Boolean> getProportional() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.Proportional);
    }

    @Override
    public MutableProperty<Boolean> getShowFiltered() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.ShowFiltered);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        void var1_1;
        this.properties.replaceProperty((Object)CategoricalFilterComponent.PropertyType.ShowFiltered, (MutableProperty)var1_1);
    }

    @Override
    public MutableProperty<Boolean> getSort() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.Sort);
    }

    @Override
    public MutableProperty<Comparator> getComparator() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.Comparator);
    }

    @Override
    public MutableProperty<SortOrder> getSortOrder() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.SortOrder);
    }

    @Override
    public MutableProperty<Boolean> getShowAxis() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.ShowAxis);
    }

    @Override
    public MutableProperty<Boolean> getShowCumulative() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.ShowCumulative);
    }

    @Override
    public MutableProperty<Boolean> getFilterable() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.Filterable);
    }

    @Override
    public MutableProperty<Boolean> getShowDistribution() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.ShowDistribution);
    }

    @Override
    public MutableProperty<String> getNullLabel() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.NullLabel);
    }

    @Override
    public MutableProperty<InteractionMode> getInteractionMode() {
        return this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.InteractionMode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setInteractionMode(MutableProperty<InteractionMode> interactionMode) {
        void var1_1;
        this.properties.replaceProperty((Object)CategoricalFilterComponent.PropertyType.InteractionMode, (MutableProperty)var1_1);
    }

    public String getSearch() {
        return this.search;
    }

    /*
     * WARNING - void declaration
     */
    public void setSearch(String search) {
        if (this.search != search) {
            void var1_1;
            this.search = var1_1;
            this.activeBins = null;
            this.activeBinsIndex = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<Bin> getBins() {
        if (this.activeBins == null) {
            void var1_1;
            ArrayList activeValues = (Boolean)this.getShowFiltered().getValue() == false ? RandomAccessIterables.toArrayList((RandomAccessIterable)this.dimension.getActiveBins()) : RandomAccessIterables.toArrayList((RandomAccessIterable)this.dimension.getBins());
            if (this.search != null) {
                ArrayList searchedValues = new ArrayList();
                String search = this.search != null ? this.search.toLowerCase() : null;
                for (Object value : activeValues) {
                    String s = value != null ? value.toString().toLowerCase() : null;
                    if (s == null || !s.contains(search)) continue;
                    searchedValues.add(value);
                }
                activeValues = searchedValues;
            }
            if (((Boolean)this.getSort().getValue()).booleanValue()) {
                activeValues = new ArrayList(activeValues);
                Collections.sort(activeValues, new Comparator<Bin>(this){
                    private /* synthetic */ AbstractCategoricalFilterComponent this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final int compare(Bin o1, Bin o2) {
                        void var1_1;
                        void var2_2;
                        return Double.compare(this.this$0.getActiveCount(var2_2), this.this$0.getActiveCount(var1_1));
                    }
                });
            } else {
                void var2_2;
                Comparator comparator = (Comparator)this.getComparator().getValue();
                if (this.getSortOrder().getValue() == SortOrder.DESCENDING) {
                    comparator = new ReverseComparator(comparator);
                }
                Collections.sort(activeValues, var2_2);
            }
            this.activeBins = var1_1;
            this.activeBinsIndex = null;
        }
        return this.activeBins;
    }

    protected UniqueIndex<Bin> getBinsIndex() {
        if (this.activeBinsIndex == null) {
            this.activeBinsIndex = new DefaultUniqueIndex(this.getBins());
        }
        return this.activeBinsIndex;
    }

    /*
     * WARNING - void declaration
     */
    protected double getCount(Bin o2) {
        void var1_1;
        if (this.group != null) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        return this.dimension.getDensity((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected double getActiveCount(Bin o2) {
        void var1_1;
        if (this.group != null) {
            return this.group.getValue(o2);
        }
        return this.dimension.getActiveDensity((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected double getSelectedCount(Bin o2) {
        void var1_1;
        if (this.group != null) {
            return 0.0;
        }
        return this.dimension.getSelectionDensity((Object)var1_1);
    }

    protected double getMax() {
        if (this.group != null) {
            if (((Boolean)this.getProportional().getValue()).booleanValue()) {
                return this.group.getActiveMaxValue();
            }
            return this.group.getMaxValue();
        }
        if (((Boolean)this.getProportional().getValue()).booleanValue()) {
            return this.dimension.getMaxActiveDensity();
        }
        return this.dimension.getMaxDensity();
    }

    /*
     * WARNING - void declaration
     */
    protected long computeIdealHeight(int actualWidth) {
        void var1_1;
        return Math.min((long)((Integer)this.getMaxItemSize().getValue()).intValue() * (long)this.getBins().size() - (long)((Integer)this.getGapSize().getValue()).intValue(), Math.max((long)((Integer)this.getMinItemSize().getValue()).intValue() * (long)this.getBins().size() - (long)((Integer)this.getGapSize().getValue()).intValue(), (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private double getTextHeight(IGraphics g2) {
        if (this.textHeight <= 0.0 && g2 != null) {
            void var1_1;
            this.textHeight = var1_1.getStringHeight("Macrofocus");
        }
        return this.textHeight;
    }

    /*
     * WARNING - void declaration
     */
    protected State getState(Bin bin) {
        boolean bl = !this.dimension.getFilterExact().isActive() || this.dimension.getFilterExact().isSelected(bin);
        if (bl && this.dimension.getActiveDensity(bin) > 0.0) {
            if (this.probing.isActive() && this.probing.isSelected(bin)) {
                if (this.dimension.getFilterExact().isSelected(bin)) {
                    return State.ProbedSelected;
                }
                return State.Probed;
            }
            if (this.dimension.getFilterExact().isSelected(bin)) {
                return State.Selected;
            }
            return State.Active;
        }
        if (this.dimension.getActiveDensity(bin) > 0.0) {
            void var1_1;
            if (this.probing.isActive() && this.probing.isSelected((Object)var1_1)) {
                return State.ProbedSelectable;
            }
            return State.Selectable;
        }
        return State.Inactive;
    }

    /*
     * WARNING - void declaration
     */
    public List<Bin> getBins(Rectangle2D rect) {
        void var1_1;
        int index2;
        double vy1 = this.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal ? rect.getY() : rect.getX();
        double vy2 = this.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal ? rect.getY() + rect.getHeight() : rect.getX() + rect.getWidth();
        ArrayList<Bin> list = null;
        int index1 = this.getIndex((int)vy1);
        if (index1 > (index2 = this.getIndex((int)vy2))) {
            int tmp = index2;
            index2 = index1;
            index1 = tmp;
        }
        index2 = Math.min(index2, this.getBins().size());
        for (void i = var2_3; i <= index2; ++i) {
            if (list == null) {
                list = new ArrayList<Bin>();
            }
            list.add(this.getBins().get((int)i));
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    public void select(CPCanvas.MouseEvent e, boolean continuous) {
        block12: {
            block14: {
                block15: {
                    block13: {
                        if (!((Boolean)this.getFilterable().getValue()).booleanValue() || (index = this.getIndex(y = this.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal ? e.getY() : e.getX())) < 0 || index >= this.getBins().size() || !(var4_6 = this.dimension.getActiveDensity(bin = this.getBins().get(index)) > 0.0)) break block12;
                        interactionMode = (InteractionMode)this.getInteractionMode().getValue();
                        if (e.isAltKeyDown()) {
                            switch (4.$SwitchMap$com$macrofocus$high_d$interaction$InteractionMode[interactionMode.ordinal()]) {
                                case 1: {
                                    v0 = InteractionMode.Filter;
                                    break;
                                }
                                case 2: {
                                    v0 = InteractionMode.Filter;
                                    break;
                                }
                                case 3: {
                                    v0 = interactionMode = this.dimension.getSelection() != null ? InteractionMode.Selection : InteractionMode.Toggle;
                                }
                            }
                        }
                        if (interactionMode != InteractionMode.Selection) break block13;
                        if (this.dimension.getSelection() != null) {
                            if (e.isMenuShortcutKeyDown()) {
                                this.dimension.getSelection().setSelectedIterableState(this.dimension.getRows(bin), true);
                                return;
                            }
                            this.dimension.getSelection().setSelectedIterable(this.dimension.getRows(bin));
                            return;
                        }
                        break block12;
                    }
                    if (var2_3 == false && this.dimension.getFilterExact().isSelected(bin) && this.dimension.getFilterExact().getSelectedCount() == 1) {
                        this.dimension.filterAll();
                        return;
                    }
                    if (interactionMode == InteractionMode.Filter && !e.isMenuShortcutKeyDown() || interactionMode == InteractionMode.Toggle && e.isMenuShortcutKeyDown()) {
                        this.dimension.filterExact(new Object[]{bin});
                        return;
                    }
                    e = this.dimension.getFilterExact().isActive() == false;
                    if (!e) break block14;
                    if (interactionMode != InteractionMode.Filter) break block15;
                    this.dimension.getFilterExact().setSelectedIterable(this.getBins());
                    v1 = this.dimension.getFilterExact();
                    v2 = bin;
                    ** GOTO lbl-1000
                }
                this.dimension.filterExact(new Object[]{bin});
                return;
            }
            currentlySelected = this.dimension.getFilterExact().isSelected(bin);
            v1 = this.dimension.getFilterExact();
            v2 = var3_5;
            if (var1_2 == false) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            v1.setSelectedState(v2, v3);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void probe(CPCanvas.MouseEvent e, boolean continuous) {
        int y = this.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal ? e.getY() : e.getX();
        int index = this.getIndex(y);
        if (index >= 0 && index < this.getBins().size()) {
            Bin bin = this.getBins().get(index);
            boolean bl = this.dimension.getActiveDensity(bin) > 0.0;
            if (bl) {
                void var1_3;
                this.probing.setSelected((Object)var1_3);
                return;
            }
            this.probing.clearSelection();
            return;
        }
        this.probing.clearSelection();
    }

    /*
     * WARNING - void declaration
     */
    private int getIndex(int y) {
        void var3_3;
        void var1_1;
        void var2_2;
        int height = this.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal ? this.getHeight() : this.getWidth();
        long idealHeight = this.computeIdealHeight((int)var2_2);
        return (int)((long)var1_1 * (long)this.getBins().size() / var3_3);
    }

    public abstract int getWidth();

    public abstract int getHeight();

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFormat(CPFormat format) {
        void var1_1;
        this.format = var1_1;
    }

    public RubberBand getRubberBand() {
        return this.rubberBand;
    }

    protected static enum State {
        Active,
        Probed,
        Selected,
        ProbedSelected,
        Selectable,
        ProbedSelectable,
        Inactive;

    }

    protected class DefaultKeyListener
    implements CPCanvas.KeyListener {
        private final BinningDimension<Row, Bin> dimension;
        private /* synthetic */ AbstractCategoricalFilterComponent this$0;

        /*
         * WARNING - void declaration
         */
        public DefaultKeyListener(AbstractCategoricalFilterComponent this$0, BinningDimension<Row, Bin> dimension) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.dimension = var2_2;
        }

        public void keyTyped(CPCanvas.KeyEvent e) {
        }

        /*
         * WARNING - void declaration
         */
        public void keyPressed(CPCanvas.KeyEvent e) {
            switch (e.getKeyCode()) {
                case 39: {
                    int next;
                    if (!((Boolean)this.this$0.getFilterable().getValue()).booleanValue() || this.dimension.getFilterExact().isActive() || this.dimension.getFilterExact().getSelectedCount() != 1) break;
                    if (this.dimension.getFilterExact().isActive()) {
                        Object first3 = this.dimension.getFilterExact().iterator().next();
                        int first2 = this.this$0.getBinsIndex().getAddress(first3);
                        next = first2 + 1;
                    } else {
                        next = 0;
                    }
                    if (next < this.this$0.getBins().size()) {
                        this.dimension.getFilterExact().setSelected(this.this$0.getBins().get(next));
                    }
                    return;
                }
                case 37: {
                    void var1_3;
                    int next;
                    if (!((Boolean)this.this$0.getFilterable().getValue()).booleanValue() || this.dimension.getFilterExact().getSelectedCount() != 1) break;
                    if (this.dimension.getFilterExact().isActive()) {
                        first3 = this.dimension.getFilterExact().iterator().next();
                        int first3 = this.this$0.getBinsIndex().getAddress(first3);
                        next = first3 - 1;
                    } else {
                        next = this.this$0.getBins().size() - 1;
                    }
                    if (next < 0) break;
                    this.dimension.getFilterExact().setSelected(this.this$0.getBins().get((int)var1_3));
                }
            }
        }

        public void keyReleased(CPCanvas.KeyEvent e) {
        }
    }

    public class DefaultMouseMotionListener
    implements CPCanvas.MouseMotionListener {
        private /* synthetic */ AbstractCategoricalFilterComponent this$0;

        /*
         * WARNING - void declaration
         */
        public DefaultMouseMotionListener(AbstractCategoricalFilterComponent this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void mouseDragged(CPCanvas.MouseEvent e) {
            void var1_1;
            this.this$0.select((CPCanvas.MouseEvent)var1_1, true);
        }

        /*
         * WARNING - void declaration
         */
        public void mouseMoved(CPCanvas.MouseEvent e) {
            void var1_1;
            this.this$0.probe((CPCanvas.MouseEvent)var1_1, true);
        }
    }

    public class DefaultMouseListener
    implements CPCanvas.MouseListener {
        private /* synthetic */ AbstractCategoricalFilterComponent this$0;

        /*
         * WARNING - void declaration
         */
        public DefaultMouseListener(AbstractCategoricalFilterComponent this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public void mouseClicked(CPCanvas.MouseEvent e) {
        }

        /*
         * WARNING - void declaration
         */
        public void mousePressed(CPCanvas.MouseEvent e) {
            void var1_1;
            this.this$0.select((CPCanvas.MouseEvent)var1_1, false);
        }

        public void mouseReleased(CPCanvas.MouseEvent e) {
        }

        /*
         * WARNING - void declaration
         */
        public void mouseEntered(CPCanvas.MouseEvent e) {
            void var1_1;
            this.this$0.probe((CPCanvas.MouseEvent)var1_1, true);
        }

        public void mouseExited(CPCanvas.MouseEvent e) {
            this.this$0.probing.clearSelection();
        }
    }

    private static final class CumulativeShape {
        private final Rectangle2D.Double shape;
        private final double sum;

        /*
         * WARNING - void declaration
         */
        public CumulativeShape(Rectangle2D.Double shape, double sum) {
            void var2_2;
            void var1_1;
            this.shape = var1_1;
            this.sum = var2_2;
        }

        public final Rectangle2D.Double getShape() {
            return this.shape;
        }

        public final double getSum() {
            return this.sum;
        }
    }

    protected class FilterIDrawing<FontMetrics>
    extends AbstractIDrawing<Color, FontMetrics> {
        private int width;
        private int height;
        private SelectionListener<Bin> selectionListener$211cab67 = new SelectionListener<Bin>(this){
            private /* synthetic */ FilterIDrawing this$1;
            {
                void var1_1;
                this.this$1 = var1_1;
            }

            public final void selectionChanged(SelectionEvent<Bin> event) {
                this.this$1.notifyIDrawingChanged();
            }
        };
        private DimensionListener<Row> dimensionListener$413329af = new DimensionListener<Row>(this){
            private /* synthetic */ FilterIDrawing this$1;
            {
                void var1_1;
                this.this$1 = var1_1;
            }

            public final void dimensionChanged(DimensionEvent<Row> event) {
                this.this$1.notifyIDrawingChanged();
            }

            public final void selectedCountChanged() {
                this.this$1.notifyIDrawingChanged();
            }
        };
        private SelectionListener<Bin> probingListener$211cab67 = new SelectionListener<Bin>(this){
            private /* synthetic */ FilterIDrawing this$1;
            {
                void var1_1;
                this.this$1 = var1_1;
            }

            public final void selectionChanged(SelectionEvent<Bin> event) {
                this.this$1.notifyIDrawingChanged();
            }
        };
        private /* synthetic */ AbstractCategoricalFilterComponent this$0;

        /*
         * WARNING - void declaration
         */
        public FilterIDrawing(AbstractCategoricalFilterComponent this$0) {
            void var1_1;
            this.this$0 = this$0;
            this$0.dimension.addDimensionListener(this.dimensionListener$413329af);
            this$0.dimension.getFilterExact().addWeakSelectionListener(this.selectionListener$211cab67);
            var1_1.probing.addWeakSelectionListener(this.probingListener$211cab67);
        }

        public boolean isActive() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public void draw(IGraphics g, Point2D point, double width, double height2, Rectangle clipBounds) {
            int clipY2;
            this.width = (int)width;
            this.height = (int)height2;
            CPColor background = ((ColorTheme)this.this$0.getColorTheme().getValue()).getBackground();
            if (background != null) {
                g.setColor(background);
                g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height2));
            }
            g.setTextBaseline(IGraphics.TextBaseline.Middle);
            int clipY1 = this.this$0.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal ? clipBounds.y : clipBounds.x;
            int n = clipY2 = this.this$0.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal ? clipBounds.y + clipBounds.height : clipBounds.x + clipBounds.width;
            if (this.this$0.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Vertical) {
                FilterIDrawing height2 = this;
                int w2 = height2.width / 2;
                height2 = this;
                int h2 = height2.height / 2;
                g.translate(w2, h2);
                g.rotate(-1.5707963267948966);
                g.translate(-h2, -w2);
            }
            int start = Math.max(0, this.getIndex(clipY1));
            int end = Math.min(this.getIndex(clipY2), this.this$0.getBins().size() - 1);
            CumulativeShape previous = null;
            if (((Boolean)this.this$0.getShowCumulative().getValue()).booleanValue()) {
                for (int i = 0; i < start; ++i) {
                    Object value = this.this$0.getBins().get(i);
                    double count = this.this$0.getActiveCount(value);
                    previous = this.getCumulativeShape(i, count, previous);
                }
            }
            int probedIndex = -1;
            for (int i = start; i <= end; ++i) {
                Object value = this.this$0.getBins().get(i);
                previous = this.draw(g, i, value, previous);
                if (!this.this$0.probing.isActive() || !this.this$0.probing.isSelected(value)) continue;
                probedIndex = i;
            }
            if (probedIndex >= 0) {
                void var3_6;
                void var1_1;
                Object value = this.this$0.getBins().get(probedIndex);
                this.draw((IGraphics)var1_1, (int)var3_6, value, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private int getIndex(int y) {
            void var3_5;
            void var1_1;
            void var2_4;
            int n;
            if (this.this$0.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal) {
                FilterIDrawing filterIDrawing = this;
                n = filterIDrawing.height;
            } else {
                FilterIDrawing filterIDrawing = this;
                n = filterIDrawing.width;
            }
            int height = n;
            long idealHeight = this.this$0.computeIdealHeight((int)var2_4);
            return (int)((long)var1_1 * (long)this.this$0.getBins().size() / var3_5);
        }

        /*
         * WARNING - void declaration
         */
        private CumulativeShape draw(IGraphics g2, int i2, Bin bin, CumulativeShape previous) {
            double d;
            CPColor labelColor;
            Object fillColor;
            CPColor outlineColor;
            if (!((Boolean)this.this$0.getProportional().getValue()).booleanValue()) {
                CumulativeShape unfilteredShape = this.getCumulativeShape(i2, this.this$0.getCount(bin), null);
                g2.setColor(this.this$0.factory.createRGBColor(245, 245, 245));
                g2.fillShape((Shape)unfilteredShape.getShape());
            }
            CumulativeShape cumulativeShape = this.getCumulativeShape(i2, this.this$0.getActiveCount(bin), previous);
            Rectangle2D.Double shape = cumulativeShape.getShape();
            State state = this.this$0.getState(bin);
            Palette palette = ((ColorTheme)this.this$0.getColorTheme().getValue()).getPalette();
            switch (state.ordinal()) {
                case 0: {
                    outlineColor = null;
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? palette.getColor(0.3) : null;
                    labelColor = palette.getColor(0.7);
                    break;
                }
                case 1: {
                    outlineColor = ((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing();
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? labelColor.getColor(0.3) : null;
                    labelColor = ((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing();
                    break;
                }
                case 2: {
                    outlineColor = labelColor.getColor(1.0);
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? labelColor.getColor(0.55) : ((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection();
                    labelColor = labelColor.getColor(1.0);
                    break;
                }
                case 3: {
                    outlineColor = ((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing();
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? labelColor.getColor(0.55) : ((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection();
                    labelColor = ((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing();
                    break;
                }
                case 4: {
                    if (((Boolean)this.this$0.getShowDistribution().getValue()).booleanValue()) {
                        outlineColor = labelColor.getColor(0.5);
                        fillColor = labelColor.getColor(0.1);
                    } else {
                        outlineColor = null;
                        fillColor = null;
                    }
                    labelColor = labelColor.getColor(0.3);
                    break;
                }
                case 5: {
                    outlineColor = ((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing();
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? labelColor.getColor(0.1) : null;
                    labelColor = labelColor.getColor(0.7);
                    break;
                }
                case 6: {
                    outlineColor = null;
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? labelColor.getColor(0.05) : null;
                    labelColor = labelColor.getColor(0.2);
                    break;
                }
                default: {
                    outlineColor = this.this$0.factory.createRGBColor(255, 0, 0);
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? this.this$0.factory.getGray() : null;
                    labelColor = null;
                }
            }
            if (fillColor != null) {
                g2.setColor(fillColor);
                g2.fillShape((Shape)shape);
            }
            if (outlineColor != null) {
                g2.setColor(outlineColor);
                g2.drawShape((Shape)shape);
            }
            double selectedCount = this.this$0.getSelectedCount(bin);
            if (d > 0.0) {
                CumulativeShape selectedShape = this.getCumulativeShape(i2, selectedCount, null);
                g2.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                g2.fillShape((Shape)selectedShape.getShape());
            }
            if (((Boolean)this.this$0.getShowCumulative().getValue()).booleanValue() && previous != null) {
                void var2_5;
                int n;
                g2.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getVisiblePalette().getColor(0.75));
                double maxCount = this.getSum();
                if (this.this$0.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal) {
                    FilterIDrawing i2 = this;
                    n = i2.width - 1;
                } else {
                    FilterIDrawing i2 = this;
                    n = i2.height - 1;
                }
                int fullX = n;
                double x1 = Math.max(1.0, (double)fullX * previous.getSum() / maxCount);
                double x2 = Math.max(1.0, (double)var2_5 * cumulativeShape.getSum() / maxCount);
                g2.drawLine((int)x1, (int)previous.getShape().getCenterY(), (int)x2, (int)shape.getCenterY());
            }
            if (labelColor != null) {
                void var3_6;
                String text;
                g2.setColor(labelColor);
                if (this.this$0.format != null) {
                    text = bin != null ? this.this$0.format.formatHtml(bin, true) : (String)this.this$0.getNullLabel().getValue();
                } else {
                    String string = text = bin != null ? bin.toString() : (String)this.this$0.getNullLabel().getValue();
                }
                if (shape.getHeight() >= this.this$0.getTextHeight(g2) || this.this$0.probing.isActive() && this.this$0.probing.isSelected((Object)var3_6)) {
                    void var1_1;
                    var1_1.drawString(text, 2.0f, (float)(shape.getY() + shape.getHeight() / 2.0));
                }
            }
            return cumulativeShape;
        }

        /*
         * WARNING - void declaration
         */
        private CumulativeShape getCumulativeShape(int i, double count, CumulativeShape previous) {
            void var2_2;
            void var1_1;
            double width;
            int fullX;
            int n;
            int n2;
            FilterIDrawing filterIDrawing;
            if (this.this$0.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal) {
                filterIDrawing = this;
                n2 = filterIDrawing.height - 1;
            } else {
                filterIDrawing = this;
                n2 = filterIDrawing.width - 1;
            }
            int fullY = n2;
            float y1 = (float)i * (float)fullY / (float)this.this$0.getBins().size();
            float y2 = (float)(i + 1) * (float)fullY / (float)this.this$0.getBins().size();
            if (this.this$0.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal) {
                filterIDrawing = this;
                n = filterIDrawing.width - 1;
            } else {
                filterIDrawing = this;
                n = fullX = filterIDrawing.height - 1;
            }
            if (((Boolean)this.this$0.getShowDistribution().getValue()).booleanValue()) {
                double maxCount = this.getMax();
                width = Math.max(1.0, (double)fullX * count / maxCount);
            } else {
                width = Math.max(1, fullX);
            }
            float height = Math.max(1.0f, y2 - y1 - (float)(var1_1 < this.this$0.getBins().size() - 1 ? (Integer)this.this$0.getGapSize().getValue() : 0));
            return new CumulativeShape(new Rectangle2D.Double(0.0, (double)y1, width, (double)height), previous != null ? previous.getSum() + count : var2_2);
        }

        private double getSum() {
            if (this.this$0.group != null) {
                if (((Boolean)this.this$0.getProportional().getValue()).booleanValue()) {
                    return (float)this.this$0.group.getActiveSumValue();
                }
                return (float)this.this$0.group.getSumValue();
            }
            if (((Boolean)this.this$0.getProportional().getValue()).booleanValue()) {
                return (float)this.this$0.dimension.getSumActiveDensity();
            }
            return (float)this.this$0.dimension.getSumDensity();
        }

        private double getMax() {
            if (this.this$0.group != null) {
                if (((Boolean)this.this$0.getProportional().getValue()).booleanValue()) {
                    return (float)this.this$0.group.getActiveMaxValue();
                }
                return (float)this.this$0.group.getMaxValue();
            }
            if (((Boolean)this.this$0.getProportional().getValue()).booleanValue()) {
                return (float)this.this$0.dimension.getMaxActiveDensity();
            }
            return (float)this.this$0.dimension.getMaxDensity();
        }
    }
}

