/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import net.postgis.jdbc.DriverWrapper;
import org.postgresql.Driver;

public class DriverWrapperAutoprobe
extends DriverWrapper {
    public static final String POSTGIS_AUTOPROTOCOL = "jdbc:postgresql_autogis:";
    public static final String REVISIONAUTO = "$Revision$";

    @Override
    protected String getProtoString() {
        return POSTGIS_AUTOPROTOCOL;
    }

    @Override
    protected boolean useLW(Connection conn) {
        try {
            return DriverWrapperAutoprobe.supportsEWKB(conn);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static String getVersion() {
        return "PostGisWrapperAutoprobe $Revision$, wrapping " + Driver.getVersion();
    }

    public static boolean supportsEWKB(Connection conn) throws SQLException {
        int idx;
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT postgis_version()");
        rs.next();
        String version = rs.getString(1);
        rs.close();
        stat.close();
        if (version == null) {
            throw new SQLException("postgis_version returned NULL!");
        }
        int majorVersion = Integer.parseInt((version = version.trim()).substring(0, idx = version.indexOf(46)));
        return majorVersion >= 1;
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new DriverWrapperAutoprobe()));
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "Error registering PostGIS Autoprobe Wrapper Driver", e);
        }
    }
}

