/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.table.AbstractTableCellEditor;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class SpinnerTableCellEditor
extends AbstractTableCellEditor<JSpinner> {
    public SpinnerTableCellEditor(TableCellEditor defaultEditor) {
        super(defaultEditor);
    }

    @Override
    public JSpinner createEditorComponent() {
        JSpinner c = new JSpinner();
        c.putClientProperty("Synthetica.opaque", false);
        return c;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component c = SyntheticaLookAndFeel.findComponent((String)"Spinner.formattedTextField", (Container)SpinnerTableCellEditor.this.editorComponent);
                if (c != null) {
                    c.requestFocusInWindow();
                }
            }
        });
        return c;
    }

    @Override
    public void setCellEditorValue(Object value) {
        this.modelDriven = value instanceof SpinnerModel;
        if (value instanceof SpinnerNumberModel) {
            SpinnerNumberModel model = (SpinnerNumberModel)value;
            SpinnerNumberModel m = new SpinnerNumberModel((Number)model.getValue(), model.getMinimum(), model.getMaximum(), model.getStepSize());
            ((JSpinner)this.editorComponent).setModel(m);
        } else if (value instanceof Number) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)this.editorComponent).getModel();
            SpinnerNumberModel m = new SpinnerNumberModel((Number)value, model.getMinimum(), model.getMaximum(), model.getStepSize());
            ((JSpinner)this.editorComponent).setModel(m);
        } else {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " supports value types of SpinnerNumberModel and Number only!");
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.modelDriven) {
            return ((JSpinner)this.editorComponent).getModel();
        }
        return ((JSpinner)this.editorComponent).getValue();
    }
}

