/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.TextAreaLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingx.JXTipOfTheDay;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.BasicTipOfTheDayUI;
import org.jdesktop.swingx.tips.TipOfTheDayModel;

public class TipOfTheDayUI
extends BasicTipOfTheDayUI {
    public TipOfTheDayUI(JXTipOfTheDay tipPane) {
        super(tipPane);
    }

    public static ComponentUI createUI(JComponent c) {
        return new TipOfTheDayUI((JXTipOfTheDay)c);
    }

    protected void installComponents() {
        this.tipPane.setLayout((LayoutManager)new BorderLayout());
        JPanel tipIcon = new JPanel(null){
            private static final long serialVersionUID = -8214509584793918142L;
            private int w;
            private int h;
            private Image image;
            {
                String imagePath = UIManager.getString("Synthetica.tipOfTheDay.icon");
                this.image = new ImageIcon(SyntheticaLookAndFeel.getResource((String)imagePath)).getImage();
                this.w = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(this.image.getWidth(null)));
                this.h = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(this.image.getHeight(null)));
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(this.w, this.h);
            }

            @Override
            protected void paintComponent(Graphics g) {
                g.drawImage(this.image, 0, 0, this.w, this.h, null);
            }
        };
        this.tipPane.add((Component)tipIcon, (Object)"West");
        JPanel rightPane = new JPanel(new BorderLayout());
        rightPane.setName("JXTipOfTheDay.EastPanel");
        JLabel didYouKnow = new JLabel(UIManagerExt.getString((Object)"TipOfTheDay.didYouKnowText", (Locale)this.tipPane.getLocale())){
            private static final long serialVersionUID = -3777618872544570049L;

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paintComponent(g2);
            }
        };
        didYouKnow.setPreferredSize(SyntheticaLookAndFeel.getInstance().scaleDimension(50, 32));
        didYouKnow.setOpaque(true);
        didYouKnow.setBackground(SyntheticaLookAndFeel.getColor((String)"TextField.background", (Component)this.tipPane));
        didYouKnow.setBorder(new CompoundBorder(SyntheticaLookAndFeel.getInstance().createMatteBorder(0, 0, 2, 0, this.tipPane.getBackground(), true), SyntheticaLookAndFeel.getInstance().createEmptyBorder(4, 4, 4, 4, true)));
        didYouKnow.setFont(didYouKnow.getFont().deriveFont(1, (float)didYouKnow.getFont().getSize() + 4.0f));
        rightPane.add((Component)didYouKnow, "North");
        this.tipArea = new JPanel(new BorderLayout());
        this.tipArea.setName("JXTipOfTheDay.TipPanel");
        this.tipArea.setOpaque(true);
        this.tipArea.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(4, 4, 4, 4, true));
        this.tipArea.setBackground(SyntheticaLookAndFeel.getColor((String)"TextField.background", (Component)this.tipPane));
        rightPane.add(this.tipArea);
        this.tipPane.add((Component)rightPane);
        this.tipPane.setBorder(SyntheticaLookAndFeel.getInstance().createLineBorder(this.tipPane.getBackground(), true));
    }

    public Dimension getPreferredSize(JComponent c) {
        return SyntheticaLookAndFeel.getInstance().scaleDimension(420, 175, true);
    }

    protected void showCurrentTip() {
        int currentTip;
        if (this.currentTipComponent != null) {
            this.tipArea.remove(this.currentTipComponent);
        }
        if ((currentTip = this.tipPane.getCurrentTip()) == -1) {
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setBackground(Color.WHITE);
            this.currentTipComponent = label;
            this.tipArea.add(this.currentTipComponent);
            return;
        }
        if (this.tipPane.getModel() == null || this.tipPane.getModel().getTipCount() == 0 || currentTip < 0 && currentTip >= this.tipPane.getModel().getTipCount()) {
            this.currentTipComponent = new JLabel();
        } else {
            TipOfTheDayModel.Tip tip = this.tipPane.getModel().getTipAt(currentTip);
            Object tipObject = tip.getTip();
            if (tipObject instanceof Component) {
                this.currentTipComponent = (Component)tipObject;
            } else if (tipObject instanceof Icon) {
                this.currentTipComponent = new JLabel((Icon)tipObject);
            } else {
                String text;
                JScrollPane tipScroll = new JScrollPane();
                tipScroll.setBorder(null);
                tipScroll.setOpaque(false);
                tipScroll.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                tipScroll.getViewport().setOpaque(false);
                tipScroll.setBorder(null);
                String string = text = tipObject == null ? "" : tipObject.toString();
                if (text.toLowerCase().startsWith("<html>")) {
                    JTextPane editor = new JTextPane();
                    editor.setEditorKit(new HTMLEditorKit());
                    editor.setContentType("text/html");
                    editor.setText(text);
                    editor.setEditable(false);
                    editor.setFont(editor.getFont().deriveFont((float)editor.getFont().getSize() + 2.0f));
                    editor.setBorder(null);
                    editor.setMargin(null);
                    editor.setOpaque(false);
                    editor.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                    tipScroll.getViewport().setView(editor);
                } else {
                    TextAreaLabel area = new TextAreaLabel(text);
                    area.setFocusable(true);
                    area.setFont(area.getFont().deriveFont((float)area.getFont().getSize() + 2.0f));
                    tipScroll.getViewport().setView(area);
                }
                this.currentTipComponent = tipScroll;
            }
        }
        this.tipArea.add(this.currentTipComponent);
        this.tipArea.revalidate();
        this.tipArea.repaint();
    }

    protected JDialog createDialog(Component parentComponent, final JXTipOfTheDay.ShowOnStartupChoice choice, boolean showPreviousButton) {
        JCheckBox showOnStartupBox;
        Locale locale = parentComponent == null ? null : parentComponent.getLocale();
        String title = UIManagerExt.getString((Object)"TipOfTheDay.dialogTitle", (Locale)locale);
        Window window = parentComponent == null ? JOptionPane.getRootFrame() : (parentComponent instanceof Window ? (Window)parentComponent : SwingUtilities.getWindowAncestor(parentComponent));
        final JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        int gap = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(10));
        dialog.getContentPane().setLayout(new BorderLayout(gap, gap));
        dialog.getContentPane().add((Component)this.tipPane, "Center");
        ((JComponent)dialog.getContentPane()).setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(10, 10, 10, 10, true));
        JPanel controls = new JPanel(new BorderLayout());
        dialog.add("South", controls);
        if (choice != null) {
            showOnStartupBox = new JCheckBox(UIManagerExt.getString((Object)"TipOfTheDay.showOnStartupText", (Locale)locale), choice.isShowingOnStartup());
            controls.add((Component)showOnStartupBox, "Center");
        } else {
            showOnStartupBox = null;
        }
        JPanel buttons = new JPanel(new GridLayout(1, showPreviousButton ? 3 : 2, SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(9)), 0));
        controls.add((Component)buttons, "After");
        if (showPreviousButton) {
            JButton previousTipButton = new JButton(UIManagerExt.getString((Object)"TipOfTheDay.previousTipText", (Locale)locale));
            buttons.add(previousTipButton);
            previousTipButton.addActionListener(this.getActionMap().get("previousTip"));
        }
        JButton nextTipButton = new JButton(UIManagerExt.getString((Object)"TipOfTheDay.nextTipText", (Locale)locale));
        buttons.add(nextTipButton);
        nextTipButton.addActionListener(this.getActionMap().get("nextTip"));
        JButton closeButton = new JButton(UIManagerExt.getString((Object)"TipOfTheDay.closeText", (Locale)locale));
        buttons.add(closeButton);
        final ActionListener saveChoice = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (choice != null) {
                    choice.setShowingOnStartup(showOnStartupBox.isSelected());
                }
                dialog.setVisible(false);
            }
        };
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dialog.setVisible(false);
                saveChoice.actionPerformed(null);
            }
        });
        dialog.getRootPane().setDefaultButton(closeButton);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                saveChoice.actionPerformed(null);
            }
        });
        ((JComponent)dialog.getContentPane()).registerKeyboardAction(saveChoice, KeyStroke.getKeyStroke(27, 0), 2);
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        return dialog;
    }
}

