/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document;

import com.macrofocus.application.file.CPFileManager;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.persistence.xom.XomElement;
import com.macrofocus.persistence.xom.XomElementFactory;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.swing.FileChooserFactory;
import com.treemap.AggregationFactory;
import com.treemap.AlgorithmFactory;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.document.persistence.TreeMapPersistence;
import com.treemap.app.java.document.persistence.DefaultColorMapState;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;

public class ImportSettingsUICommand
extends AbstractUICommand {
    private final FileChooserFactory fileChooserFactory;
    private final JFrame window;
    private TreeMapDocument document;

    public ImportSettingsUICommand(FileChooserFactory fileChooserFactory, JFrame window, CPFileManager<JFrame, File> fileManager, ResourcesModel resourcesModel) {
        super(resourcesModel.getPropertiesModel().getProperty("action.importsettings.label"));
        this.fileChooserFactory = fileChooserFactory;
        this.window = window;
    }

    public void execute(Object source) {
        File file;
        FileFilter fileFilter = null;
        do {
            JFileChooser fileChooser;
            int value;
            if ((value = (fileChooser = this.fileChooserFactory.getFileChooser()).showOpenDialog(this.window)) != 0) {
                return;
            }
            file = fileChooser.getSelectedFile();
            fileFilter = fileChooser.getFileFilter();
        } while (file == null || !file.exists() || fileFilter == null);
        Builder builder = new Builder(false);
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            Document treemap = builder.build((InputStream)bis);
            nu.xom.Element root = treemap.getRootElement();
            if (root.getLocalName().equals("TreeMap")) {
                XomElementFactory elementFactory = new XomElementFactory();
                TreeMapPersistence persistance = new TreeMapPersistence(this.document, (CPColorFactory)SwingFactory.getInstance(), (CPFontFactory)SwingFactory.getInstance(), AggregationFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), AlgorithmFactory.getInstance(), (ElementFactory)elementFactory, new DefaultColorMapState(SwingFactory.getInstance(), SwingPaletteFactory.getInstance(), (ElementFactory)elementFactory));
                persistance.load((Element)new XomElement(treemap.getRootElement()));
            }
        }
        catch (ParsingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDocument(TreeMapDocument document) {
        this.document = document;
        this.enabledProperty().setValue((Object)(document != null ? 1 : 0));
    }
}

