/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document.export;

import com.macrofocus.geom.Rectangle;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.HtmlFileFilter;
import com.macrofocus.util.swing.export.format.AbstractGraphicsExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class HTMLExportFormat
extends AbstractGraphicsExportFormat {
    public boolean isValid() {
        return true;
    }

    public AbstractFileFilter getFileFilter() {
        return new HtmlFileFilter();
    }

    public Component getSettingsPanel() {
        return null;
    }

    public void save(ContentProvider<Component> contentProvider, File file) throws IOException {
        if (contentProvider.getContent() instanceof TreeMapView) {
            Rectangle rect;
            CPColor color;
            TreeMapView view = (TreeMapView)contentProvider.getContent();
            TreeMapModel model = view.getModel();
            PrintStream os = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
            os.println("<html>");
            os.println(" <head> ");
            os.println("   <script type=\"application/javascript\">  ");
            os.println("    function draw() {  ");
            os.println("      var canvas = document.getElementById(\"canvas\"); ");
            os.println("      if (canvas.getContext) {  ");
            os.println("        var ctx = canvas.getContext(\"2d\");  ");
            for (Object node : model.breadthFirstIterator(model.getCurrentRoot())) {
                if (model.hasNoChildren(node) || (color = model.getColor(node)) == null) continue;
                rect = model.getShape(node).getBounds();
                os.println("        ctx.fillStyle = \"rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")\"; ");
                os.println("        ctx.fillRect (" + rect.x + "," + rect.y + "," + rect.width + "," + rect.height + ");  ");
            }
            for (Object node : model.breadthFirstIterator(model.getCurrentRoot())) {
                if (!model.hasNoChildren(node)) continue;
                color = model.getColor(node);
                rect = model.getShape(node).getBounds();
                os.println("        ctx.fillStyle = \"rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")\"; ");
                os.println("        ctx.fillRect (" + rect.x + "," + rect.y + "," + rect.width + "," + rect.height + ");  ");
            }
            os.println();
            os.println("      }  ");
            os.println("    }  ");
            os.println("  </script>");
            os.println("</head>  ");
            os.println(" <body onload=\"draw();\">  ");
            os.println("   <canvas id=\"canvas\" width=\"" + model.getSettings().getDimension().width + "\" height=\"" + model.getSettings().getDimension().height + "\"></canvas>  ");
            os.println(" </body>  ");
            os.println();
            os.println();
            os.println();
            os.println();
            os.println();
            os.println("</html>");
            os.flush();
            os.close();
        }
    }
}

