/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.importer;

import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.swing.SwingDataFrameFactory;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.DefaultContentProvider;
import com.macrofocus.util.swing.export.format.XMLGraphicsPDFExportFormat;
import com.treemap.swing.venn.VennView;
import edu.uic.ncdm.venn.VennAnalytic;
import edu.uic.ncdm.venn.VennDiagram;
import edu.uic.ncdm.venn.data.VennData;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;

public class Nationalities {
    public Nationalities() throws IOException {
        long start = System.currentTimeMillis();
        String localStore = "/Users/luc/macrofocus/dataset/treemap/Nationalities";
        File dir = new File("/Users/luc/macrofocus/dataset/treemap/Nationalities");
        if (!dir.exists()) {
            dir.mkdir();
        }
        MutableDataFrame dataFrame = SwingDataFrameFactory.fromCSV((URL)Nationalities.class.getResource("nationalities.csv"));
        String[][] data = new String[dataFrame.getRowCount()][1];
        double[] areas = new double[dataFrame.getRowCount()];
        int i = 0;
        for (Object row : dataFrame.rows()) {
            data[i][0] = (String)dataFrame.getValueAt(row, (Object)"data");
            areas[i] = ((Number)dataFrame.getValueAt(row, (Object)"area")).doubleValue();
            ++i;
        }
        VennData vennData = new VennData(data, areas, true);
        VennAnalytic vennAnalytic = new VennAnalytic();
        vennAnalytic.computeInitialConfiguration();
        VennDiagram vennDiagram = vennAnalytic.compute(vennData);
        Rectangle2D.Double bounds = null;
        for (int i2 = 0; i2 < vennDiagram.diameters.length; ++i2) {
            double radius = vennDiagram.diameters[i2] / 2.0;
            double x = vennDiagram.centers[i2][0] - radius;
            double y = vennDiagram.centers[i2][1] - radius;
            Rectangle2D.Double b = new Rectangle2D.Double(x, y, vennDiagram.diameters[i2], vennDiagram.diameters[i2]);
            if (bounds == null) {
                bounds = b;
                continue;
            }
            bounds.add(b);
        }
        System.err.println(System.currentTimeMillis() - start + " ms");
        System.err.println("Stress: " + new DecimalFormat("0.0000").format(vennDiagram.stress));
        VennView view = new VennView(vennDiagram);
        view.setSize(500, 500);
        XMLGraphicsPDFExportFormat exportFormat = new XMLGraphicsPDFExportFormat();
        exportFormat.save((ContentProvider)new DefaultContentProvider((Object)view), new File(dir, "Nationalities.pdf"));
    }

    public static void main(String[] args) {
        try {
            new Nationalities();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

