/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation.treeplot;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.combobox.MListComboBox;
import com.macrofocus.selection.swing.SingleSelectionButtonModel;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.treemap.app.swing.configuration.TreePlotSettingsPanel;
import com.treemap.app.swing.presentation.implementation.AttributeCellRenderer;
import com.treemap.app.swing.presentation.implementation.PathPanel;
import com.treemap.treeplot.TreePlot;
import com.treemap.treeplot.TreePlotModel;
import com.treemap.treeplot.TreePlotPanel;
import com.treemap.treeplot.TreePlotView;
import de.javasoft.syntheticaaddons.SimpleDropDownButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.OverlayLayout;

public class SwingTreePlotPanel<N, Column>
extends JPanel
implements TreePlotPanel<JComponent> {
    private final PathPanel pathPanel;
    private final TreePlot treePlot;
    private JPanel mainPanel;
    private JPanel toolBarContainer;
    private JPanel snapshotPanel;
    private JPanel desktopContainer;
    private MListComboBox yComboBox;
    private MListComboBox sizeComboBox;
    private JCheckBox sizeCheckBox;
    private MListComboBox xComboBox;
    private JCheckBox lockScalesCheckBox;
    private JComboBox boundingComboBox;
    private SimpleDropDownButton settingsDropDownButton;
    private JCheckBox useGroupByCheckBox;
    private final com.treemap.swing.treeplot.SwingTreePlotPanel zoomablePlotPanel;

    public SwingTreePlotPanel(TreePlot treePlot) {
        this.treePlot = treePlot;
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.boundingComboBox.setModel(new SingleSelectionComboBoxModel(treePlot.getView().getBoundingMode(), (Object[])TreePlotView.BoundingMode.values()));
        this.zoomablePlotPanel = new com.treemap.swing.treeplot.SwingTreePlotPanel(treePlot);
        this.desktopContainer.setLayout(new OverlayLayout(this.desktopContainer));
        this.desktopContainer.add((Component)this.zoomablePlotPanel);
        this.add((Component)this.mainPanel, "Center");
        this.pathPanel = new PathPanel();
        this.pathPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        this.add((Component)this.pathPanel, "South");
        this.pathPanel.setVisible(false);
        this.settingsDropDownButton.setPreferredHorizontalPopupMenuPosition(4);
        this.setModel(treePlot.getModel());
        this.xComboBox.setRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        this.yComboBox.setRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        this.sizeComboBox.setRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        this.mainPanel.validate();
    }

    public void setModel(TreePlotModel<N, ?, Column, Color, Font> model) {
        this.settingsDropDownButton.getPopupMenu().removeAll();
        if (model != null) {
            this.treePlot.setModel(model);
            this.pathPanel.setModel(model.getTreeMapModel());
            Iterable xTreeMapFields = this.treePlot.getModel().getXTreeMapFields();
            Iterable yTreeMapFields = this.treePlot.getModel().getYTreeMapFields();
            this.xComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(model.getXVariable(), xTreeMapFields));
            this.yComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(model.getYVariable(), yTreeMapFields));
            this.settingsDropDownButton.setPopupMenu(new JPopupMenu(){

                @Override
                public void menuSelectionChanged(boolean isIncluded) {
                    super.menuSelectionChanged(true);
                }
            });
            this.settingsDropDownButton.getPopupMenu().add(new TreePlotSettingsPanel(model).getMainPanel());
            this.useGroupByCheckBox.setModel((ButtonModel)new SingleSelectionButtonModel(model.getSettings().groupByProperty()));
        }
    }

    public JComponent getSnapshotPanel() {
        return (JComponent)this.zoomablePlotPanel.getAxisPlotPanel().getSnapshotPanel();
    }

    public JComponent getNativeComponent() {
        return this;
    }

    private void createUIComponents() {
        this.xComboBox = new MListComboBox();
        this.yComboBox = new MListComboBox();
        this.sizeComboBox = new MListComboBox();
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.toolBarContainer = new JPanel();
        this.toolBarContainer.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)this.toolBarContainer, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 0, new Dimension(1, -1), new Dimension(1, -1), null, 0, false));
        this.snapshotPanel = new JPanel();
        this.snapshotPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)this.snapshotPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 8, new Insets(0, 0, 0, 0), -1, -1));
        this.snapshotPanel.add((Component)panel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel2.add((Component)spacer1, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Y: ");
        panel2.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.yComboBox = new MListComboBox();
        this.yComboBox.setFocusable(true);
        panel2.add((Component)this.yComboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(170, -1), null, 0, false));
        this.sizeComboBox = new MListComboBox();
        this.sizeComboBox.setFocusable(true);
        this.sizeComboBox.setVisible(false);
        panel2.add((Component)this.sizeComboBox, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.sizeCheckBox = new JCheckBox();
        this.sizeCheckBox.setText("RELATIVE SIZE: ");
        this.sizeCheckBox.setVisible(false);
        panel2.add((Component)this.sizeCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.boundingComboBox = new JComboBox();
        this.boundingComboBox.setVisible(false);
        panel2.add((Component)this.boundingComboBox, new GridConstraints(0, 7, 1, 1, 8, 1, 0, 0, null, null, null, 0, false));
        this.settingsDropDownButton = new SimpleDropDownButton();
        panel2.add((Component)this.settingsDropDownButton, new GridConstraints(0, 6, 1, 1, 0, 0, 3, 3, null, null, null, 1, false));
        this.useGroupByCheckBox = new JCheckBox();
        this.useGroupByCheckBox.setMargin(new Insets(1, 1, 0, 6));
        this.useGroupByCheckBox.setText("Use Grouping to Aggregate Bubbles");
        panel2.add((Component)this.useGroupByCheckBox, new GridConstraints(0, 5, 1, 1, 8, 0, 3, 0, null, null, null, 1, false));
        this.desktopContainer = new JPanel();
        this.desktopContainer.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.snapshotPanel.add((Component)this.desktopContainer, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.snapshotPanel.add((Component)panel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("X: ");
        panel3.add((Component)label2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.xComboBox = new MListComboBox();
        this.xComboBox.setFocusable(true);
        panel3.add((Component)this.xComboBox, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 3, null, new Dimension(170, -1), null, 0, false));
        this.lockScalesCheckBox = new JCheckBox();
        this.lockScalesCheckBox.setText("LOCK SCALES");
        this.lockScalesCheckBox.setVisible(false);
        panel3.add((Component)this.lockScalesCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

