/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation.treetable;

import com.jidesoft.grid.TreeTable;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.treemap.AbstractTreeMapNode;
import com.treemap.app.swing.presentation.implementation.TreeMapRow;
import java.util.ArrayList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TreeTableSelectionCoordinator {
    private boolean updating = false;

    public TreeTableSelectionCoordinator(final TreeTable treeTable, final ListSelectionModel listSelectionModel, final MutableSelection<AbstractTreeMapNode> selection) {
        selection.addSelectionListener((SelectionListener)new SelectionListener<AbstractTreeMapNode>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void selectionChanged(SelectionEvent<AbstractTreeMapNode> event) {
                if (!TreeTableSelectionCoordinator.this.updating) {
                    TreeTableSelectionCoordinator.this.updating = true;
                    try {
                        for (AbstractTreeMapNode node : event.getAffected()) {
                            if (!selection.isSelected((Object)node)) continue;
                            this.expand(node);
                        }
                        listSelectionModel.setValueIsAdjusting(true);
                        for (int i = 0; i < treeTable.getModel().getRowCount(); ++i) {
                            TreeMapRow hierarchyRow = (TreeMapRow)treeTable.getRowAt(i);
                            if (hierarchyRow == null) continue;
                            AbstractTreeMapNode o = hierarchyRow.getNode();
                            if (selection.isSelected((Object)o)) {
                                listSelectionModel.addSelectionInterval(i, i);
                                treeTable.scrollRowToVisible(i);
                                continue;
                            }
                            listSelectionModel.removeSelectionInterval(i, i);
                        }
                        listSelectionModel.setValueIsAdjusting(false);
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                    }
                    catch (Error ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        TreeTableSelectionCoordinator.this.updating = false;
                    }
                }
            }

            private void expand(AbstractTreeMapNode node) {
                if (node != null) {
                    AbstractTreeMapNode[] path = node.getPath();
                    block0: for (int i = 0; i < path.length; ++i) {
                        AbstractTreeMapNode treeNode = path[i];
                        for (int r = 0; r < treeTable.getModel().getRowCount(); ++r) {
                            AbstractTreeMapNode o;
                            TreeMapRow hierarchyRow = (TreeMapRow)treeTable.getRowAt(r);
                            if (hierarchyRow == null || !(o = hierarchyRow.getNode()).equals(treeNode)) continue;
                            treeTable.expandRow(r, true);
                            continue block0;
                        }
                    }
                }
            }
        });
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting() && !TreeTableSelectionCoordinator.this.updating) {
                    TreeTableSelectionCoordinator.this.updating = true;
                    try {
                        if (!listSelectionModel.isSelectionEmpty()) {
                            ArrayList<AbstractTreeMapNode> selected = new ArrayList<AbstractTreeMapNode>();
                            for (int r = 0; r < treeTable.getRowCount(); ++r) {
                                if (!listSelectionModel.isSelectedIndex(r)) continue;
                                TreeMapRow hierarchyRow = (TreeMapRow)treeTable.getRowAt(r);
                                AbstractTreeMapNode o = hierarchyRow.getNode();
                                selected.add(o);
                            }
                            selection.setSelectedIterable(selected);
                        } else {
                            selection.clearSelection();
                        }
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                    }
                    catch (Error ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        TreeTableSelectionCoordinator.this.updating = false;
                    }
                }
            }
        });
    }
}

