/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Calendar;
import java.util.Date;

public class CalendarUtils {
    public static final int ONE_MINUTE = 60000;
    public static final int ONE_HOUR = 3600000;
    public static final int THREE_HOURS = 10800000;
    public static final int ONE_DAY = 86400000;
    public static final int DECADE = 5467;
    public static final int YEAR_IN_DECADE = 5468;

    public static void add(Calendar calendar, int field, int amount) {
        if (CalendarUtils.isNativeField(field)) {
            calendar.add(field, amount);
        } else {
            switch (field) {
                case 5467: {
                    calendar.add(1, amount * 10);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported field: " + field);
                }
            }
        }
    }

    public static int get(Calendar calendar, int field) {
        if (CalendarUtils.isNativeField(field)) {
            return calendar.get(field);
        }
        switch (field) {
            case 5467: {
                return CalendarUtils.decade(calendar.get(1));
            }
            case 5468: {
                return calendar.get(1) % 10;
            }
        }
        throw new IllegalArgumentException("unsupported field: " + field);
    }

    public static void set(Calendar calendar, int field, int value) {
        if (CalendarUtils.isNativeField(field)) {
            calendar.set(field, value);
        } else {
            switch (field) {
                case 5467: {
                    if (value <= 0) {
                        throw new IllegalArgumentException("value must be a positive but was: " + value);
                    }
                    if (value % 10 != 0) {
                        throw new IllegalArgumentException("value must be a multiple of 10 but was: " + value);
                    }
                    int yearInDecade = CalendarUtils.get(calendar, 5468);
                    calendar.set(1, value + yearInDecade);
                    break;
                }
                case 5468: {
                    int decade = CalendarUtils.get(calendar, 5467);
                    calendar.set(1, value + decade);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported field: " + field);
                }
            }
        }
    }

    private static boolean isNativeField(int calendarField) {
        return calendarField < 5467;
    }

    public static Date getEndOfDST(Calendar calendar) {
        if (!calendar.getTimeZone().useDaylightTime()) {
            return null;
        }
        long old = calendar.getTimeInMillis();
        calendar.set(2, 11);
        CalendarUtils.endOfMonth(calendar);
        CalendarUtils.startOfDay(calendar);
        int i = 0;
        while (i < 366) {
            calendar.add(5, -1);
            if (calendar.getTimeZone().inDaylightTime(calendar.getTime())) {
                CalendarUtils.endOfDay(calendar);
                return calendar.getTime();
            }
            ++i;
        }
        calendar.setTimeInMillis(old);
        return null;
    }

    public static Date getStartOfDST(Calendar calendar) {
        if (!calendar.getTimeZone().useDaylightTime()) {
            return null;
        }
        long old = calendar.getTimeInMillis();
        calendar.set(2, 0);
        CalendarUtils.startOfMonth(calendar);
        CalendarUtils.endOfDay(calendar);
        int i = 0;
        while (i < 366) {
            calendar.add(5, 1);
            if (calendar.getTimeZone().inDaylightTime(calendar.getTime())) {
                CalendarUtils.endOfDay(calendar);
                return calendar.getTime();
            }
            ++i;
        }
        calendar.setTimeInMillis(old);
        return null;
    }

    public static boolean isStartOfDay(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, -1);
        return temp.get(5) != calendar.get(5);
    }

    public static boolean isEndOfDay(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, 1);
        return temp.get(5) != calendar.get(5);
    }

    public static boolean isStartOfMonth(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, -1);
        return temp.get(2) != calendar.get(2);
    }

    public static boolean isEndOfMonth(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, 1);
        return temp.get(2) != calendar.get(2);
    }

    public static boolean isStartOfWeek(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, -1);
        return temp.get(3) != calendar.get(3);
    }

    public static boolean isEndOfWeek(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, 1);
        return temp.get(3) != calendar.get(3);
    }

    public static void startOfWeek(Calendar calendar) {
        calendar.set(7, calendar.getFirstDayOfWeek());
        CalendarUtils.startOfDay(calendar);
    }

    public static void endOfWeek(Calendar calendar) {
        CalendarUtils.startOfWeek(calendar);
        calendar.add(5, 7);
        calendar.add(14, -1);
    }

    public static Date endOfWeek(Calendar calendar, Date date) {
        calendar.setTime(date);
        CalendarUtils.endOfWeek(calendar);
        return calendar.getTime();
    }

    public static Date startOfWeek(Calendar calendar, Date date) {
        calendar.setTime(date);
        CalendarUtils.startOfWeek(calendar);
        return calendar.getTime();
    }

    public static void startOfDecade(Calendar calendar) {
        calendar.set(1, CalendarUtils.decade(calendar.get(1)));
        CalendarUtils.startOfYear(calendar);
    }

    private static int decade(int year) {
        return year / 10 * 10;
    }

    public static Date startOfDecade(Calendar calendar, Date date) {
        calendar.setTime(date);
        CalendarUtils.startOfDecade(calendar);
        return calendar.getTime();
    }

    public static boolean isStartOfDecade(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, -1);
        return CalendarUtils.decade(temp.get(1)) != CalendarUtils.decade(calendar.get(1));
    }

    public static void startOfYear(Calendar calendar) {
        calendar.set(2, 0);
        CalendarUtils.startOfMonth(calendar);
    }

    public static Date startOfYear(Calendar calendar, Date date) {
        calendar.setTime(date);
        CalendarUtils.startOfYear(calendar);
        return calendar.getTime();
    }

    public static boolean isStartOfYear(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, -1);
        return temp.get(1) != calendar.get(1);
    }

    public static void startOfMonth(Calendar calendar) {
        calendar.set(5, 1);
        CalendarUtils.startOfDay(calendar);
    }

    public static void endOfMonth(Calendar calendar) {
        calendar.add(2, 1);
        CalendarUtils.startOfMonth(calendar);
        calendar.add(14, -1);
    }

    public static Date startOfDay(Calendar calendar, Date date) {
        calendar.setTime(date);
        CalendarUtils.startOfDay(calendar);
        return calendar.getTime();
    }

    public static Date endOfDay(Calendar calendar, Date date) {
        calendar.setTime(date);
        CalendarUtils.endOfDay(calendar);
        return calendar.getTime();
    }

    public static void startOfDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.getTimeInMillis();
    }

    public static void endOfDay(Calendar calendar) {
        calendar.add(5, 1);
        CalendarUtils.startOfDay(calendar);
        calendar.add(14, -1);
    }

    public static void startOf(Calendar calendar, int field) {
        switch (field) {
            case 5: {
                CalendarUtils.startOfDay(calendar);
                break;
            }
            case 2: {
                CalendarUtils.startOfMonth(calendar);
                break;
            }
            case 3: {
                CalendarUtils.startOfWeek(calendar);
                break;
            }
            case 1: {
                CalendarUtils.startOfYear(calendar);
                break;
            }
            case 5467: {
                CalendarUtils.startOfDecade(calendar);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported field: " + field);
            }
        }
    }

    public static boolean isStartOf(Calendar calendar, int field) {
        switch (field) {
            case 5: {
                return CalendarUtils.isStartOfDay(calendar);
            }
            case 2: {
                return CalendarUtils.isStartOfMonth(calendar);
            }
            case 3: {
                return CalendarUtils.isStartOfWeek(calendar);
            }
            case 1: {
                return CalendarUtils.isStartOfYear(calendar);
            }
            case 5467: {
                return CalendarUtils.isStartOfDecade(calendar);
            }
        }
        throw new IllegalArgumentException("unsupported field: " + field);
    }

    public static boolean areEqual(Date current, Date date) {
        if (date == null && current == null) {
            return true;
        }
        if (date != null) {
            return date.equals(current);
        }
        return false;
    }

    public static boolean isSameDay(Calendar today, Date now) {
        Calendar temp = (Calendar)today.clone();
        CalendarUtils.startOfDay(temp);
        Date start = temp.getTime();
        temp.setTime(now);
        CalendarUtils.startOfDay(temp);
        return start.equals(temp.getTime());
    }

    public static boolean isSame(Calendar today, Date now, int field) {
        Calendar temp = (Calendar)today.clone();
        CalendarUtils.startOf(temp, field);
        Date start = temp.getTime();
        temp.setTime(now);
        CalendarUtils.startOf(temp, field);
        return start.equals(temp.getTime());
    }

    public static boolean isFlushed(Calendar calendar) {
        return !calendar.toString().contains("time=?");
    }
}

